/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.io.FileNotFoundException;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractJobExecutorAcquireJobsTest
extends AbstractProcessEngineTestCase {
    protected static final Date START_TIME = new Date(1430134560000L);

    protected void initializeProcessEngine() {
        ProcessEngineConfiguration processEngineConfiguration;
        try {
            processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof FileNotFoundException) {
                processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"activiti.cfg.xml");
            }
            throw ex;
        }
        if (this.isJobExecutorPreferTimerJobs()) {
            processEngineConfiguration.setJobExecutorPreferTimerJobs(true);
        }
        if (this.isJobExecutorPreferOldJobs()) {
            processEngineConfiguration.setJobExecutorAcquireByDueDate(true);
        }
        this.processEngine = processEngineConfiguration.buildProcessEngine();
    }

    protected void closeDownProcessEngine() {
        super.closeDownProcessEngine();
        this.processEngine.close();
        ProcessEngines.unregister((ProcessEngine)this.processEngine);
        this.processEngine = null;
    }

    protected boolean isJobExecutorPreferTimerJobs() {
        return false;
    }

    protected boolean isJobExecutorPreferOldJobs() {
        return false;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ClockUtil.setCurrentTime((Date)START_TIME);
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setJobExecutorPreferTimerJobs(false);
        this.processEngineConfiguration.setJobExecutorAcquireByDueDate(false);
        ClockUtil.reset();
        super.tearDown();
    }

    protected List<JobEntity> findAcquirableJobs() {
        return (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<List<JobEntity>>(){

            public List<JobEntity> execute(CommandContext commandContext) {
                return commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
            }
        });
    }

    protected void incrementClock(long seconds) {
        long time = ClockUtil.getCurrentTime().getTime();
        ClockUtil.setCurrentTime((Date)new Date(time + seconds * 1000L));
    }
}

