/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;

public class JobExecutorAcquireJobsByTypeTest
extends AbstractJobExecutorAcquireJobsTest {
    @Override
    protected boolean isJobExecutorPreferTimerJobs() {
        return true;
    }

    @Override
    protected boolean isJobExecutorPreferOldJobs() {
        return false;
    }

    public void testProcessEngineConfiguration() {
        ProcessEngineConfigurationImpl configuration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        JobExecutorAcquireJobsByTypeTest.assertTrue((boolean)configuration.isJobExecutorPreferTimerJobs());
        JobExecutorAcquireJobsByTypeTest.assertFalse((boolean)configuration.isJobExecutorAcquireByDueDate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testMessageJobHasNoDueDateSet() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobExecutorAcquireJobsByTypeTest.assertNull((Object)job.getDuedate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/processWithTimerCatch.bpmn20.xml"})
    public void testTimerJobsArePreferred() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        this.incrementClock(70L);
        List<JobEntity> acquirableJobs = this.findAcquirableJobs();
        JobExecutorAcquireJobsByTypeTest.assertEquals((int)4, (int)acquirableJobs.size());
        JobExecutorAcquireJobsByTypeTest.assertTrue((boolean)(acquirableJobs.get(0) instanceof TimerEntity));
        JobExecutorAcquireJobsByTypeTest.assertTrue((boolean)(acquirableJobs.get(1) instanceof TimerEntity));
        JobExecutorAcquireJobsByTypeTest.assertTrue((boolean)(acquirableJobs.get(2) instanceof MessageEntity));
        JobExecutorAcquireJobsByTypeTest.assertTrue((boolean)(acquirableJobs.get(3) instanceof MessageEntity));
    }
}

