/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.SequentialJobAcquisitionRunnable;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestSequentialJobAcquisition {
    private static final String RESOURCE_BASE = TestSequentialJobAcquisition.class.getPackage().getName().replace(".", "/");
    private static final String PROCESS_RESOURCE = RESOURCE_BASE + "/IntermediateTimerEventTest.testCatchingTimerEvent.bpmn20.xml";
    private JobExecutor jobExecutor = new DefaultJobExecutor();

    @After
    public void stopJobExecutor() {
        this.jobExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteJobsForSingleEngine() {
        StandaloneInMemProcessEngineConfiguration standaloneProcessEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        standaloneProcessEngineConfiguration.setProcessEngineName(this.getClass().getName() + "-engine1");
        standaloneProcessEngineConfiguration.setJdbcUrl("jdbc:h2:mem:jobexecutor-test-engine");
        standaloneProcessEngineConfiguration.setJobExecutorActivate(false);
        standaloneProcessEngineConfiguration.setJobExecutor(this.jobExecutor);
        ProcessEngine engine = standaloneProcessEngineConfiguration.buildProcessEngine();
        this.jobExecutor.registerProcessEngine((ProcessEngineImpl)engine);
        engine.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        this.jobExecutor.shutdown();
        engine.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
        Assert.assertEquals((long)1L, (long)engine.getManagementService().createJobQuery().count());
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.add(DateFormat.Field.DAY_OF_YEAR.getCalendarField(), 6);
            ClockUtil.setCurrentTime((Date)calendar.getTime());
            this.jobExecutor.start();
            this.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine.getManagementService(), true);
            Assert.assertEquals((long)0L, (long)engine.getManagementService().createJobQuery().count());
        }
        finally {
            ClockUtil.reset();
            engine.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteJobsForTwoEnginesSameAcquisition() {
        StandaloneInMemProcessEngineConfiguration engineConfiguration1 = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration1.setProcessEngineName(this.getClass().getName() + "-engine1");
        engineConfiguration1.setJdbcUrl("jdbc:h2:mem:activiti1");
        engineConfiguration1.setJobExecutorActivate(false);
        engineConfiguration1.setJobExecutor(this.jobExecutor);
        ProcessEngine engine1 = engineConfiguration1.buildProcessEngine();
        StandaloneInMemProcessEngineConfiguration engineConfiguration2 = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration2.setProcessEngineName(this.getClass().getName() + "engine2");
        engineConfiguration2.setJdbcUrl("jdbc:h2:mem:activiti2");
        engineConfiguration2.setJobExecutorActivate(false);
        engineConfiguration1.setJobExecutor(this.jobExecutor);
        ProcessEngine engine2 = engineConfiguration2.buildProcessEngine();
        this.jobExecutor.registerProcessEngine((ProcessEngineImpl)engine1);
        this.jobExecutor.registerProcessEngine((ProcessEngineImpl)engine2);
        this.jobExecutor.shutdown();
        engine1.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        engine2.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        engine1.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
        engine2.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
        Assert.assertEquals((long)1L, (long)engine1.getManagementService().createJobQuery().count());
        Assert.assertEquals((long)1L, (long)engine2.getManagementService().createJobQuery().count());
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.add(DateFormat.Field.DAY_OF_YEAR.getCalendarField(), 6);
            ClockUtil.setCurrentTime((Date)calendar.getTime());
            this.jobExecutor.start();
            this.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine1.getManagementService(), true);
            this.jobExecutor.start();
            this.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine2.getManagementService(), true);
            Assert.assertEquals((long)0L, (long)engine1.getManagementService().createJobQuery().count());
            Assert.assertEquals((long)0L, (long)engine2.getManagementService().createJobQuery().count());
        }
        finally {
            ClockUtil.reset();
            engine1.close();
            engine2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobAddedGuardForTwoEnginesSameAcquisition() throws InterruptedException {
        StandaloneInMemProcessEngineConfiguration engineConfiguration1 = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration1.setProcessEngineName(this.getClass().getName() + "-engine1");
        engineConfiguration1.setJdbcUrl("jdbc:h2:mem:activiti1");
        engineConfiguration1.setJobExecutorActivate(false);
        engineConfiguration1.setJobExecutor(this.jobExecutor);
        ProcessEngine engine1 = engineConfiguration1.buildProcessEngine();
        StandaloneInMemProcessEngineConfiguration engineConfiguration2 = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration2.setProcessEngineName(this.getClass().getName() + "engine2");
        engineConfiguration2.setJdbcUrl("jdbc:h2:mem:activiti2");
        engineConfiguration2.setJobExecutorActivate(false);
        engineConfiguration1.setJobExecutor(this.jobExecutor);
        ProcessEngine engine2 = engineConfiguration2.buildProcessEngine();
        this.jobExecutor.registerProcessEngine((ProcessEngineImpl)engine1);
        this.jobExecutor.registerProcessEngine((ProcessEngineImpl)engine2);
        this.jobExecutor.shutdown();
        engine1.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        engine2.getRepositoryService().createDeployment().addClasspathResource(PROCESS_RESOURCE).deploy();
        try {
            engine1.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
            engine2.getRuntimeService().startProcessInstanceByKey("intermediateTimerEventExample");
            Calendar calendar = Calendar.getInstance();
            calendar.add(DateFormat.Field.DAY_OF_YEAR.getCalendarField(), 6);
            ClockUtil.setCurrentTime((Date)calendar.getTime());
            Assert.assertEquals((long)1L, (long)engine1.getManagementService().createJobQuery().count());
            Assert.assertEquals((long)1L, (long)engine2.getManagementService().createJobQuery().count());
            this.jobExecutor.start();
            this.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine1.getManagementService(), false);
            this.jobExecutor.start();
            this.waitForJobExecutorToProcessAllJobs(10000L, 100L, this.jobExecutor, engine2.getManagementService(), false);
            Thread.sleep(2000L);
            Assert.assertFalse((boolean)((SequentialJobAcquisitionRunnable)this.jobExecutor.getAcquireJobsRunnable()).isJobAdded());
            Assert.assertEquals((long)0L, (long)engine1.getManagementService().createJobQuery().count());
            Assert.assertEquals((long)0L, (long)engine2.getManagementService().createJobQuery().count());
        }
        finally {
            ClockUtil.reset();
            engine1.close();
            engine2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis, JobExecutor jobExecutor, ManagementService managementService, boolean shutdown) {
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    areJobsAvailable = this.areJobsAvailable(managementService);
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            if (shutdown) {
                jobExecutor.shutdown();
            }
        }
    }

    public boolean areJobsAvailable(ManagementService managementService) {
        return !managementService.createJobQuery().executable().list().isEmpty();
    }

    private static class InteruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InteruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

