/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.metrics;

import java.util.Collection;
import java.util.Date;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class MetricsTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        Collection meters = this.processEngineConfiguration.getMetricsRegistry().getMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    public void testDeleteMetrics() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().sum());
        this.managementService.deleteMetrics(null);
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
    }

    public void testDeleteMetricsWithTimestamp() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().sum());
        this.managementService.deleteMetrics(ClockUtil.getCurrentTime());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
    }

    public void testDeleteMetricsWithTimestampBefore() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().sum());
        this.managementService.deleteMetrics(new Date(ClockUtil.getCurrentTime().getTime() - 10000L));
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.managementService.deleteMetrics(null);
    }

    public void testQuery() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("UNKNOWN").sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().startDate(new Date(1000L)).sum());
        MetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().startDate(new Date(1000L)).endDate(ClockUtil.getCurrentTime()).sum());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).sum());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).endDate(ClockUtil.getCurrentTime()).sum());
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        MetricsTest.assertEquals((long)6L, (long)this.managementService.createMetricsQuery().sum());
        MetricsTest.assertEquals((long)6L, (long)this.managementService.createMetricsQuery().startDate(new Date(1000L)).sum());
        MetricsTest.assertEquals((long)6L, (long)this.managementService.createMetricsQuery().startDate(new Date(1000L)).endDate(ClockUtil.getCurrentTime()).sum());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).sum());
        MetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().startDate(new Date(ClockUtil.getCurrentTime().getTime() + 1000L)).endDate(ClockUtil.getCurrentTime()).sum());
        this.managementService.deleteMetrics(null);
    }
}

