/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.persistence;

import java.util.List;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.BitMaskUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.test.Deployment;

public class ExecutionCachedEntityStateTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testProcessInstanceTasks() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)2), (int)processInstance.getCachedEntityStateRaw());
    }

    @Deployment
    public void testExecutionTasksScope() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)2), (int)execution.getCachedEntityStateRaw());
    }

    @Deployment
    public void testExecutionTasksParallel() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)2), (int)execution.getCachedEntityStateRaw());
    }

    @Deployment
    public void testExecutionTasksMi() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)processInstance.getCachedEntityStateRaw());
        List executions = this.runtimeService.createExecutionQuery().activityId("userTask").list();
        for (Execution execution : executions) {
            int cachedEntityStateRaw = ((ExecutionEntity)execution).getCachedEntityStateRaw();
            if (!((ExecutionEntity)execution).isScope()) {
                ExecutionCachedEntityStateTest.assertEquals((int)(BitMaskUtil.getMaskForBit((int)2) | BitMaskUtil.getMaskForBit((int)5)), (int)cachedEntityStateRaw);
                continue;
            }
            ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)5), (int)cachedEntityStateRaw);
        }
    }

    @Deployment
    public void testProcessInstanceEventSubscriptions() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)1), (int)processInstance.getCachedEntityStateRaw());
    }

    @Deployment
    public void testExecutionEventSubscriptionsScope() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("IntermediateCatchEvent_1").singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)1), (int)execution.getCachedEntityStateRaw());
    }

    @Deployment
    public void testExecutionEventSubscriptionsMi() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)processInstance.getCachedEntityStateRaw());
        List executions = this.runtimeService.createExecutionQuery().activityId("ReceiveTask_1").list();
        for (Execution execution : executions) {
            int cachedEntityStateRaw = ((ExecutionEntity)execution).getCachedEntityStateRaw();
            if (!((ExecutionEntity)execution).isScope()) {
                ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)5), (int)cachedEntityStateRaw);
                continue;
            }
            ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)1), (int)cachedEntityStateRaw);
        }
    }

    @Deployment
    public void testProcessInstanceJobs() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)3), (int)processInstance.getCachedEntityStateRaw());
    }

    @Deployment
    public void testExecutionJobsScope() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)3), (int)execution.getCachedEntityStateRaw());
    }

    @Deployment
    public void testExecutionJobsParallel() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)3), (int)execution.getCachedEntityStateRaw());
    }

    @Deployment
    public void testProcessInstanceIncident() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)processInstance.getCachedEntityStateRaw());
        final ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)execution.getCachedEntityStateRaw());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                IncidentEntity.createAndInsertIncident((String)"foo", (String)execution.getId(), null, null);
                return null;
            }
        });
        ExecutionEntity execution2 = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)4), (int)execution2.getCachedEntityStateRaw());
    }

    @Deployment
    public void testExecutionIncidentParallel() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)processInstance.getCachedEntityStateRaw());
        final ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)0, (int)execution.getCachedEntityStateRaw());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                IncidentEntity.createAndInsertIncident((String)"foo", (String)execution.getId(), null, null);
                return null;
            }
        });
        ExecutionEntity execution2 = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        ExecutionCachedEntityStateTest.assertEquals((int)BitMaskUtil.getMaskForBit((int)4), (int)execution2.getCachedEntityStateRaw());
    }
}

