/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.pvm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.junit.Assert;

public class ActivityInstanceVerification
extends Assert
implements ExecutionListener {
    protected Map<String, List<ActivityInstance>> startedActivityInstances = new HashMap<String, List<ActivityInstance>>();
    protected Map<String, List<ActivityInstance>> endedActivityInstances = new HashMap<String, List<ActivityInstance>>();

    public void notify(DelegateExecution e) throws Exception {
        ActivityExecution execution = (ActivityExecution)e;
        if (execution.getActivityInstanceId() == null) {
            return;
        }
        if (execution.getEventName().equals("start")) {
            this.addActivityInstanceId(execution, this.startedActivityInstances);
        } else if (execution.getEventName().equals("end")) {
            this.addActivityInstanceId(execution, this.endedActivityInstances);
        }
    }

    private void addActivityInstanceId(ActivityExecution execution, Map<String, List<ActivityInstance>> instanceMap) {
        String actId = execution.getActivity().getId();
        String actInstanceId = execution.getActivityInstanceId();
        String parentActInstanceId = execution.getParentActivityInstanceId();
        String executionId = String.valueOf(System.identityHashCode(execution));
        List<ActivityInstance> instancesForThisAct = instanceMap.get(actId);
        if (instancesForThisAct == null) {
            instancesForThisAct = new ArrayList<ActivityInstance>();
            instanceMap.put(actId, instancesForThisAct);
        }
        ActivityInstance activityInstance = new ActivityInstance(executionId, actInstanceId, parentActInstanceId, execution.isCompleteScope());
        instancesForThisAct.add(activityInstance);
    }

    public void assertStartInstanceCount(int count, String actId) {
        List<ActivityInstance> startInstancesForThisAct = this.startedActivityInstances.get(actId);
        if (count == 0 && startInstancesForThisAct == null) {
            return;
        }
        ActivityInstanceVerification.assertNotNull(startInstancesForThisAct);
        ActivityInstanceVerification.assertEquals((long)count, (long)startInstancesForThisAct.size());
        List<ActivityInstance> endInstancesForThisAct = this.endedActivityInstances.get(actId);
        ActivityInstanceVerification.assertNotNull(endInstancesForThisAct);
        for (ActivityInstance startedActInstance : startInstancesForThisAct) {
            ActivityInstanceVerification.assertNotNull((String)("activityInstanceId cannot be null for " + startedActInstance), (Object)startedActInstance.id);
            ActivityInstanceVerification.assertNotNull((String)("executionId cannot be null for " + startedActInstance), (Object)startedActInstance.executionId);
            ActivityInstanceVerification.assertNotNull((String)("parentId cannot be null for " + startedActInstance), (Object)startedActInstance.parentId);
            boolean foundMatchingEnd = false;
            for (ActivityInstance endedActInstance : endInstancesForThisAct) {
                if (!startedActInstance.id.equals(endedActInstance.id)) continue;
                ActivityInstanceVerification.assertEquals((Object)startedActInstance.parentId, (Object)endedActInstance.parentId);
                foundMatchingEnd = true;
            }
            if (foundMatchingEnd) continue;
            ActivityInstanceVerification.fail((String)("cannot find matching end activity instance for start activity instance " + startedActInstance.id));
        }
    }

    public void assertProcessInstanceParent(String actId, PvmProcessInstance processInstance) {
        this.assertParentActInstance(actId, String.valueOf(System.identityHashCode(processInstance)));
    }

    public void assertParentActInstance(String actId, String actInstId) {
        List<ActivityInstance> actInstanceList = this.startedActivityInstances.get(actId);
        for (ActivityInstance activityInstance : actInstanceList) {
            ActivityInstanceVerification.assertEquals((Object)actInstId, (Object)activityInstance.parentId);
        }
        actInstanceList = this.endedActivityInstances.get(actId);
        for (ActivityInstance activityInstance : actInstanceList) {
            ActivityInstanceVerification.assertEquals((Object)actInstId, (Object)activityInstance.parentId);
        }
    }

    public void assertParent(String actId, String parentId) {
        List<ActivityInstance> actInstanceList = this.startedActivityInstances.get(actId);
        List<ActivityInstance> parentInstances = this.startedActivityInstances.get(parentId);
        for (ActivityInstance activityInstance : actInstanceList) {
            boolean found = false;
            for (ActivityInstance parentIntance : parentInstances) {
                if (!activityInstance.parentId.equals(parentIntance.id)) continue;
                found = true;
            }
            if (found) continue;
            ActivityInstanceVerification.fail((String)("every instance of '" + actId + "' must have a parent which is an instance of '" + parentId));
        }
    }

    public void assertIsCompletingActivityInstance(String activityId) {
        this.assertIsCompletingActivityInstance(activityId, -1);
    }

    public void assertIsCompletingActivityInstance(String activityId, int count) {
        this.assertCorrectCompletingState(activityId, count, true);
    }

    public void assertNonCompletingActivityInstance(String activityId) {
        this.assertNonCompletingActivityInstance(activityId, -1);
    }

    public void assertNonCompletingActivityInstance(String activityId, int count) {
        this.assertCorrectCompletingState(activityId, count, false);
    }

    private void assertCorrectCompletingState(String activityId, int expectedCount, boolean completing) {
        List<ActivityInstance> endActivityInstances = this.endedActivityInstances.get(activityId);
        ActivityInstanceVerification.assertNotNull(endActivityInstances);
        for (ActivityInstance instance : endActivityInstances) {
            ActivityInstanceVerification.assertEquals((Object)completing, (Object)instance.isCompleteScope);
        }
        if (expectedCount != -1) {
            ActivityInstanceVerification.assertEquals((long)expectedCount, (long)endActivityInstances.size());
        }
    }

    class ActivityInstance {
        String id;
        String parentId;
        String executionId;
        boolean isCompleteScope;

        public ActivityInstance(String executionId, String actInstanceId, String parentId, boolean isCompleteScope) {
            this.id = actInstanceId;
            this.executionId = executionId;
            this.parentId = parentId;
            this.isCompleteScope = isCompleteScope;
        }

        public String toString() {
            return this.id + " by " + this.executionId + " parent: " + this.parentId;
        }
    }
}

