/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.Stack;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.ExecutionTreeAssertion;

public class ExecutionAssert {
    protected ExecutionTree tree;
    protected CommandExecutor commandExecutor;

    public static ExecutionAssert assertThat(ExecutionTree tree) {
        ExecutionAssert assertion = new ExecutionAssert();
        assertion.tree = tree;
        return assertion;
    }

    public void matches(ExecutionTreeAssertion assertion) {
        assertion.assertExecution(this.tree);
    }

    public static ExecutionTreeBuilder describeExecutionTree(String activityId) {
        return new ExecutionTreeBuilder(activityId);
    }

    public static class ExecutionTreeBuilder {
        protected ExecutionTreeAssertion rootAssertion = null;
        protected Stack<ExecutionTreeAssertion> activityInstanceStack = new Stack();

        public ExecutionTreeBuilder(String rootActivityInstanceId) {
            this.rootAssertion = new ExecutionTreeAssertion();
            this.rootAssertion.setExpectedActivityId(rootActivityInstanceId);
            this.activityInstanceStack.push(this.rootAssertion);
        }

        public ExecutionTreeBuilder child(String activityId) {
            ExecutionTreeAssertion newInstance = new ExecutionTreeAssertion();
            newInstance.setExpectedActivityId(activityId);
            ExecutionTreeAssertion parentInstance = this.activityInstanceStack.peek();
            parentInstance.addChildAssertion(newInstance);
            this.activityInstanceStack.push(newInstance);
            return this;
        }

        public ExecutionTreeBuilder scope() {
            ExecutionTreeAssertion currentAssertion = this.activityInstanceStack.peek();
            currentAssertion.setExpectedIsScope(true);
            return this;
        }

        public ExecutionTreeBuilder concurrent() {
            ExecutionTreeAssertion currentAssertion = this.activityInstanceStack.peek();
            currentAssertion.setExpectedIsConcurrent(true);
            return this;
        }

        public ExecutionTreeBuilder eventScope() {
            ExecutionTreeAssertion currentAssertion = this.activityInstanceStack.peek();
            currentAssertion.setExpectedIsEventScope(true);
            return this;
        }

        public ExecutionTreeBuilder noScope() {
            ExecutionTreeAssertion currentAssertion = this.activityInstanceStack.peek();
            currentAssertion.setExpectedIsScope(false);
            return this;
        }

        public ExecutionTreeBuilder up() {
            this.activityInstanceStack.pop();
            return this;
        }

        public ExecutionTreeAssertion done() {
            return this.rootAssertion;
        }
    }
}

