/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.entitymanager;

import java.util.List;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.db.entitymanager.TestIdGenerator;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DbOperationsOrderingTest {
    protected DbEntityManager entityManager;
    ExecutionEntity execution1 = null;
    ExecutionEntity execution2 = null;
    ExecutionEntity execution3 = null;
    ExecutionEntity execution4 = null;
    ExecutionEntity execution5 = null;
    ExecutionEntity execution6 = null;
    ExecutionEntity execution7 = null;
    ExecutionEntity execution8 = null;
    TaskEntity task1 = null;
    TaskEntity task2 = null;
    TaskEntity task3 = null;
    TaskEntity task4 = null;
    VariableInstanceEntity variable1 = null;
    VariableInstanceEntity variable2 = null;
    VariableInstanceEntity variable3 = null;
    VariableInstanceEntity variable4 = null;

    @Before
    public void setup() {
        TestIdGenerator idGenerator = new TestIdGenerator();
        this.entityManager = new DbEntityManager((IdGenerator)idGenerator, null);
        this.execution1 = new ExecutionEntity();
        this.execution1.setId("101");
        this.execution2 = new ExecutionEntity();
        this.execution2.setId("102");
        this.execution3 = new ExecutionEntity();
        this.execution3.setId("103");
        this.execution4 = new ExecutionEntity();
        this.execution4.setId("104");
        this.execution5 = new ExecutionEntity();
        this.execution5.setId("105");
        this.execution6 = new ExecutionEntity();
        this.execution6.setId("106");
        this.execution7 = new ExecutionEntity();
        this.execution7.setId("107");
        this.execution8 = new ExecutionEntity();
        this.execution8.setId("108");
        this.task1 = new TaskEntity();
        this.task1.setId("104");
        this.task2 = new TaskEntity();
        this.task2.setId("105");
        this.task3 = new TaskEntity();
        this.task3.setId("106");
        this.task4 = new TaskEntity();
        this.task4.setId("107");
        this.variable1 = new VariableInstanceEntity();
        this.variable1.setId("108");
        this.variable2 = new VariableInstanceEntity();
        this.variable2.setId("109");
        this.variable3 = new VariableInstanceEntity();
        this.variable3.setId("110");
        this.variable4 = new VariableInstanceEntity();
        this.variable4.setId("111");
    }

    @Test
    public void testInsertSingleEntity() {
        this.entityManager.insert((DbEntity)this.execution1);
        this.entityManager.flushEntityCache();
        List flush = this.entityManager.getDbOperationManager().calculateFlush();
        Assert.assertEquals((long)1L, (long)flush.size());
    }

    @Test
    public void testInsertReferenceOrdering() {
        this.execution2.setParent((PvmExecutionImpl)this.execution3);
        this.entityManager.insert((DbEntity)this.execution2);
        this.entityManager.insert((DbEntity)this.execution3);
        this.entityManager.flushEntityCache();
        List flush = this.entityManager.getDbOperationManager().calculateFlush();
        this.assertHappensAfter((DbEntity)this.execution2, (DbEntity)this.execution3, flush);
    }

    @Test
    public void testInsertReferenceOrderingAndIdOrdering() {
        this.execution2.setParent((PvmExecutionImpl)this.execution3);
        this.entityManager.insert((DbEntity)this.execution2);
        this.entityManager.insert((DbEntity)this.execution3);
        this.entityManager.insert((DbEntity)this.execution1);
        this.entityManager.flushEntityCache();
        List flush = this.entityManager.getDbOperationManager().calculateFlush();
        this.assertHappensAfter((DbEntity)this.execution2, (DbEntity)this.execution3, flush);
        this.assertHappensAfter((DbEntity)this.execution3, (DbEntity)this.execution1, flush);
        this.assertHappensAfter((DbEntity)this.execution2, (DbEntity)this.execution1, flush);
    }

    @Test
    public void testInsertReferenceOrderingMultipleTrees() {
        this.execution3.setParent((PvmExecutionImpl)this.execution4);
        this.execution2.setParent((PvmExecutionImpl)this.execution4);
        this.execution5.setParent((PvmExecutionImpl)this.execution3);
        this.execution1.setParent((PvmExecutionImpl)this.execution8);
        this.entityManager.insert((DbEntity)this.execution8);
        this.entityManager.insert((DbEntity)this.execution6);
        this.entityManager.insert((DbEntity)this.execution2);
        this.entityManager.insert((DbEntity)this.execution5);
        this.entityManager.insert((DbEntity)this.execution1);
        this.entityManager.insert((DbEntity)this.execution4);
        this.entityManager.insert((DbEntity)this.execution7);
        this.entityManager.insert((DbEntity)this.execution3);
        this.entityManager.flushEntityCache();
        List insertOperations = this.entityManager.getDbOperationManager().calculateFlush();
        this.assertHappensAfter((DbEntity)this.execution3, (DbEntity)this.execution4, insertOperations);
        this.assertHappensAfter((DbEntity)this.execution2, (DbEntity)this.execution4, insertOperations);
        this.assertHappensAfter((DbEntity)this.execution5, (DbEntity)this.execution3, insertOperations);
        this.assertHappensAfter((DbEntity)this.execution1, (DbEntity)this.execution8, insertOperations);
    }

    protected void assertHappensAfter(DbEntity entity1, DbEntity entity2, List<DbOperation> operations) {
        int idx1 = this.indexOfEntity(entity1, operations);
        int idx2 = this.indexOfEntity(entity2, operations);
        Assert.assertTrue((String)(entity1 + " should be inserted after " + entity2), (idx1 > idx2 ? 1 : 0) != 0);
    }

    protected int indexOfEntity(DbEntity entity, List<DbOperation> operations) {
        for (int i = 0; i < operations.size(); ++i) {
            if (entity != ((DbEntityOperation)operations.get(i)).getEntity()) continue;
            return i;
        }
        return -1;
    }

    @Test
    public void testInsertIdOrdering() {
        this.entityManager.insert((DbEntity)this.execution1);
        this.entityManager.insert((DbEntity)this.execution2);
        this.entityManager.flushEntityCache();
        List insertOperations = this.entityManager.getDbOperationManager().calculateFlush();
        this.assertHappensAfter((DbEntity)this.execution2, (DbEntity)this.execution1, insertOperations);
    }
}

