/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.variable.Variables;

public class ProcessInstanceModificationEventTest
extends PluggableProcessEngineTestCase {
    protected static final String INTERMEDIATE_TIMER_CATCH_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.intermediateTimerCatch.bpmn20.xml";
    protected static final String MESSAGE_START_EVENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.messageStart.bpmn20.xml";
    protected static final String TIMER_START_EVENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.timerStart.bpmn20.xml";
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml";
    protected static final String TERMINATE_END_EVENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.terminateEnd.bpmn20.xml";
    protected static final String CANCEL_END_EVENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.cancelEnd.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.intermediateTimerCatch.bpmn20.xml"})
    public void testStartBeforeIntermediateCatchEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("intermediateCatchEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task").activity("intermediateCatchEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task").concurrent().noScope().up().child(null).concurrent().noScope().child("intermediateCatchEvent").scope().done());
        ActivityInstance catchEventInstance = this.getChildInstanceForActivity(updatedTree, "intermediateCatchEvent");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationEventTest.assertNotNull((Object)job);
        ProcessInstanceModificationEventTest.assertEquals((String)catchEventInstance.getExecutionIds()[0], (String)job.getExecutionId());
        this.completeTasksInOrder("task");
        this.executeAvailableJobs();
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.messageStart.bpmn20.xml"})
    public void testStartBeforeMessageStartEvent() {
        this.runtimeService.correlateMessage("startMessage");
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessInstanceModificationEventTest.assertNotNull((Object)processInstance);
        EventSubscription startEventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        ProcessInstanceModificationEventTest.assertNotNull((Object)startEventSubscription);
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task").activity("task").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task").concurrent().noScope().up().child("task").concurrent().noScope().done());
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        ProcessInstanceModificationEventTest.assertNotNull((Object)subscription);
        ProcessInstanceModificationEventTest.assertEquals((String)startEventSubscription.getId(), (String)subscription.getId());
        this.completeTasksInOrder("task", "task");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.timerStart.bpmn20.xml"})
    public void testStartBeforeTimerStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        Job startTimerJob = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationEventTest.assertNotNull((Object)startTimerJob);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task").activity("task").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task").concurrent().noScope().up().child("task").concurrent().noScope().done());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationEventTest.assertNotNull((Object)job);
        ProcessInstanceModificationEventTest.assertEquals((String)startTimerJob.getId(), (String)job.getId());
        this.completeTasksInOrder("task", "task");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testStartBeforNoneStartEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theStart")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("theTask").concurrent().noScope().up().child("theTask").concurrent().noScope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationEventTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testStartBeforeNoneEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theEnd")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("theTask").scope().done());
        this.completeTasksInOrder("theTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.terminateEnd.bpmn20.xml"})
    public void testStartBeforeTerminateEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("terminateEnd")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventTest.assertNull((Object)updatedTree);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.cancelEnd.bpmn20.xml"})
    public void FAILING_testStartBeforeCancelEndEventConcurrent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        Task txTask = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessInstanceModificationEventTest.assertEquals((String)"txTask", (String)txTask.getTaskDefinitionKey());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("cancelEnd")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterCancellation").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("afterCancellation").scope().done());
        Task afterCancellationTask = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessInstanceModificationEventTest.assertNotNull((Object)afterCancellationTask);
        ProcessInstanceModificationEventTest.assertFalse((boolean)txTask.getId().equals(afterCancellationTask.getId()));
        ProcessInstanceModificationEventTest.assertEquals((String)"afterCancellation", (String)afterCancellationTask.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.cancelEnd.bpmn20.xml"})
    public void testStartBeforeCancelEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        Task txTask = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessInstanceModificationEventTest.assertEquals((String)"txTask", (String)txTask.getTaskDefinitionKey());
        this.taskService.complete(txTask.getId(), (Map)Variables.createVariables().putValue("success", (Object)true));
        Task afterSuccessTask = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessInstanceModificationEventTest.assertEquals((String)"afterSuccess", (String)afterSuccessTask.getTaskDefinitionKey());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("cancelEnd")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationEventTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationEventTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterCancellation").activity("afterSuccess").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("afterCancellation").concurrent().noScope().up().child("afterSuccess").concurrent().noScope().up().child("tx").scope().eventScope().done());
        ProcessInstanceModificationEventTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskDefinitionKey("undoTxTask").count());
        Task afterCancellationTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("afterCancellation").singleResult();
        ProcessInstanceModificationEventTest.assertNotNull((Object)afterCancellationTask);
        this.taskService.complete(afterCancellationTask.getId());
        this.taskService.complete(afterSuccessTask.getId());
        this.assertProcessEnded(processInstanceId);
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            if (!childInstance.getActivityId().equals(activityId)) continue;
            return childInstance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            ProcessInstanceModificationEventTest.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

