/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ProcessInstantiationAtActivitiesHistoryTest
extends PluggableProcessEngineTestCase {
    protected static final String PARALLEL_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml";
    protected static final String SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml";
    protected static final String ASYNC_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testHistoricProcessInstanceForSingleActivityInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).execute();
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicInstance);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicInstance.getId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicInstance.getStartTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertNull((Object)historicInstance.getEndTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"task1", (String)historicInstance.getStartActivityId());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicActivityInstance);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"task1", (String)historicActivityInstance.getActivityId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicActivityInstance.getId());
        ProcessInstantiationAtActivitiesHistoryTest.assertFalse((boolean)instance.getId().equals(historicActivityInstance.getId()));
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicActivityInstance.getStartTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertNull((Object)historicActivityInstance.getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    public void testHistoricActivityInstancesForSubprocess() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("subprocess").startBeforeActivity("innerTask")).startBeforeActivity("theSubProcessStart")).execute();
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicInstance);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicInstance.getId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicInstance.getStartTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertNull((Object)historicInstance.getEndTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"innerTask", (String)historicInstance.getStartActivityId());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((long)4L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoricActivityInstance subProcessInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("subProcess").singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)subProcessInstance);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"subProcess", (String)subProcessInstance.getActivityId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)subProcessInstance.getId());
        ProcessInstantiationAtActivitiesHistoryTest.assertFalse((boolean)instance.getId().equals(subProcessInstance.getId()));
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)subProcessInstance.getStartTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertNull((Object)subProcessInstance.getEndTime());
        HistoricActivityInstance startEventInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theSubProcessStart").singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)startEventInstance);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"theSubProcessStart", (String)startEventInstance.getActivityId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)startEventInstance.getId());
        ProcessInstantiationAtActivitiesHistoryTest.assertFalse((boolean)instance.getId().equals(startEventInstance.getId()));
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)startEventInstance.getStartTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)startEventInstance.getEndTime());
        List innerTaskInstances = this.historyService.createHistoricActivityInstanceQuery().activityId("innerTask").list();
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((int)2, (int)innerTaskInstances.size());
        for (HistoricActivityInstance innerTaskInstance : innerTaskInstances) {
            ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)innerTaskInstance);
            ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"innerTask", (String)innerTaskInstance.getActivityId());
            ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)innerTaskInstance.getId());
            ProcessInstantiationAtActivitiesHistoryTest.assertFalse((boolean)instance.getId().equals(innerTaskInstance.getId()));
            ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)innerTaskInstance.getStartTime());
            ProcessInstantiationAtActivitiesHistoryTest.assertNull((Object)innerTaskInstance.getEndTime());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml"})
    public void testHistoricProcessInstanceAsyncStartEvent() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task2")).setVariable("aVar", (Object)"aValue")).execute();
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicInstance);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicInstance.getId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicInstance.getStartTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertNull((Object)historicInstance.getEndTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"task2", (String)historicInstance.getStartActivityId());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(instance.getId());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aVar").singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicVariable);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicVariable.getProcessInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)activityInstance.getId(), (String)historicVariable.getActivityInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"aVar", (String)historicVariable.getName());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((Object)"aValue", (Object)historicVariable.getValue());
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(historicVariable.getId()).singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicDetail.getProcessInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicDetail);
        ProcessInstantiationAtActivitiesHistoryTest.assertNull((Object)historicDetail.getActivityInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertTrue((boolean)(historicDetail instanceof HistoricVariableUpdate));
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"aVar", (String)((HistoricVariableUpdate)historicDetail).getVariableName());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((Object)"aValue", (Object)((HistoricVariableUpdate)historicDetail).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testHistoricVariableInstanceForSingleActivityInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).setVariable("aVar", (Object)"aValue")).execute();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(instance.getId());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aVar").singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicVariable);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicVariable.getProcessInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)activityInstance.getId(), (String)historicVariable.getActivityInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"aVar", (String)historicVariable.getName());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((Object)"aValue", (Object)historicVariable.getValue());
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(historicVariable.getId()).singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicDetail.getProcessInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicDetail);
        ProcessInstantiationAtActivitiesHistoryTest.assertNull((Object)historicDetail.getActivityInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertTrue((boolean)(historicDetail instanceof HistoricVariableUpdate));
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"aVar", (String)((HistoricVariableUpdate)historicDetail).getVariableName());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((Object)"aValue", (Object)((HistoricVariableUpdate)historicDetail).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testHistoricVariableInstanceSetOnProcessInstance() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").setVariable("aVar", (Object)"aValue")).startBeforeActivity("task1")).execute();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(instance.getId());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aVar").singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicVariable);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicVariable.getProcessInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)activityInstance.getId(), (String)historicVariable.getActivityInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"aVar", (String)historicVariable.getName());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((Object)"aValue", (Object)historicVariable.getValue());
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(historicVariable.getId()).singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicDetail.getProcessInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicDetail);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicDetail.getActivityInstanceId());
        ProcessInstantiationAtActivitiesHistoryTest.assertTrue((boolean)(historicDetail instanceof HistoricVariableUpdate));
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"aVar", (String)((HistoricVariableUpdate)historicDetail).getVariableName());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((Object)"aValue", (Object)((HistoricVariableUpdate)historicDetail).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    public void testHistoricProcessInstanceForSynchronousCompletion() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startAfterActivity("task1")).execute();
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicInstance);
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)instance.getId(), (String)historicInstance.getId());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicInstance.getStartTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertNotNull((Object)historicInstance.getEndTime());
        ProcessInstantiationAtActivitiesHistoryTest.assertEquals((String)"join", (String)historicInstance.getStartActivityId());
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            ProcessInstantiationAtActivitiesHistoryTest.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

