/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class IncidentAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected static final String ANOTHER_ONE_INCIDENT_PROCESS_KEY = "anotherOneIncidentProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/authorization/timerStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/authorization/oneIncidentProcess.bpmn20.xml", "org/camunda/bpm/engine/test/authorization/anotherOneIncidentProcess.bpmn20.xml").getId();
    }

    @Override
    public void tearDown() {
        this.deleteDeployment(this.deploymentId);
        super.tearDown();
    }

    public void testQueryForStandaloneIncidents() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String jobId = null;
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            jobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    public void testStartTimerJobIncidentQueryWithoutAuthorization() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testStartTimerJobIncidentQueryWithReadPermissionOnAnyProcessInstance() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testStartTimerJobIncidentQueryWithReadInstancePermissionOnProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testStartTimerJobIncidentQueryWithReadInstancePermissionOnAnyProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 7);
    }

    protected void verifyQueryResults(IncidentQuery query, int countExpected) {
        this.verifyQueryResults((AbstractQuery)query, countExpected);
    }

    protected void clearDatabase() {
        this.clearOpLog();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
                if (historyLevel.equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                    List incidents = Context.getProcessEngineConfiguration().getHistoryService().createHistoricIncidentQuery().list();
                    for (HistoricIncident incident : incidents) {
                        commandContext.getHistoricIncidentManager().delete((DbEntity)((HistoricIncidentEntity)incident));
                    }
                }
                return null;
            }
        });
    }
}

