/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class JobDefinitionAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/authorization/timerStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/authorization/timerBoundaryEventProcess.bpmn20.xml").getId();
    }

    @Override
    public void tearDown() {
        this.deleteDeployment(this.deploymentId);
        super.tearDown();
    }

    public void testQueryWithoutAuthorization() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithReadPermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testSuspendByIdWithoutAuthorization() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.managementService.suspendJobDefinitionById(jobDefinitionId);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendByIdWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.managementService.suspendJobDefinitionById(jobDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
    }

    public void testSuspendByIdWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.managementService.suspendJobDefinitionById(jobDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
    }

    public void testActivateByIdWithoutAuthorization() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionById(jobDefinitionId);
        try {
            this.managementService.activateJobDefinitionById(jobDefinitionId);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateByIdWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionById(jobDefinitionId);
        this.managementService.activateJobDefinitionById(jobDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
    }

    public void testActivateByIdWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionById(jobDefinitionId);
        this.managementService.activateJobDefinitionById(jobDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
    }

    public void testSuspendIncludingJobsByIdWithoutAuthorization() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendIncludingJobsByIdWithUpdatePermissionOnProcessInstance() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendIncludingJobsByIdWithUpdatePermissionOnAnyProcessInstance() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendIncludingJobsByIdWithUpdateInstancePermissionOnProcessDefinition() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendIncludingJobsByIdWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testActivateIncludingJobsByIdWithoutAuthorization() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionById(jobDefinitionId, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateIncludingJobsByIdWithUpdatePermissionOnProcessInstance() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionById(jobDefinitionId, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateIncludingJobsByIdWithUpdatePermissionOnAnyProcessInstance() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateIncludingJobsByIdWithUpdateInstancePermissionOnProcessDefinition() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateIncludingJobsByIdWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String jobDefinitionId = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsById(jobDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionById(jobDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testSuspendByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendByProcessDefinitionIdWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
    }

    public void testSuspendByProcessDefinitionIdWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
    }

    public void testActivateByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to activate a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateByProcessDefinitionIdWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
    }

    public void testActivateByProcessDefinitionIdWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionByProcessDefinitionId(processDefinitionId);
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
    }

    public void testSuspendIncludingJobsByProcessDefinitionIdWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendIncludingJobsByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendIncludingJobsByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendIncludingJobsByProcessDefinitionIdWithUpdateInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testSuspendIncludingJobsByProcessDefinitionIdWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertTrue((boolean)job.isSuspended());
    }

    public void testActivateIncludingJobsByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateIncludingJobsByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateIncludingJobsByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateIncludingJobsByProcessDefinitionIdWithUpdateInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testActivateIncludingJobsByProcessDefinitionIdWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionId(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionByProcessDefinitionId(processDefinitionId, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertFalse((boolean)job.isSuspended());
    }

    public void testSuspendByProcessDefinitionKeyWithoutAuthorization() {
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.clearOpLog();
    }

    public void testSuspendByProcessDefinitionKeyWithUpdatePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        this.clearOpLog();
    }

    public void testSuspendByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        this.clearOpLog();
    }

    public void testActivateByProcessDefinitionKeyWithoutAuthorization() {
        this.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.clearOpLog();
    }

    public void testActivateByProcessDefinitionKeyWithUpdatePermissionOnProcessDefinition() {
        this.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        this.clearOpLog();
    }

    public void testActivateByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessDefinition() {
        this.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        this.clearOpLog();
    }

    public void testSuspendIncludingJobsByProcessDefinitionKeyWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.clearOpLog();
    }

    public void testSuspendIncludingJobsByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.clearOpLog();
    }

    public void testSuspendIncludingJobsByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertTrue((boolean)job.isSuspended());
        this.clearOpLog();
    }

    public void testSuspendIncludingJobsByProcessDefinitionKeyWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertTrue((boolean)job.isSuspended());
        this.clearOpLog();
    }

    public void testSuspendIncludingJobsByProcessDefinitionKeyWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertTrue((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertTrue((boolean)job.isSuspended());
        this.clearOpLog();
    }

    public void testActivateIncludingJobsByProcessDefinitionKeyWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.clearOpLog();
    }

    public void testActivateIncludingJobsByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
            JobDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to suspend a job definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(TIMER_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.clearOpLog();
    }

    public void testActivateIncludingJobsByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertFalse((boolean)job.isSuspended());
        this.clearOpLog();
    }

    public void testActivateIncludingJobsByProcessDefinitionKeyWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertFalse((boolean)job.isSuspended());
        this.clearOpLog();
    }

    public void testActivateIncludingJobsByProcessDefinitionKeyWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.suspendJobDefinitionIncludingJobsByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.managementService.activateJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY, true);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobDefinitionAuthorizationTest.assertNotNull((Object)jobDefinition);
        JobDefinitionAuthorizationTest.assertFalse((boolean)jobDefinition.isSuspended());
        Job job = this.selectJobByProcessInstanceId(processInstanceId);
        JobDefinitionAuthorizationTest.assertNotNull((Object)job);
        JobDefinitionAuthorizationTest.assertFalse((boolean)job.isSuspended());
        this.clearOpLog();
    }

    protected void verifyQueryResults(JobDefinitionQuery query, int countExpected) {
        this.verifyQueryResults((AbstractQuery)query, countExpected);
    }

    protected JobDefinition selectJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.disableAuthorization();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
        this.enableAuthorization();
        return jobDefinition;
    }

    protected Job selectJobByProcessInstanceId(String processInstanceId) {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        this.enableAuthorization();
        return job;
    }
}

