/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.history;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricActivityStatistics;
import org.camunda.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class HistoricActivityStatisticsAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").getId();
    }

    @Override
    public void tearDown() {
        this.deleteDeployment(this.deploymentId);
        super.tearDown();
    }

    public void testQueryWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        this.verifyQueryResults(query, 1);
        this.verifyStatisticsResult((HistoricActivityStatistics)query.singleResult(), 3, 0, 0, 0);
    }

    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        this.verifyQueryResults(query, 1);
        this.verifyStatisticsResult((HistoricActivityStatistics)query.singleResult(), 3, 0, 0, 0);
    }

    public void testQueryIncludingFinishedWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectAnyTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryIncludingFinishedWithReadHistoryPermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectAnyTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished();
        this.verifyQueryResults(query, 3);
        List statistics = query.list();
        HistoricActivityStatistics start = this.getStatisticsByKey(statistics, "theStart");
        this.verifyStatisticsResult(start, 0, 3, 0, 0);
        HistoricActivityStatistics task = this.getStatisticsByKey(statistics, "theTask");
        this.verifyStatisticsResult(task, 2, 1, 0, 0);
        HistoricActivityStatistics end = this.getStatisticsByKey(statistics, "theEnd");
        this.verifyStatisticsResult(end, 0, 1, 0, 0);
    }

    public void testQueryIncludingFinishedWithReadHistoryPermissionOnAnyProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectAnyTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished();
        this.verifyQueryResults(query, 3);
        List statistics = query.list();
        HistoricActivityStatistics start = this.getStatisticsByKey(statistics, "theStart");
        this.verifyStatisticsResult(start, 0, 3, 0, 0);
        HistoricActivityStatistics task = this.getStatisticsByKey(statistics, "theTask");
        this.verifyStatisticsResult(task, 2, 1, 0, 0);
        HistoricActivityStatistics end = this.getStatisticsByKey(statistics, "theEnd");
        this.verifyStatisticsResult(end, 0, 1, 0, 0);
    }

    public void testQueryIncludingCanceledWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.enableAuthorization();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryIncludingCanceledWithReadHistoryPermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled();
        this.verifyQueryResults(query, 1);
        List statistics = query.list();
        HistoricActivityStatistics task = this.getStatisticsByKey(statistics, "theTask");
        this.verifyStatisticsResult(task, 2, 0, 1, 0);
    }

    public void testQueryIncludingCanceledWithReadHistoryPermissionOnAnyProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled();
        this.verifyQueryResults(query, 1);
        List statistics = query.list();
        HistoricActivityStatistics task = this.getStatisticsByKey(statistics, "theTask");
        this.verifyStatisticsResult(task, 2, 0, 1, 0);
    }

    public void testQueryIncludingCompleteScopeWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectAnyTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCompleteScope();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryIncludingCompleteScopeWithReadHistoryPermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectAnyTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCompleteScope();
        this.verifyQueryResults(query, 2);
        List statistics = query.list();
        HistoricActivityStatistics task = this.getStatisticsByKey(statistics, "theTask");
        this.verifyStatisticsResult(task, 2, 0, 0, 0);
        HistoricActivityStatistics end = this.getStatisticsByKey(statistics, "theEnd");
        this.verifyStatisticsResult(end, 0, 0, 0, 1);
    }

    public void testQueryIncludingCompleteScopeWithReadHistoryPermissionOnAnyProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectAnyTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCompleteScope();
        this.verifyQueryResults(query, 2);
        List statistics = query.list();
        HistoricActivityStatistics task = this.getStatisticsByKey(statistics, "theTask");
        this.verifyStatisticsResult(task, 2, 0, 0, 0);
        HistoricActivityStatistics end = this.getStatisticsByKey(statistics, "theEnd");
        this.verifyStatisticsResult(end, 0, 0, 0, 1);
    }

    public void testQueryIncludingAllWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.enableAuthorization();
        String taskId = this.selectAnyTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCanceled().includeCompleteScope();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryIncludingAllWithReadHistoryPermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.enableAuthorization();
        String taskId = this.selectAnyTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCanceled().includeCompleteScope();
        this.verifyQueryResults(query, 3);
        List statistics = query.list();
        HistoricActivityStatistics start = this.getStatisticsByKey(statistics, "theStart");
        this.verifyStatisticsResult(start, 0, 3, 0, 0);
        HistoricActivityStatistics task = this.getStatisticsByKey(statistics, "theTask");
        this.verifyStatisticsResult(task, 1, 2, 1, 0);
        HistoricActivityStatistics end = this.getStatisticsByKey(statistics, "theEnd");
        this.verifyStatisticsResult(end, 0, 1, 0, 1);
    }

    public void testQueryIncludingAllWithReadHistoryPermissionOnAnyProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.disableAuthorization();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.enableAuthorization();
        String taskId = this.selectAnyTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCanceled().includeCompleteScope();
        this.verifyQueryResults(query, 3);
        List statistics = query.list();
        HistoricActivityStatistics start = this.getStatisticsByKey(statistics, "theStart");
        this.verifyStatisticsResult(start, 0, 3, 0, 0);
        HistoricActivityStatistics task = this.getStatisticsByKey(statistics, "theTask");
        this.verifyStatisticsResult(task, 1, 2, 1, 0);
        HistoricActivityStatistics end = this.getStatisticsByKey(statistics, "theEnd");
        this.verifyStatisticsResult(end, 0, 1, 0, 1);
    }

    protected void verifyQueryResults(HistoricActivityStatisticsQuery query, int countExpected) {
        this.verifyQueryResults((AbstractQuery)query, countExpected);
    }

    protected void verifyStatisticsResult(HistoricActivityStatistics statistics, int instances, int finished, int canceled, int completeScope) {
        HistoricActivityStatisticsAuthorizationTest.assertEquals((String)"Instances", (long)instances, (long)statistics.getInstances());
        HistoricActivityStatisticsAuthorizationTest.assertEquals((String)"Finished", (long)finished, (long)statistics.getFinished());
        HistoricActivityStatisticsAuthorizationTest.assertEquals((String)"Canceled", (long)canceled, (long)statistics.getCanceled());
        HistoricActivityStatisticsAuthorizationTest.assertEquals((String)"Complete Scope", (long)completeScope, (long)statistics.getCompleteScope());
    }

    protected HistoricActivityStatistics getStatisticsByKey(List<HistoricActivityStatistics> statistics, String key) {
        for (HistoricActivityStatistics result : statistics) {
            if (!key.equals(result.getId())) continue;
            return result;
        }
        HistoricActivityStatisticsAuthorizationTest.fail((String)("No statistics found for key '" + key + "'."));
        return null;
    }

    protected Task selectAnyTask() {
        this.disableAuthorization();
        Task task = (Task)this.taskService.createTaskQuery().listPage(0, 1).get(0);
        this.enableAuthorization();
        return task;
    }
}

