/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.examples.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.variable.Variables;

public class AsyncTaskTest
extends PluggableProcessEngineTestCase {
    public static boolean INVOCATION;
    public static int NUM_INVOCATIONS;

    @Deployment
    public void testAsyncServiceNoListeners() {
        INVOCATION = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncService");
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        AsyncTaskTest.assertEquals((int)1, (int)activityInstance.getChildTransitionInstances().length);
        AsyncTaskTest.assertEquals((int)0, (int)activityInstance.getChildActivityInstances().length);
        AsyncTaskTest.assertNotNull((Object)activityInstance.getChildTransitionInstances()[0]);
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertFalse((boolean)INVOCATION);
        this.executeAvailableJobs();
        AsyncTaskTest.assertTrue((boolean)INVOCATION);
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncServiceListeners() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncService").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncServiceConcurrent() {
        INVOCATION = false;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertFalse((boolean)INVOCATION);
        this.executeAvailableJobs();
        AsyncTaskTest.assertTrue((boolean)INVOCATION);
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncServiceSequentialMultiInstance() {
        NUM_INVOCATIONS = 0;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertEquals((int)0, (int)NUM_INVOCATIONS);
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((int)5, (int)NUM_INVOCATIONS);
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncServiceParallelMultiInstance() {
        NUM_INVOCATIONS = 0;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertEquals((int)0, (int)NUM_INVOCATIONS);
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((int)5, (int)NUM_INVOCATIONS);
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testFailingAsyncServiceTimer() {
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        if (!(job instanceof MessageEntity)) {
            AsyncTaskTest.fail((String)"the job must be a message");
        }
        this.executeAvailableJobs();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        AsyncTaskTest.assertNotNull((Object)execution);
        AsyncTaskTest.assertEquals((String)"service", (String)((String)this.runtimeService.getActiveActivityIds(execution.getId()).get(0)));
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.deleteProcessInstance(execution.getId(), "dead");
    }

    @Deployment
    public void FAILING_testFailingAsyncServiceTimer() {
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        this.executeAvailableJobs();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        AsyncTaskTest.assertNotNull((Object)execution);
        AsyncTaskTest.assertEquals((String)"service", (String)((String)this.runtimeService.getActiveActivityIds(execution.getId()).get(0)));
        AsyncTaskTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 10000L));
        this.executeAvailableJobs();
        AsyncTaskTest.assertNull((Object)this.runtimeService.createExecutionQuery().singleResult());
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncServiceSubProcessTimer() {
        INVOCATION = false;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertFalse((boolean)INVOCATION);
        Job job = (Job)this.managementService.createJobQuery().messages().singleResult();
        this.managementService.executeJob(job.getId());
        AsyncTaskTest.assertTrue((boolean)INVOCATION);
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncServiceSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("subProcess").done());
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncTask() {
        this.runtimeService.startProcessInstanceByKey("asyncTask");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncScript() {
        this.runtimeService.startProcessInstanceByKey("asyncScript").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        String eid = ((Execution)this.runtimeService.createExecutionQuery().singleResult()).getId();
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(eid, "invoked"));
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertEquals((Object)"true", (Object)this.runtimeService.getVariable(eid, "invoked"));
        this.runtimeService.signal(eid);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncTaskTest.testAsyncCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/async/AsyncTaskTest.testAsyncServiceNoListeners.bpmn20.xml"})
    public void testAsyncCallActivity() {
        this.runtimeService.startProcessInstanceByKey("asyncCallactivity");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncUserTask() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncUserTask").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.executeAvailableJobs();
        AsyncTaskTest.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    public void testAsyncManualTask() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncManualTask").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.executeAvailableJobs();
        AsyncTaskTest.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    public void testAsyncIntermediateCatchEvent() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncIntermediateCatchEvent").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.executeAvailableJobs();
        this.runtimeService.correlateMessage("testMessage1");
        AsyncTaskTest.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    public void testAsyncIntermediateThrowEvent() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncIntermediateThrowEvent").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.executeAvailableJobs();
        AsyncTaskTest.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    public void testAsyncExclusiveGateway() {
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("flow", false);
        String pid = this.runtimeService.startProcessInstanceByKey("asyncExclusiveGateway", variables).getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.executeAvailableJobs();
        AsyncTaskTest.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    public void testAsyncInclusiveGateway() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncInclusiveGateway").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.executeAvailableJobs();
        AsyncTaskTest.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        List list = this.taskService.createTaskQuery().list();
        AsyncTaskTest.assertEquals((int)2, (int)list.size());
        for (Task task : list) {
            this.taskService.complete(task.getId());
        }
    }

    @Deployment
    public void testAsyncEventGateway() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncEventGateway").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.executeAvailableJobs();
        AsyncTaskTest.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.correlateMessage("testMessageDef1");
        AsyncTaskTest.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }

    @Deployment
    public void FAILING_testDeleteShouldNotInvokeListeners() {
        RecorderExecutionListener.clear();
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncListener", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.deleteProcessInstance(instance.getId(), "");
        AsyncTaskTest.assertEquals((int)0, (int)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.clear();
    }

    @Deployment
    public void FAILING_testDeleteShouldNotInvokeOutputMapping() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncOutputMapping");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.deleteProcessInstance(instance.getId(), "");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_AUDIT.getId()) {
            AsyncTaskTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        }
    }

    static {
        NUM_INVOCATIONS = 0;
    }
}

