/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.logging.Logger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmd.ActivityInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;

public class CompetingActivityInstanceCancellationTest
extends PluggableProcessEngineTestCase {
    private static Logger log = Logger.getLogger(CompetingActivityInstanceCancellationTest.class.getName());
    Thread testThread = Thread.currentThread();
    static ControllableThread activeThread;
    static String jobId;

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingForkTest.testCompetingFork.bpmn20.xml"})
    public void testCompetingCancellation() throws Exception {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstance[] children = activityInstance.getChildActivityInstances();
        String task1ActivityInstanceId = null;
        String task2ActivityInstanceId = null;
        String task3ActivityInstanceId = null;
        for (ActivityInstance currentInstance : children) {
            String id = currentInstance.getId();
            String activityId = currentInstance.getActivityId();
            if ("task1".equals(activityId)) {
                task1ActivityInstanceId = id;
                continue;
            }
            if ("task2".equals(activityId)) {
                task2ActivityInstanceId = id;
                continue;
            }
            if ("task3".equals(activityId)) {
                task3ActivityInstanceId = id;
                continue;
            }
            CompetingActivityInstanceCancellationTest.fail();
        }
        log.fine("test thread starts thread one");
        CancelActivityInstance threadOne = new CancelActivityInstance(processInstanceId, task1ActivityInstanceId);
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread thread two");
        CancelActivityInstance threadTwo = new CancelActivityInstance(processInstanceId, task2ActivityInstanceId);
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread three");
        CancelActivityInstance threadThree = new CancelActivityInstance(processInstanceId, task3ActivityInstanceId);
        threadThree.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingActivityInstanceCancellationTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingActivityInstanceCancellationTest.assertNotNull((Object)((Object)threadTwo.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
        log.fine("test thread notifies thread 3");
        threadThree.proceedAndWaitTillDone();
        CompetingActivityInstanceCancellationTest.assertNotNull((Object)((Object)threadThree.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadThree.exception.getMessage());
    }

    public class CancelActivityInstance
    extends ControllableThread {
        String processInstanceId;
        String activityInstanceId;
        OptimisticLockingException exception;

        public CancelActivityInstance(String processInstanceId, String activityInstanceId) {
            this.processInstanceId = processInstanceId;
            this.activityInstanceId = activityInstanceId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingActivityInstanceCancellationTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new ControlledCommand(activeThread, (Command<?>)new ActivityInstanceCancellationCmd(this.processInstanceId, this.activityInstanceId)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }
}

