/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.event.error;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class BoundaryErrorEventTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.identityService.setAuthenticatedUserId("kermit");
    }

    protected void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        super.tearDown();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/bpmn/event/error/reviewSalesLead.bpmn20.xml"})
    public void testReviewSalesLeadProcess() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("details", "very interesting");
        variables.put("customerName", "Alfresco");
        String procId = this.runtimeService.startProcessInstanceByKey("reviewSaledLead", variables).getId();
        Task task = (Task)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Provide new sales lead", (String)task.getName());
        this.taskService.complete(task.getId());
        Task ratingTask = (Task)this.taskService.createTaskQuery().taskCandidateGroup("accountancy").singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Review customer rating", (String)ratingTask.getName());
        Task profitabilityTask = (Task)this.taskService.createTaskQuery().taskCandidateGroup("management").singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Review profitability", (String)profitabilityTask.getName());
        variables = new HashMap();
        variables.put("notEnoughInformation", true);
        this.taskService.complete(profitabilityTask.getId(), variables);
        Task provideDetailsTask = (Task)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult();
        BoundaryErrorEventTest.assertEquals((String)"Provide additional details", (String)provideDetailsTask.getName());
        this.taskService.complete(provideDetailsTask.getId());
        List reviewTasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        BoundaryErrorEventTest.assertEquals((String)"Review customer rating", (String)((Task)reviewTasks.get(0)).getName());
        BoundaryErrorEventTest.assertEquals((String)"Review profitability", (String)((Task)reviewTasks.get(1)).getName());
        this.taskService.complete(((Task)reviewTasks.get(0)).getId());
        variables.put("notEnoughInformation", false);
        this.taskService.complete(((Task)reviewTasks.get(1)).getId(), variables);
        this.assertProcessEnded(procId);
    }
}

