/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.identity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class IdentityTest
extends PluggableProcessEngineTestCase {
    public void testAuthentication() {
        User user = this.identityService.newUser("johndoe");
        user.setPassword("xxx");
        this.identityService.saveUser(user);
        IdentityTest.assertTrue((boolean)this.identityService.checkPassword("johndoe", "xxx"));
        IdentityTest.assertFalse((boolean)this.identityService.checkPassword("johndoe", "invalid pwd"));
        this.identityService.deleteUser("johndoe");
    }

    public void testFindGroupsByUserAndType() {
        Group sales = this.identityService.newGroup("sales");
        sales.setType("hierarchy");
        this.identityService.saveGroup(sales);
        Group development = this.identityService.newGroup("development");
        development.setType("hierarchy");
        this.identityService.saveGroup(development);
        Group admin = this.identityService.newGroup("admin");
        admin.setType("security-role");
        this.identityService.saveGroup(admin);
        Group user = this.identityService.newGroup("user");
        user.setType("security-role");
        this.identityService.saveGroup(user);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        User joesmoe = this.identityService.newUser("joesmoe");
        this.identityService.saveUser(joesmoe);
        User jackblack = this.identityService.newUser("jackblack");
        this.identityService.saveUser(jackblack);
        this.identityService.createMembership("johndoe", "sales");
        this.identityService.createMembership("johndoe", "user");
        this.identityService.createMembership("johndoe", "admin");
        this.identityService.createMembership("joesmoe", "user");
        List groups = this.identityService.createGroupQuery().groupMember("johndoe").groupType("security-role").list();
        Set<String> groupIds = this.getGroupIds(groups);
        HashSet<String> expectedGroupIds = new HashSet<String>();
        expectedGroupIds.add("user");
        expectedGroupIds.add("admin");
        IdentityTest.assertEquals(expectedGroupIds, groupIds);
        groups = this.identityService.createGroupQuery().groupMember("joesmoe").groupType("security-role").list();
        groupIds = this.getGroupIds(groups);
        expectedGroupIds = new HashSet();
        expectedGroupIds.add("user");
        IdentityTest.assertEquals(expectedGroupIds, groupIds);
        groups = this.identityService.createGroupQuery().groupMember("jackblack").groupType("security-role").list();
        IdentityTest.assertTrue((boolean)groups.isEmpty());
        this.identityService.deleteGroup("sales");
        this.identityService.deleteGroup("development");
        this.identityService.deleteGroup("admin");
        this.identityService.deleteGroup("user");
        this.identityService.deleteUser("johndoe");
        this.identityService.deleteUser("joesmoe");
        this.identityService.deleteUser("jackblack");
    }

    public void testUser() {
        User user = this.identityService.newUser("johndoe");
        user.setFirstName("John");
        user.setLastName("Doe");
        user.setEmail("johndoe@alfresco.com");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        IdentityTest.assertEquals((String)"johndoe", (String)user.getId());
        IdentityTest.assertEquals((String)"John", (String)user.getFirstName());
        IdentityTest.assertEquals((String)"Doe", (String)user.getLastName());
        IdentityTest.assertEquals((String)"johndoe@alfresco.com", (String)user.getEmail());
        this.identityService.deleteUser("johndoe");
    }

    public void testGroup() {
        Group group = this.identityService.newGroup("sales");
        group.setName("Sales division");
        this.identityService.saveGroup(group);
        group = (Group)this.identityService.createGroupQuery().groupId("sales").singleResult();
        IdentityTest.assertEquals((String)"sales", (String)group.getId());
        IdentityTest.assertEquals((String)"Sales division", (String)group.getName());
        this.identityService.deleteGroup("sales");
    }

    public void testMembership() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        Group development = this.identityService.newGroup("development");
        this.identityService.saveGroup(development);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        User joesmoe = this.identityService.newUser("joesmoe");
        this.identityService.saveUser(joesmoe);
        User jackblack = this.identityService.newUser("jackblack");
        this.identityService.saveUser(jackblack);
        this.identityService.createMembership("johndoe", "sales");
        this.identityService.createMembership("joesmoe", "sales");
        this.identityService.createMembership("joesmoe", "development");
        this.identityService.createMembership("jackblack", "development");
        List groups = this.identityService.createGroupQuery().groupMember("johndoe").list();
        IdentityTest.assertEquals((Object)this.createStringSet("sales"), this.getGroupIds(groups));
        groups = this.identityService.createGroupQuery().groupMember("joesmoe").list();
        IdentityTest.assertEquals((Object)this.createStringSet("sales", "development"), this.getGroupIds(groups));
        groups = this.identityService.createGroupQuery().groupMember("jackblack").list();
        IdentityTest.assertEquals((Object)this.createStringSet("development"), this.getGroupIds(groups));
        List users = this.identityService.createUserQuery().memberOfGroup("sales").list();
        IdentityTest.assertEquals((Object)this.createStringSet("johndoe", "joesmoe"), this.getUserIds(users));
        users = this.identityService.createUserQuery().memberOfGroup("development").list();
        IdentityTest.assertEquals((Object)this.createStringSet("joesmoe", "jackblack"), this.getUserIds(users));
        this.identityService.deleteGroup("sales");
        this.identityService.deleteGroup("development");
        this.identityService.deleteUser("jackblack");
        this.identityService.deleteUser("joesmoe");
        this.identityService.deleteUser("johndoe");
    }

    private Object createStringSet(String ... strings) {
        HashSet<String> stringSet = new HashSet<String>();
        for (String string : strings) {
            stringSet.add(string);
        }
        return stringSet;
    }

    public Set<String> getGroupIds(List<Group> groups) {
        HashSet<String> groupIds = new HashSet<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    public Set<String> getUserIds(List<User> users) {
        HashSet<String> userIds = new HashSet<String>();
        for (User user : users) {
            userIds.add(user.getId());
        }
        return userIds;
    }
}

