/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.cmd.ExecuteJobsCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.jobexecutor.JobExecutorTestCase;

public class JobExecutorCmdHappyTest
extends JobExecutorTestCase {
    static final long SOME_TIME = 928374923546L;
    static final long SECOND = 1000L;

    public void testJobCommandsWithMessage() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        String jobId = (String)commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = JobExecutorCmdHappyTest.this.createTweetMessage("i'm coding a test");
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
        AcquiredJobs acquiredJobs = (AcquiredJobs)commandExecutor.execute((Command)new AcquireJobsCmd(jobExecutor));
        List jobIdsList = acquiredJobs.getJobIdBatches();
        JobExecutorCmdHappyTest.assertEquals((int)1, (int)jobIdsList.size());
        List jobIds = (List)jobIdsList.get(0);
        ArrayList<String> expectedJobIds = new ArrayList<String>();
        expectedJobIds.add(jobId);
        JobExecutorCmdHappyTest.assertEquals(expectedJobIds, new ArrayList(jobIds));
        JobExecutorCmdHappyTest.assertEquals((int)0, (int)this.tweetHandler.getMessages().size());
        commandExecutor.execute((Command)new ExecuteJobsCmd(jobId));
        JobExecutorCmdHappyTest.assertEquals((String)"i'm coding a test", (String)this.tweetHandler.getMessages().get(0));
        JobExecutorCmdHappyTest.assertEquals((int)1, (int)this.tweetHandler.getMessages().size());
        this.clearDatabase();
    }

    public void testJobCommandsWithTimer() {
        ClockUtil.setCurrentTime((Date)new Date(928374923546L));
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        String jobId = (String)commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                TimerEntity timer = JobExecutorCmdHappyTest.this.createTweetTimer("i'm coding a test", new Date(928374933546L));
                commandContext.getJobManager().schedule(timer);
                return timer.getId();
            }
        });
        AcquiredJobs acquiredJobs = (AcquiredJobs)commandExecutor.execute((Command)new AcquireJobsCmd(jobExecutor));
        List jobIdsList = acquiredJobs.getJobIdBatches();
        JobExecutorCmdHappyTest.assertEquals((int)0, (int)jobIdsList.size());
        ArrayList<String> expectedJobIds = new ArrayList<String>();
        ClockUtil.setCurrentTime((Date)new Date(928374943546L));
        acquiredJobs = (AcquiredJobs)commandExecutor.execute((Command)new AcquireJobsCmd(jobExecutor));
        jobIdsList = acquiredJobs.getJobIdBatches();
        JobExecutorCmdHappyTest.assertEquals((int)1, (int)jobIdsList.size());
        List jobIds = (List)jobIdsList.get(0);
        expectedJobIds.add(jobId);
        JobExecutorCmdHappyTest.assertEquals(expectedJobIds, new ArrayList(jobIds));
        JobExecutorCmdHappyTest.assertEquals((int)0, (int)this.tweetHandler.getMessages().size());
        commandExecutor.execute((Command)new ExecuteJobsCmd(jobId));
        JobExecutorCmdHappyTest.assertEquals((String)"i'm coding a test", (String)this.tweetHandler.getMessages().get(0));
        JobExecutorCmdHappyTest.assertEquals((int)1, (int)this.tweetHandler.getMessages().size());
        this.clearDatabase();
    }

    protected void clearDatabase() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List historicJobLogs = JobExecutorCmdHappyTest.this.processEngineConfiguration.getHistoryService().createHistoricJobLogQuery().list();
                for (HistoricJobLog historicJobLog : historicJobLogs) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogById(historicJobLog.getId());
                }
                return null;
            }
        });
    }
}

