/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class ParallelGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static Logger log = Logger.getLogger(ParallelGatewayActivityBehavior.class.getName());

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        PvmActivity activity = execution.getActivity();
        List<PvmTransition> outgoingTransitions = execution.getActivity().getOutgoingTransitions();
        execution.inactivate();
        this.lockConcurrentRoot(execution);
        List<ActivityExecution> joinedExecutions = execution.findInactiveConcurrentExecutions(activity);
        int nbrOfExecutionsToJoin = execution.getActivity().getIncomingTransitions().size();
        int nbrOfExecutionsJoined = joinedExecutions.size();
        if (nbrOfExecutionsJoined == nbrOfExecutionsToJoin) {
            log.fine("parallel gateway '" + activity.getId() + "' activates: " + nbrOfExecutionsJoined + " of " + nbrOfExecutionsToJoin + " joined");
            execution.leaveActivityViaTransitions(outgoingTransitions, joinedExecutions);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("parallel gateway '" + activity.getId() + "' does not activate: " + nbrOfExecutionsJoined + " of " + nbrOfExecutionsToJoin + " joined");
        }
    }
}

