/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.delegate;

import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.delegate.DelegateInvocation;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.DelegateInterceptor;

public class DefaultDelegateInterceptor
implements DelegateInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInvocation(final DelegateInvocation invocation) throws Exception {
        BaseDelegateExecution contextExecution = invocation.getContextExecution();
        ProcessApplicationReference processApplication = ProcessApplicationContextUtil.getTargetProcessApplication((CoreExecution)contextExecution);
        if (processApplication != null && ProcessApplicationContextUtil.requiresContextSwitch(processApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    DefaultDelegateInterceptor.this.handleInvocation(invocation);
                    return null;
                }
            }, processApplication);
        } else {
            CommandContext commandContext = Context.getCommandContext();
            boolean oldValue = commandContext.isAuthorizationCheckEnabled();
            ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
            if (!configuration.isAuthorizationEnabledForCustomCode()) {
                commandContext.disableAuthorizationCheck();
            }
            try {
                invocation.proceed();
            }
            finally {
                if (oldValue) {
                    commandContext.enableAuthorizationCheck();
                }
            }
        }
    }
}

