/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.embedded;

import java.util.List;
import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.application.impl.embedded.TestApplicationReusingExistingEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithAdditionalResourceSuffixes;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithCustomEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithResources;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithoutEngine;
import org.camunda.bpm.application.impl.embedded.TestApplicationWithoutProcesses;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;

public class EmbeddedProcessApplicationTest
extends PluggableProcessEngineTestCase {
    protected RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
    protected boolean defaultEngineRegistered;

    public void registerProcessEngine() {
        this.runtimeContainerDelegate.registerProcessEngine(this.processEngine);
        this.defaultEngineRegistered = true;
    }

    protected void setUp() throws Exception {
        this.defaultEngineRegistered = false;
    }

    public void tearDown() {
        if (this.defaultEngineRegistered) {
            this.runtimeContainerDelegate.unregisterProcessEngine(this.processEngine);
        }
    }

    public void testDeployAppWithoutEngine() {
        TestApplicationWithoutEngine processApplication = new TestApplicationWithoutEngine();
        processApplication.deploy();
        processApplication.undeploy();
    }

    public void testDeployAppWithoutProcesses() {
        this.registerProcessEngine();
        TestApplicationWithoutProcesses processApplication = new TestApplicationWithoutProcesses();
        processApplication.deploy();
        ProcessEngine processEngine = BpmPlatform.getProcessEngineService().getDefaultProcessEngine();
        long deployments = processEngine.getRepositoryService().createDeploymentQuery().count();
        EmbeddedProcessApplicationTest.assertEquals((long)0L, (long)deployments);
        processApplication.undeploy();
    }

    public void testDeployAppWithCustomEngine() {
        TestApplicationWithCustomEngine processApplication = new TestApplicationWithCustomEngine();
        processApplication.deploy();
        ProcessEngine processEngine = BpmPlatform.getProcessEngineService().getProcessEngine("embeddedEngine");
        EmbeddedProcessApplicationTest.assertNotNull((Object)processEngine);
        EmbeddedProcessApplicationTest.assertEquals((String)"embeddedEngine", (String)processEngine.getName());
        ProcessEngineConfigurationImpl configuration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        EmbeddedProcessApplicationTest.assertTrue((boolean)configuration.isJobExecutorDeploymentAware());
        EmbeddedProcessApplicationTest.assertTrue((boolean)configuration.isJobExecutorPreferTimerJobs());
        EmbeddedProcessApplicationTest.assertTrue((boolean)configuration.isJobExecutorAcquireByDueDate());
        EmbeddedProcessApplicationTest.assertEquals((int)5, (int)configuration.getJdbcMaxActiveConnections());
        processApplication.undeploy();
    }

    public void testDeployAppReusingExistingEngine() {
        this.registerProcessEngine();
        TestApplicationReusingExistingEngine processApplication = new TestApplicationReusingExistingEngine();
        processApplication.deploy();
        EmbeddedProcessApplicationTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        processApplication.undeploy();
        EmbeddedProcessApplicationTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
    }

    public void testDeployAppWithAdditionalResourceSuffixes() {
        this.registerProcessEngine();
        TestApplicationWithAdditionalResourceSuffixes processApplication = new TestApplicationWithAdditionalResourceSuffixes();
        processApplication.deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        EmbeddedProcessApplicationTest.assertNotNull((Object)deployment);
        List deploymentResources = this.repositoryService.getDeploymentResources(deployment.getId());
        EmbeddedProcessApplicationTest.assertEquals((int)4, (int)deploymentResources.size());
        processApplication.undeploy();
        EmbeddedProcessApplicationTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
    }

    public void testDeployAppWithResources() {
        this.registerProcessEngine();
        TestApplicationWithResources processApplication = new TestApplicationWithResources();
        processApplication.deploy();
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        EmbeddedProcessApplicationTest.assertNotNull((Object)deployment);
        List deploymentResources = this.repositoryService.getDeploymentResources(deployment.getId());
        EmbeddedProcessApplicationTest.assertEquals((int)4, (int)deploymentResources.size());
        processApplication.undeploy();
        EmbeddedProcessApplicationTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
    }
}

