/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.authorization.util.AuthorizationTestUtil;

public class AuthorizationServiceAuthorizationsTest
extends PluggableProcessEngineTestCase {
    private static final String jonny2 = "jonny2";

    protected void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
        super.tearDown();
    }

    public void testCreateAuthorization() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.authorizationService.createNewAuthorization(0);
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((int)1, (int)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.AUTHORIZATION.resourceName(), null, info);
        }
        AuthorizationEntity authorization = new AuthorizationEntity(2);
        authorization.setUserId("someUserId");
        authorization.setResource((Resource)Resources.APPLICATION);
        try {
            this.authorizationService.saveAuthorization((Authorization)authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((int)1, (int)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.AUTHORIZATION.resourceName(), null, info);
        }
    }

    public void testDeleteAuthorization() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.authorizationService.deleteAuthorization(basePerms.getId());
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((int)1, (int)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.DELETE.getName(), Resources.AUTHORIZATION.resourceName(), basePerms.getId(), info);
        }
    }

    public void testUserUpdateAuthorizations() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.UPDATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        basePerms = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        basePerms.addPermission((Permission)Permissions.ALL);
        try {
            this.authorizationService.saveAuthorization(basePerms);
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((int)1, (int)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.UPDATE.getName(), Resources.AUTHORIZATION.resourceName(), basePerms.getId(), info);
        }
        Authorization newAuth = this.authorizationService.createNewAuthorization(1);
        newAuth.setUserId(jonny2);
        newAuth.setResource((Resource)Resources.AUTHORIZATION);
        newAuth.setResourceId("*");
        newAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(newAuth);
    }

    public void testAuthorizationQueryAuthorizations() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        this.authorizationService.saveAuthorization(basePerms);
        AuthorizationServiceAuthorizationsTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceAuthorizationsTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
    }

    protected void cleanupAfterTest() {
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

