/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Picture;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.identity.Account;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class IdentityServiceTest
extends PluggableProcessEngineTestCase {
    public void testIsReadOnly() {
        IdentityServiceTest.assertFalse((boolean)this.identityService.isReadOnly());
    }

    public void testUserInfo() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        this.identityService.setUserInfo("testuser", "myinfo", "myvalue");
        IdentityServiceTest.assertEquals((String)"myvalue", (String)this.identityService.getUserInfo("testuser", "myinfo"));
        this.identityService.setUserInfo("testuser", "myinfo", "myvalue2");
        IdentityServiceTest.assertEquals((String)"myvalue2", (String)this.identityService.getUserInfo("testuser", "myinfo"));
        this.identityService.deleteUserInfo("testuser", "myinfo");
        IdentityServiceTest.assertNull((Object)this.identityService.getUserInfo("testuser", "myinfo"));
        this.identityService.deleteUser(user.getId());
    }

    public void testUserAccount() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        this.identityService.setUserAccount("testuser", "123", "google", "mygoogleusername", "mygooglepwd", null);
        Account googleAccount = this.identityService.getUserAccount("testuser", "123", "google");
        IdentityServiceTest.assertEquals((String)"google", (String)googleAccount.getName());
        IdentityServiceTest.assertEquals((String)"mygoogleusername", (String)googleAccount.getUsername());
        IdentityServiceTest.assertEquals((String)"mygooglepwd", (String)googleAccount.getPassword());
        this.identityService.setUserAccount("testuser", "123", "google", "mygoogleusername2", "mygooglepwd2", null);
        googleAccount = this.identityService.getUserAccount("testuser", "123", "google");
        IdentityServiceTest.assertEquals((String)"google", (String)googleAccount.getName());
        IdentityServiceTest.assertEquals((String)"mygoogleusername2", (String)googleAccount.getUsername());
        IdentityServiceTest.assertEquals((String)"mygooglepwd2", (String)googleAccount.getPassword());
        this.identityService.setUserAccount("testuser", "123", "alfresco", "myalfrescousername", "myalfrescopwd", null);
        this.identityService.setUserInfo("testuser", "myinfo", "myvalue");
        this.identityService.setUserInfo("testuser", "myinfo2", "myvalue2");
        ArrayList<String> expectedUserAccountNames = new ArrayList<String>();
        expectedUserAccountNames.add("google");
        expectedUserAccountNames.add("alfresco");
        List userAccountNames = this.identityService.getUserAccountNames("testuser");
        this.assertListElementsMatch(expectedUserAccountNames, userAccountNames);
        this.identityService.deleteUserAccount("testuser", "google");
        expectedUserAccountNames.remove("google");
        userAccountNames = this.identityService.getUserAccountNames("testuser");
        this.assertListElementsMatch(expectedUserAccountNames, userAccountNames);
        this.identityService.deleteUser(user.getId());
    }

    private void assertListElementsMatch(List<String> list1, List<String> list2) {
        if (list1 != null) {
            IdentityServiceTest.assertNotNull(list2);
            IdentityServiceTest.assertEquals((int)list1.size(), (int)list2.size());
            for (String value : list1) {
                IdentityServiceTest.assertTrue((boolean)list2.contains(value));
            }
        } else {
            IdentityServiceTest.assertNull(list2);
        }
    }

    public void testUserAccountDetails() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        HashMap<String, String> accountDetails = new HashMap<String, String>();
        accountDetails.put("server", "localhost");
        accountDetails.put("port", "35");
        this.identityService.setUserAccount("testuser", "123", "google", "mygoogleusername", "mygooglepwd", accountDetails);
        Account googleAccount = this.identityService.getUserAccount("testuser", "123", "google");
        IdentityServiceTest.assertEquals(accountDetails, (Object)googleAccount.getDetails());
        this.identityService.deleteUser(user.getId());
    }

    public void testCreateExistingUser() {
        User user = this.identityService.newUser("testuser");
        this.identityService.saveUser(user);
        try {
            User secondUser = this.identityService.newUser("testuser");
            this.identityService.saveUser(secondUser);
            IdentityServiceTest.fail((String)"Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.identityService.deleteUser(user.getId());
    }

    public void testUpdateUser() {
        User user = this.identityService.newUser("johndoe");
        user.setFirstName("John");
        user.setLastName("Doe");
        user.setEmail("johndoe@alfresco.com");
        user.setPassword("s3cret");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        user.setEmail("updated@alfresco.com");
        user.setFirstName("Jane");
        user.setLastName("Donnel");
        this.identityService.saveUser(user);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        IdentityServiceTest.assertEquals((String)"Jane", (String)user.getFirstName());
        IdentityServiceTest.assertEquals((String)"Donnel", (String)user.getLastName());
        IdentityServiceTest.assertEquals((String)"updated@alfresco.com", (String)user.getEmail());
        IdentityServiceTest.assertTrue((boolean)this.identityService.checkPassword("johndoe", "s3cret"));
        this.identityService.deleteUser(user.getId());
    }

    public void testUserPicture() {
        User user = this.identityService.newUser("johndoe");
        this.identityService.saveUser(user);
        String userId = user.getId();
        Picture picture = new Picture("niceface".getBytes(), "image/string");
        this.identityService.setUserPicture(userId, picture);
        picture = this.identityService.getUserPicture(userId);
        user = (User)this.identityService.createUserQuery().userId("johndoe").singleResult();
        IdentityServiceTest.assertTrue((String)"byte arrays differ", (boolean)Arrays.equals("niceface".getBytes(), picture.getBytes()));
        IdentityServiceTest.assertEquals((String)"image/string", (String)picture.getMimeType());
        this.identityService.deleteUserPicture("johndoe");
        this.identityService.deleteUserPicture("someone-else-we-dont-know");
        picture = this.identityService.getUserPicture("johndoe");
        IdentityServiceTest.assertNull((Object)picture);
        picture = new Picture("niceface".getBytes(), "image/string");
        this.identityService.setUserPicture(userId, picture);
        this.identityService.deleteUser(user.getId());
    }

    public void testUpdateGroup() {
        Group group = this.identityService.newGroup("sales");
        group.setName("Sales");
        this.identityService.saveGroup(group);
        group = (Group)this.identityService.createGroupQuery().groupId("sales").singleResult();
        group.setName("Updated");
        this.identityService.saveGroup(group);
        group = (Group)this.identityService.createGroupQuery().groupId("sales").singleResult();
        IdentityServiceTest.assertEquals((String)"Updated", (String)group.getName());
        this.identityService.deleteGroup(group.getId());
    }

    public void findUserByUnexistingId() {
        User user = (User)this.identityService.createUserQuery().userId("unexistinguser").singleResult();
        IdentityServiceTest.assertNull((Object)user);
    }

    public void findGroupByUnexistingId() {
        Group group = (Group)this.identityService.createGroupQuery().groupId("unexistinggroup").singleResult();
        IdentityServiceTest.assertNull((Object)group);
    }

    public void testCreateMembershipUnexistingGroup() {
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        try {
            this.identityService.createMembership(johndoe.getId(), "unexistinggroup");
            IdentityServiceTest.fail((String)"Expected exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.identityService.deleteUser(johndoe.getId());
    }

    public void testCreateMembershipUnexistingUser() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        try {
            this.identityService.createMembership("unexistinguser", sales.getId());
            IdentityServiceTest.fail((String)"Expected exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.identityService.deleteGroup(sales.getId());
    }

    public void testCreateMembershipAlreadyExisting() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.createMembership(johndoe.getId(), sales.getId());
        try {
            this.identityService.createMembership(johndoe.getId(), sales.getId());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.identityService.deleteGroup(sales.getId());
        this.identityService.deleteUser(johndoe.getId());
    }

    public void testSaveGroupNullArgument() {
        try {
            this.identityService.saveGroup(null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("group is null", ae.getMessage());
        }
    }

    public void testSaveUserNullArgument() {
        try {
            this.identityService.saveUser(null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("user is null", ae.getMessage());
        }
    }

    public void testFindGroupByIdNullArgument() {
        try {
            this.identityService.createGroupQuery().groupId(null).singleResult();
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("id is null", ae.getMessage());
        }
    }

    public void testCreateMembershipNullArguments() {
        try {
            this.identityService.createMembership(null, "group");
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId is null", ae.getMessage());
        }
        try {
            this.identityService.createMembership("userId", null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("groupId is null", ae.getMessage());
        }
    }

    public void testFindGroupsByUserIdNullArguments() {
        try {
            this.identityService.createGroupQuery().groupMember(null).singleResult();
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId is null", ae.getMessage());
        }
    }

    public void testFindUsersByGroupUnexistingGroup() {
        List users = this.identityService.createUserQuery().memberOfGroup("unexistinggroup").list();
        IdentityServiceTest.assertNotNull((Object)users);
        IdentityServiceTest.assertTrue((boolean)users.isEmpty());
    }

    public void testDeleteGroupNullArguments() {
        try {
            this.identityService.deleteGroup(null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("groupId is null", ae.getMessage());
        }
    }

    public void testDeleteMembership() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.createMembership(johndoe.getId(), sales.getId());
        List groups = this.identityService.createGroupQuery().groupMember(johndoe.getId()).list();
        IdentityServiceTest.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        IdentityServiceTest.assertEquals((String)"sales", (String)((Group)groups.get(0)).getId());
        this.identityService.deleteMembership(johndoe.getId(), sales.getId());
        groups = this.identityService.createGroupQuery().groupMember(johndoe.getId()).list();
        IdentityServiceTest.assertTrue((groups.size() == 0 ? 1 : 0) != 0);
        this.identityService.deleteGroup("sales");
        this.identityService.deleteUser("johndoe");
    }

    public void testDeleteMembershipWhenUserIsNoMember() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.deleteMembership(johndoe.getId(), sales.getId());
        this.identityService.deleteGroup("sales");
        this.identityService.deleteUser("johndoe");
    }

    public void testDeleteMembershipUnexistingGroup() {
        User johndoe = this.identityService.newUser("johndoe");
        this.identityService.saveUser(johndoe);
        this.identityService.deleteMembership(johndoe.getId(), "unexistinggroup");
        this.identityService.deleteUser(johndoe.getId());
    }

    public void testDeleteMembershipUnexistingUser() {
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        this.identityService.deleteMembership("unexistinguser", sales.getId());
        this.identityService.deleteGroup(sales.getId());
    }

    public void testDeleteMemberschipNullArguments() {
        try {
            this.identityService.deleteMembership(null, "group");
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId is null", ae.getMessage());
        }
        try {
            this.identityService.deleteMembership("user", null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("groupId is null", ae.getMessage());
        }
    }

    public void testDeleteUserNullArguments() {
        try {
            this.identityService.deleteUser(null);
            IdentityServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId is null", ae.getMessage());
        }
    }

    public void testDeleteUserUnexistingUserId() {
        this.identityService.deleteUser("unexistinguser");
    }

    public void testCheckPassword() {
        User user = this.identityService.newUser("secureUser");
        user.setPassword("s3cret");
        this.identityService.saveUser(user);
        IdentityServiceTest.assertTrue((boolean)this.identityService.checkPassword(user.getId(), "s3cret"));
        IdentityServiceTest.assertFalse((boolean)this.identityService.checkPassword(user.getId(), "wrong"));
        this.identityService.deleteUser(user.getId());
    }

    public void testUpdatePassword() {
        User user = this.identityService.newUser("secureUser");
        user.setPassword("s3cret");
        this.identityService.saveUser(user);
        IdentityServiceTest.assertTrue((boolean)this.identityService.checkPassword(user.getId(), "s3cret"));
        user.setPassword("new-password");
        this.identityService.saveUser(user);
        IdentityServiceTest.assertTrue((boolean)this.identityService.checkPassword(user.getId(), "new-password"));
        this.identityService.deleteUser(user.getId());
    }

    public void testCheckPasswordNullSafe() {
        IdentityServiceTest.assertFalse((boolean)this.identityService.checkPassword("userId", null));
        IdentityServiceTest.assertFalse((boolean)this.identityService.checkPassword(null, "passwd"));
        IdentityServiceTest.assertFalse((boolean)this.identityService.checkPassword(null, null));
    }

    public void testUserOptimisticLockingException() {
        User user = this.identityService.newUser("kermit");
        this.identityService.saveUser(user);
        User user1 = (User)this.identityService.createUserQuery().singleResult();
        User user2 = (User)this.identityService.createUserQuery().singleResult();
        user1.setFirstName("name one");
        this.identityService.saveUser(user1);
        try {
            user2.setFirstName("name two");
            this.identityService.saveUser(user2);
            IdentityServiceTest.fail((String)"Expected an exception");
        }
        catch (OptimisticLockingException e) {
            // empty catch block
        }
        this.identityService.deleteUser(user.getId());
    }

    public void testGroupOptimisticLockingException() {
        Group group = this.identityService.newGroup("group");
        this.identityService.saveGroup(group);
        Group group1 = (Group)this.identityService.createGroupQuery().singleResult();
        Group group2 = (Group)this.identityService.createGroupQuery().singleResult();
        group1.setName("name one");
        this.identityService.saveGroup(group1);
        try {
            group2.setName("name two");
            this.identityService.saveGroup(group2);
            IdentityServiceTest.fail((String)"Expected an exception");
        }
        catch (OptimisticLockingException e) {
            // empty catch block
        }
        this.identityService.deleteGroup(group.getId());
    }
}

