/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.variable.Variables;

public class JobQueryByPriorityTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioExpressionProcess.bpmn20.xml"})
    public void testOrderByPriority() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("jobPrioExpressionProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        TestOrderingUtil.verifySortingAndCount(this.managementService.createJobQuery().orderByJobPriority().asc(), 5, TestOrderingUtil.jobByPriority());
        TestOrderingUtil.verifySortingAndCount(this.managementService.createJobQuery().orderByJobPriority().desc(), 5, TestOrderingUtil.inverted(TestOrderingUtil.jobByPriority()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioExpressionProcess.bpmn20.xml"})
    public void testFilterByJobPriorityLowerThanOrEquals() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("jobPrioExpressionProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List jobs = this.managementService.createJobQuery().priorityLowerThanOrEquals(2L).list();
        JobQueryByPriorityTest.assertEquals((int)3, (int)jobs.size());
        HashSet<String> processInstanceIds = new HashSet<String>();
        processInstanceIds.add(((ProcessInstance)instances.get(0)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(1)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(2)).getId());
        for (Job job : jobs) {
            JobQueryByPriorityTest.assertTrue((job.getPriority() <= 2L ? 1 : 0) != 0);
            JobQueryByPriorityTest.assertTrue((boolean)processInstanceIds.contains(job.getProcessInstanceId()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioExpressionProcess.bpmn20.xml"})
    public void testFilterByJobPriorityHigherThanOrEquals() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("jobPrioExpressionProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List jobs = this.managementService.createJobQuery().priorityHigherThanOrEquals(2L).list();
        JobQueryByPriorityTest.assertEquals((int)3, (int)jobs.size());
        HashSet<String> processInstanceIds = new HashSet<String>();
        processInstanceIds.add(((ProcessInstance)instances.get(2)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(3)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(4)).getId());
        for (Job job : jobs) {
            JobQueryByPriorityTest.assertTrue((job.getPriority() >= 2L ? 1 : 0) != 0);
            JobQueryByPriorityTest.assertTrue((boolean)processInstanceIds.contains(job.getProcessInstanceId()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/jobPrioExpressionProcess.bpmn20.xml"})
    public void testFilterByJobPriorityLowerAndHigher() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("jobPrioExpressionProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        Job job = (Job)this.managementService.createJobQuery().priorityHigherThanOrEquals(2L).priorityLowerThanOrEquals(2L).singleResult();
        JobQueryByPriorityTest.assertNotNull((Object)job);
        JobQueryByPriorityTest.assertEquals((long)2L, (long)job.getPriority());
        JobQueryByPriorityTest.assertEquals((String)((ProcessInstance)instances.get(2)).getId(), (String)job.getProcessInstanceId());
    }
}

