/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

public class TestOrderingUtil {
    public static NullTolerantComparator<Execution> executionByProcessInstanceId() {
        return new NullTolerantComparator<Execution>(){

            @Override
            public int compare(Execution o1, Execution o2) {
                return o1.getProcessInstanceId().compareTo(o2.getProcessInstanceId());
            }

            @Override
            public boolean hasNullProperty(Execution object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<Execution> executionByProcessDefinitionId(ProcessEngine processEngine) {
        final RuntimeService runtimeService = processEngine.getRuntimeService();
        return new NullTolerantComparator<Execution>(){

            @Override
            public int compare(Execution o1, Execution o2) {
                ProcessInstance processInstance1 = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(o1.getProcessInstanceId()).singleResult();
                ProcessInstance processInstance2 = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(o2.getProcessInstanceId()).singleResult();
                return processInstance1.getProcessDefinitionId().compareTo(processInstance2.getProcessDefinitionId());
            }

            @Override
            public boolean hasNullProperty(Execution object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<Execution> executionByProcessDefinitionKey(ProcessEngine processEngine) {
        final RuntimeService runtimeService = processEngine.getRuntimeService();
        final RepositoryService repositoryService = processEngine.getRepositoryService();
        return new NullTolerantComparator<Execution>(){

            @Override
            public int compare(Execution o1, Execution o2) {
                ProcessInstance processInstance1 = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(o1.getProcessInstanceId()).singleResult();
                ProcessDefinition processDefinition1 = repositoryService.getProcessDefinition(processInstance1.getProcessDefinitionId());
                ProcessInstance processInstance2 = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(o2.getProcessInstanceId()).singleResult();
                ProcessDefinition processDefinition2 = repositoryService.getProcessDefinition(processInstance2.getProcessDefinitionId());
                return processDefinition1.getId().compareTo(processDefinition2.getId());
            }

            @Override
            public boolean hasNullProperty(Execution object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<CaseExecution> caseExecutionByDefinitionId() {
        return new NullTolerantComparator<CaseExecution>(){

            @Override
            public int compare(CaseExecution o1, CaseExecution o2) {
                return o1.getCaseDefinitionId().compareTo(o2.getCaseDefinitionId());
            }

            @Override
            public boolean hasNullProperty(CaseExecution object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<CaseExecution> caseExecutionByDefinitionKey(ProcessEngine processEngine) {
        final RepositoryService repositoryService = processEngine.getRepositoryService();
        return new NullTolerantComparator<CaseExecution>(){

            @Override
            public int compare(CaseExecution o1, CaseExecution o2) {
                CaseDefinition definition1 = repositoryService.getCaseDefinition(o1.getCaseDefinitionId());
                CaseDefinition definition2 = repositoryService.getCaseDefinition(o1.getCaseDefinitionId());
                return definition1.getId().compareTo(definition2.getId());
            }

            @Override
            public boolean hasNullProperty(CaseExecution object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<CaseExecution> caseExecutionById() {
        return new NullTolerantComparator<CaseExecution>(){

            @Override
            public int compare(CaseExecution o1, CaseExecution o2) {
                return o1.getId().compareTo(o2.getId());
            }

            @Override
            public boolean hasNullProperty(CaseExecution object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<Task> taskById() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return o1.getId().compareTo(o2.getId());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByName() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return o1.getName().compareTo(o2.getName());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getName() == null;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByPriority() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return o1.getPriority() - o2.getPriority();
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByAssignee() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return o1.getAssignee().compareTo(o2.getAssignee());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getAssignee() == null;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByDescription() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return o1.getDescription().compareTo(o2.getDescription());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getDescription() == null;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByProcessInstanceId() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return o1.getProcessInstanceId().compareTo(o2.getProcessInstanceId());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getProcessInstanceId() == null;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByExecutionId() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return o1.getExecutionId().compareTo(o2.getExecutionId());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getExecutionId() == null;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByCreateTime() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return TestOrderingUtil.compareDates(o1.getCreateTime(), o2.getCreateTime());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getCreateTime() == null;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByDueDate() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return TestOrderingUtil.compareDates(o1.getDueDate(), o2.getDueDate());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getDueDate() == null;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByFollowUpDate() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return TestOrderingUtil.compareDates(o1.getFollowUpDate(), o2.getFollowUpDate());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getFollowUpDate() == null;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByCaseInstanceId() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return o1.getCaseInstanceId().compareTo(o2.getCaseInstanceId());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getCaseInstanceId() == null;
            }
        };
    }

    public static NullTolerantComparator<Task> taskByCaseExecutionId() {
        return new NullTolerantComparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return o1.getCaseExecutionId().compareTo(o2.getCaseExecutionId());
            }

            @Override
            public boolean hasNullProperty(Task object) {
                return object.getCaseExecutionId() == null;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByTimestamp() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return TestOrderingUtil.compareDates(o1.getTimestamp(), o2.getTimestamp());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobId() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return o1.getJobId().compareTo(o2.getJobId());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobDefinitionId() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return o1.getJobDefinitionId().compareTo(o2.getJobDefinitionId());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobDueDate() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return TestOrderingUtil.compareDates(o1.getJobDueDate(), o2.getJobDueDate());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return object.getJobDueDate() == null;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobRetries() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return Integer.valueOf(o1.getJobRetries()).compareTo(o2.getJobRetries());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByActivityId() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return o1.getActivityId().compareTo(o2.getActivityId());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return object.getActivityId() == null;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByExecutionId() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return o1.getExecutionId().compareTo(o2.getExecutionId());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByProcessInstanceId() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return o1.getProcessInstanceId().compareTo(o2.getProcessInstanceId());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByProcessDefinitionId() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return o1.getProcessDefinitionId().compareTo(o2.getProcessDefinitionId());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByProcessDefinitionKey(ProcessEngine processEngine) {
        final RepositoryService repositoryService = processEngine.getRepositoryService();
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                ProcessDefinition processDefinition1 = repositoryService.getProcessDefinition(o1.getProcessDefinitionId());
                ProcessDefinition processDefinition2 = repositoryService.getProcessDefinition(o1.getProcessDefinitionId());
                return processDefinition1.getId().compareTo(processDefinition2.getId());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByDeploymentId() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return o1.getDeploymentId().compareTo(o2.getDeploymentId());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogByJobPriority() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                return Long.valueOf(o1.getJobPriority()).compareTo(o2.getJobPriority());
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<HistoricJobLog> historicJobLogPartiallyByOccurence() {
        return new NullTolerantComparator<HistoricJobLog>(){

            @Override
            public int compare(HistoricJobLog o1, HistoricJobLog o2) {
                Long firstCounter = ((HistoricJobLogEventEntity)o1).getSequenceCounter();
                Long secondCounter = ((HistoricJobLogEventEntity)o2).getSequenceCounter();
                return firstCounter.compareTo(secondCounter);
            }

            @Override
            public boolean hasNullProperty(HistoricJobLog object) {
                return false;
            }
        };
    }

    public static NullTolerantComparator<Job> jobByPriority() {
        return new NullTolerantComparator<Job>(){

            @Override
            public int compare(Job o1, Job o2) {
                return Long.valueOf(o1.getPriority()).compareTo(o2.getPriority());
            }

            @Override
            public boolean hasNullProperty(Job object) {
                return false;
            }
        };
    }

    public static <T> NullTolerantComparator<T> inverted(final NullTolerantComparator<T> comparator) {
        return new NullTolerantComparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -comparator.compare(o1, o2);
            }

            @Override
            public boolean hasNullProperty(T object) {
                return comparator.hasNullProperty(object);
            }
        };
    }

    public static <T> NullTolerantComparator<T> hierarchical(final NullTolerantComparator<T> baseComparator, final NullTolerantComparator<T> ... minorOrderings) {
        return new NullTolerantComparator<T>(){

            @Override
            public int compare(T o1, T o2, boolean nullPrecedes) {
                int comparison = baseComparator.compare(o1, o2, nullPrecedes);
                for (int i = 0; comparison == 0 && i < minorOrderings.length; ++i) {
                    NullTolerantComparator comparator = minorOrderings[i];
                    comparison = comparator.compare(o1, o2, nullPrecedes);
                }
                return comparison;
            }

            @Override
            public int compare(T o1, T o2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNullProperty(T object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> void verifySorting(List<T> actualElements, NullTolerantComparator<T> expectedOrdering) {
        boolean leadingNullOrdering = TestOrderingUtil.orderingConsistent(actualElements, expectedOrdering, true);
        if (leadingNullOrdering) {
            return;
        }
        boolean trailingNullOrdering = TestOrderingUtil.orderingConsistent(actualElements, expectedOrdering, false);
        TestCase.assertTrue((String)"Ordering not consistent with comparator", (boolean)trailingNullOrdering);
    }

    public static <T> boolean orderingConsistent(List<T> actualElements, NullTolerantComparator<T> expectedOrdering, boolean nullPrecedes) {
        for (int i = 0; i < actualElements.size() - 1; ++i) {
            T nextExecution;
            T currentExecution = actualElements.get(i);
            int comparison = expectedOrdering.compare(currentExecution, nextExecution = actualElements.get(i + 1), nullPrecedes);
            if (comparison <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> void verifySortingAndCount(Query<?, T> query, int expectedCount, NullTolerantComparator<T> expectedOrdering) {
        List elements = query.list();
        TestCase.assertEquals((int)expectedCount, (int)elements.size());
        TestOrderingUtil.verifySorting(elements, expectedOrdering);
    }

    public static int compareDates(Date date1, Date date2) {
        boolean before = date1.before(date2);
        boolean after = date1.after(date2);
        if (before) {
            return -1;
        }
        if (after) {
            return 1;
        }
        return 0;
    }

    public static abstract class NullTolerantComparator<T>
    implements Comparator<T> {
        public int compare(T o1, T o2, boolean nullPrecedes) {
            boolean o1Null = this.hasNullProperty(o1);
            boolean o2Null = this.hasNullProperty(o2);
            if (o1Null) {
                if (o2Null) {
                    return 0;
                }
                if (nullPrecedes) {
                    return -1;
                }
                return 1;
            }
            if (o2Null) {
                if (nullPrecedes) {
                    return 1;
                }
                return -1;
            }
            return this.compare(o1, o2);
        }

        public abstract boolean hasNullProperty(T var1);
    }
}

