/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskAlreadyClaimedException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Event;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;

public class TaskServiceTest
extends PluggableProcessEngineTestCase {
    protected static final String TWO_TASKS_PROCESS = "org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml";

    public void testSaveTaskUpdate() throws Exception {
        HistoricTaskInstance historicTaskInstance;
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        Task task = this.taskService.newTask();
        task.setDescription("description");
        task.setName("taskname");
        task.setPriority(0);
        task.setAssignee("taskassignee");
        task.setOwner("taskowner");
        Date dueDate = sdf.parse("01/02/2003 04:05:06");
        task.setDueDate(dueDate);
        task.setCaseInstanceId("taskcaseinstanceid");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)"description", (String)task.getDescription());
        TaskServiceTest.assertEquals((String)"taskname", (String)task.getName());
        TaskServiceTest.assertEquals((String)"taskassignee", (String)task.getAssignee());
        TaskServiceTest.assertEquals((String)"taskowner", (String)task.getOwner());
        TaskServiceTest.assertEquals((Object)dueDate, (Object)task.getDueDate());
        TaskServiceTest.assertEquals((int)0, (int)task.getPriority());
        TaskServiceTest.assertEquals((String)"taskcaseinstanceid", (String)task.getCaseInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
            TaskServiceTest.assertEquals((String)"taskname", (String)historicTaskInstance.getName());
            TaskServiceTest.assertEquals((String)"description", (String)historicTaskInstance.getDescription());
            TaskServiceTest.assertEquals((String)"taskassignee", (String)historicTaskInstance.getAssignee());
            TaskServiceTest.assertEquals((String)"taskowner", (String)historicTaskInstance.getOwner());
            TaskServiceTest.assertEquals((Object)dueDate, (Object)historicTaskInstance.getDueDate());
            TaskServiceTest.assertEquals((int)0, (int)historicTaskInstance.getPriority());
            TaskServiceTest.assertEquals((String)"taskcaseinstanceid", (String)historicTaskInstance.getCaseInstanceId());
        }
        task.setName("updatedtaskname");
        task.setDescription("updateddescription");
        task.setPriority(1);
        task.setAssignee("updatedassignee");
        task.setOwner("updatedowner");
        dueDate = sdf.parse("01/02/2003 04:05:06");
        task.setDueDate(dueDate);
        task.setCaseInstanceId("updatetaskcaseinstanceid");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)"updatedtaskname", (String)task.getName());
        TaskServiceTest.assertEquals((String)"updateddescription", (String)task.getDescription());
        TaskServiceTest.assertEquals((String)"updatedassignee", (String)task.getAssignee());
        TaskServiceTest.assertEquals((String)"updatedowner", (String)task.getOwner());
        TaskServiceTest.assertEquals((Object)dueDate, (Object)task.getDueDate());
        TaskServiceTest.assertEquals((int)1, (int)task.getPriority());
        TaskServiceTest.assertEquals((String)"updatetaskcaseinstanceid", (String)task.getCaseInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
            TaskServiceTest.assertEquals((String)"updatedtaskname", (String)historicTaskInstance.getName());
            TaskServiceTest.assertEquals((String)"updateddescription", (String)historicTaskInstance.getDescription());
            TaskServiceTest.assertEquals((String)"updatedassignee", (String)historicTaskInstance.getAssignee());
            TaskServiceTest.assertEquals((String)"updatedowner", (String)historicTaskInstance.getOwner());
            TaskServiceTest.assertEquals((Object)dueDate, (Object)historicTaskInstance.getDueDate());
            TaskServiceTest.assertEquals((int)1, (int)historicTaskInstance.getPriority());
            TaskServiceTest.assertEquals((String)"updatetaskcaseinstanceid", (String)historicTaskInstance.getCaseInstanceId());
        }
        this.taskService.deleteTask(task.getId(), true);
    }

    public void testSaveTaskSetParentTaskId() {
        Task parent = this.taskService.newTask("parent");
        this.taskService.saveTask(parent);
        Task task = this.taskService.newTask("subTask");
        task.setParentTaskId("parent");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId("subTask").singleResult();
        TaskServiceTest.assertEquals((String)parent.getId(), (String)task.getParentTaskId());
        this.taskService.deleteTask("parent", true);
        this.taskService.deleteTask("subTask", true);
    }

    public void testSaveTaskWithNonExistingParentTask() {
        Task task = this.taskService.newTask();
        task.setParentTaskId("non-existing");
        try {
            this.taskService.saveTask(task);
            TaskServiceTest.fail((String)"It should not be possible to save a task with a non existing parent task.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    public void testTaskOwner() {
        Task task = this.taskService.newTask();
        task.setOwner("johndoe");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getOwner());
        task.setOwner("joesmoe");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)"joesmoe", (String)task.getOwner());
        this.taskService.deleteTask(task.getId(), true);
    }

    public void testTaskComments() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            task.setOwner("johndoe");
            this.taskService.saveTask(task);
            String taskId = task.getId();
            this.identityService.setAuthenticatedUserId("johndoe");
            Comment comment = this.taskService.createComment(taskId, null, "look at this \n       isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg kajsh dfuieqpgkja rzvkfnjviuqerhogiuvysbegkjz lkhf ais liasduh flaisduh ajiasudh vaisudhv nsfd");
            TaskServiceTest.assertNotNull((Object)comment.getId());
            TaskServiceTest.assertEquals((String)"johndoe", (String)comment.getUserId());
            TaskServiceTest.assertEquals((String)taskId, (String)comment.getTaskId());
            TaskServiceTest.assertNull((Object)comment.getProcessInstanceId());
            TaskServiceTest.assertEquals((String)"look at this isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg ...", (String)((Event)comment).getMessage());
            TaskServiceTest.assertEquals((String)"look at this \n       isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg kajsh dfuieqpgkja rzvkfnjviuqerhogiuvysbegkjz lkhf ais liasduh flaisduh ajiasudh vaisudhv nsfd", (String)comment.getFullMessage());
            TaskServiceTest.assertNotNull((Object)comment.getTime());
            this.taskService.createComment(taskId, "pid", "one");
            this.taskService.createComment(taskId, "pid", "two");
            HashSet<String> expectedComments = new HashSet<String>();
            expectedComments.add("one");
            expectedComments.add("two");
            HashSet<String> comments = new HashSet<String>();
            for (Comment cmt : this.taskService.getProcessInstanceComments("pid")) {
                comments.add(cmt.getFullMessage());
            }
            TaskServiceTest.assertEquals(expectedComments, comments);
            this.taskService.deleteTask(taskId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddTaskCommentNull() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask("testId");
            this.taskService.saveTask(task);
            try {
                this.taskService.createComment(task.getId(), null, null);
                TaskServiceTest.fail((String)"Expected process engine exception");
            }
            catch (ProcessEngineException processEngineException) {
            }
            finally {
                this.taskService.deleteTask(task.getId(), true);
            }
        }
    }

    public void testAddTaskNullComment() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            try {
                this.taskService.createComment(null, null, "test");
                TaskServiceTest.fail((String)"Expected process engine exception");
            }
            catch (ProcessEngineException processEngineException) {
                // empty catch block
            }
        }
    }

    public void testTaskAttachments() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            task.setOwner("johndoe");
            this.taskService.saveTask(task);
            String taskId = task.getId();
            this.identityService.setAuthenticatedUserId("johndoe");
            this.taskService.createAttachment("web page", taskId, "someprocessinstanceid", "weatherforcast", "temperatures and more", "http://weather.com");
            Attachment attachment = (Attachment)this.taskService.getTaskAttachments(taskId).get(0);
            TaskServiceTest.assertEquals((String)"weatherforcast", (String)attachment.getName());
            TaskServiceTest.assertEquals((String)"temperatures and more", (String)attachment.getDescription());
            TaskServiceTest.assertEquals((String)"web page", (String)attachment.getType());
            TaskServiceTest.assertEquals((String)taskId, (String)attachment.getTaskId());
            TaskServiceTest.assertEquals((String)"someprocessinstanceid", (String)attachment.getProcessInstanceId());
            TaskServiceTest.assertEquals((String)"http://weather.com", (String)attachment.getUrl());
            TaskServiceTest.assertNull((Object)this.taskService.getAttachmentContent(attachment.getId()));
            this.taskService.deleteTask(taskId);
            TaskServiceTest.assertEquals((int)0, (int)this.taskService.getTaskComments(taskId).size());
            TaskServiceTest.assertEquals((int)1, (int)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).list().size());
            this.taskService.deleteTask(taskId, true);
        }
    }

    public void testTaskDelegation() {
        Task task = this.taskService.newTask();
        task.setOwner("johndoe");
        task.delegate("joesmoe");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getOwner());
        TaskServiceTest.assertEquals((String)"joesmoe", (String)task.getAssignee());
        TaskServiceTest.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
        this.taskService.resolveTask(taskId);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getOwner());
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        TaskServiceTest.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        task.setAssignee(null);
        task.setDelegationState(null);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getOwner());
        TaskServiceTest.assertNull((Object)task.getAssignee());
        TaskServiceTest.assertNull((Object)task.getDelegationState());
        task.setAssignee("jackblack");
        task.setDelegationState(DelegationState.RESOLVED);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getOwner());
        TaskServiceTest.assertEquals((String)"jackblack", (String)task.getAssignee());
        TaskServiceTest.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    public void testTaskDelegationThroughServiceCall() {
        Task task = this.taskService.newTask();
        task.setOwner("johndoe");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        this.taskService.delegateTask(taskId, "joesmoe");
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getOwner());
        TaskServiceTest.assertEquals((String)"joesmoe", (String)task.getAssignee());
        TaskServiceTest.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
        this.taskService.resolveTask(taskId);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getOwner());
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        TaskServiceTest.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    public void testTaskAssignee() {
        Task task = this.taskService.newTask();
        task.setAssignee("johndoe");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        task.setAssignee("joesmoe");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)"joesmoe", (String)task.getAssignee());
        this.taskService.deleteTask(task.getId(), true);
    }

    public void testSaveTaskNullTask() {
        try {
            this.taskService.saveTask(null);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("task is null", ae.getMessage());
        }
    }

    public void testDeleteTaskNullTaskId() {
        try {
            this.taskService.deleteTask(null);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testDeleteTaskUnexistingTaskId() {
        this.taskService.deleteTask("unexistingtaskid");
    }

    public void testDeleteTasksNullTaskIds() {
        try {
            this.taskService.deleteTasks(null);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testDeleteTasksTaskIdsUnexistingTaskId() {
        Task existingTask = this.taskService.newTask();
        this.taskService.saveTask(existingTask);
        this.taskService.deleteTasks(Arrays.asList("unexistingtaskid1", existingTask.getId()), true);
        existingTask = (Task)this.taskService.createTaskQuery().taskId(existingTask.getId()).singleResult();
        TaskServiceTest.assertNull((Object)existingTask);
    }

    public void testClaimNullArguments() {
        try {
            this.taskService.claim(null, "userid");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testClaimUnexistingTaskId() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.claim("unexistingtaskid", user.getId());
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingtaskid", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    public void testClaimAlreadyClaimedTaskByOtherUser() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        User secondUser = this.identityService.newUser("seconduser");
        this.identityService.saveUser(secondUser);
        this.taskService.claim(task.getId(), user.getId());
        try {
            this.taskService.claim(task.getId(), secondUser.getId());
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (TaskAlreadyClaimedException ae) {
            this.assertTextPresent("Task '" + task.getId() + "' is already claimed by someone else.", ae.getMessage());
        }
        this.taskService.deleteTask(task.getId(), true);
        this.identityService.deleteUser(user.getId());
        this.identityService.deleteUser(secondUser.getId());
    }

    public void testClaimAlreadyClaimedTaskBySameUser() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        this.taskService.claim(task.getId(), user.getId());
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        this.taskService.claim(task.getId(), user.getId());
        this.taskService.deleteTask(task.getId(), true);
        this.identityService.deleteUser(user.getId());
    }

    public void testUnClaimTask() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        this.taskService.claim(task.getId(), user.getId());
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)user.getId(), (String)task.getAssignee());
        this.taskService.claim(task.getId(), null);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertNull((Object)task.getAssignee());
        this.taskService.deleteTask(task.getId(), true);
        this.identityService.deleteUser(user.getId());
    }

    public void testCompleteTaskNullTaskId() {
        try {
            this.taskService.complete(null);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testCompleteTaskUnexistingTaskId() {
        try {
            this.taskService.complete("unexistingtask");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingtask", ae.getMessage());
        }
    }

    public void testCompleteTaskWithParametersNullTaskId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myKey", "myValue");
        try {
            this.taskService.complete(null, variables);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testCompleteTaskWithParametersUnexistingTaskId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myKey", "myValue");
        try {
            this.taskService.complete("unexistingtask", variables);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingtask", ae.getMessage());
        }
    }

    public void testCompleteTaskWithParametersNullParameters() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.complete(taskId, null);
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertNull((Object)task);
    }

    public void testCompleteTaskWithParametersEmptyParameters() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.complete(taskId, Collections.EMPTY_MAP);
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertNull((Object)task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testCompleteWithParametersTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskServiceTest.assertEquals((String)"First task", (String)task.getName());
        HashMap<String, String> taskParams = new HashMap<String, String>();
        taskParams.put("myParam", "myValue");
        this.taskService.complete(task.getId(), taskParams);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskServiceTest.assertEquals((String)"Second task", (String)task.getName());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        TaskServiceTest.assertEquals((int)1, (int)variables.size());
        TaskServiceTest.assertEquals((Object)"myValue", variables.get("myParam"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCompleteTaskShouldCompleteCaseExecution() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskServiceTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskServiceTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        TaskServiceTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        TaskServiceTest.assertNotNull((Object)caseInstance);
        TaskServiceTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    public void testResolveTaskNullTaskId() {
        try {
            this.taskService.resolveTask(null);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testResolveTaskUnexistingTaskId() {
        try {
            this.taskService.resolveTask("unexistingtask");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingtask", ae.getMessage());
        }
    }

    public void testResolveTaskWithParametersNullParameters() {
        Task task = this.taskService.newTask();
        task.setDelegationState(DelegationState.PENDING);
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.resolveTask(taskId, null);
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    public void testResolveTaskWithParametersEmptyParameters() {
        Task task = this.taskService.newTask();
        task.setDelegationState(DelegationState.PENDING);
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.resolveTask(taskId, Collections.EMPTY_MAP);
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testResolveWithParametersTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskServiceTest.assertEquals((String)"First task", (String)task.getName());
        task.delegate("johndoe");
        HashMap<String, String> taskParams = new HashMap<String, String>();
        taskParams.put("myParam", "myValue");
        this.taskService.resolveTask(task.getId(), taskParams);
        task = (Task)this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED).singleResult();
        TaskServiceTest.assertEquals((String)"First task", (String)task.getName());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        TaskServiceTest.assertEquals((int)1, (int)variables.size());
        TaskServiceTest.assertEquals((Object)"myValue", variables.get("myParam"));
    }

    public void testSetAssignee() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        Task task = this.taskService.newTask();
        TaskServiceTest.assertNull((Object)task.getAssignee());
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), user.getId());
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)user.getId(), (String)task.getAssignee());
        this.identityService.deleteUser(user.getId());
        this.taskService.deleteTask(task.getId(), true);
    }

    public void testSetAssigneeNullTaskId() {
        try {
            this.taskService.setAssignee(null, "userId");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testSetAssigneeUnexistingTask() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.setAssignee("unexistingTaskId", user.getId());
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    public void testAddCandidateUserDuplicate() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.addCandidateUser(task.getId(), user.getId());
        this.taskService.addCandidateUser(task.getId(), user.getId());
        this.identityService.deleteUser(user.getId());
        this.taskService.deleteTask(task.getId(), true);
    }

    public void testAddCandidateUserNullTaskId() {
        try {
            this.taskService.addCandidateUser(null, "userId");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testAddCandidateUserNullUserId() {
        try {
            this.taskService.addCandidateUser("taskId", null);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId and groupId cannot both be null", ae.getMessage());
        }
    }

    public void testAddCandidateUserUnexistingTask() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.addCandidateUser("unexistingTaskId", user.getId());
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    public void testAddCandidateGroupNullTaskId() {
        try {
            this.taskService.addCandidateGroup(null, "groupId");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testAddCandidateGroupNullGroupId() {
        try {
            this.taskService.addCandidateGroup("taskId", null);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId and groupId cannot both be null", ae.getMessage());
        }
    }

    public void testAddCandidateGroupUnexistingTask() {
        Group group = this.identityService.newGroup("group");
        this.identityService.saveGroup(group);
        try {
            this.taskService.addCandidateGroup("unexistingTaskId", group.getId());
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteGroup(group.getId());
    }

    public void testAddGroupIdentityLinkNullTaskId() {
        try {
            this.taskService.addGroupIdentityLink(null, "groupId", "candidate");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testAddGroupIdentityLinkNullUserId() {
        try {
            this.taskService.addGroupIdentityLink("taskId", null, "candidate");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId and groupId cannot both be null", ae.getMessage());
        }
    }

    public void testAddGroupIdentityLinkUnexistingTask() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.addGroupIdentityLink("unexistingTaskId", user.getId(), "candidate");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    public void testAddUserIdentityLinkNullTaskId() {
        try {
            this.taskService.addUserIdentityLink(null, "userId", "candidate");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testAddUserIdentityLinkNullUserId() {
        try {
            this.taskService.addUserIdentityLink("taskId", null, "candidate");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("userId and groupId cannot both be null", ae.getMessage());
        }
    }

    public void testAddUserIdentityLinkUnexistingTask() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.addUserIdentityLink("unexistingTaskId", user.getId(), "candidate");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    public void testGetIdentityLinksWithCandidateUser() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.taskService.addCandidateUser(taskId, "kermit");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        TaskServiceTest.assertEquals((int)1, (int)identityLinks.size());
        TaskServiceTest.assertEquals((String)"kermit", (String)((IdentityLink)identityLinks.get(0)).getUserId());
        TaskServiceTest.assertNull((Object)((IdentityLink)identityLinks.get(0)).getGroupId());
        TaskServiceTest.assertEquals((String)"candidate", (String)((IdentityLink)identityLinks.get(0)).getType());
        this.taskService.deleteTask(taskId, true);
        this.identityService.deleteUser("kermit");
    }

    public void testGetIdentityLinksWithCandidateGroup() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.identityService.saveGroup(this.identityService.newGroup("muppets"));
        this.taskService.addCandidateGroup(taskId, "muppets");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        TaskServiceTest.assertEquals((int)1, (int)identityLinks.size());
        TaskServiceTest.assertEquals((String)"muppets", (String)((IdentityLink)identityLinks.get(0)).getGroupId());
        TaskServiceTest.assertNull((Object)((IdentityLink)identityLinks.get(0)).getUserId());
        TaskServiceTest.assertEquals((String)"candidate", (String)((IdentityLink)identityLinks.get(0)).getType());
        this.taskService.deleteTask(taskId, true);
        this.identityService.deleteGroup("muppets");
    }

    public void testGetIdentityLinksWithAssignee() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.taskService.claim(taskId, "kermit");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        TaskServiceTest.assertEquals((int)1, (int)identityLinks.size());
        TaskServiceTest.assertEquals((String)"kermit", (String)((IdentityLink)identityLinks.get(0)).getUserId());
        TaskServiceTest.assertNull((Object)((IdentityLink)identityLinks.get(0)).getGroupId());
        TaskServiceTest.assertEquals((String)"assignee", (String)((IdentityLink)identityLinks.get(0)).getType());
        this.taskService.deleteTask(taskId, true);
        this.identityService.deleteUser("kermit");
    }

    public void testGetIdentityLinksWithNonExistingAssignee() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.claim(taskId, "nonExistingAssignee");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        TaskServiceTest.assertEquals((int)1, (int)identityLinks.size());
        TaskServiceTest.assertEquals((String)"nonExistingAssignee", (String)((IdentityLink)identityLinks.get(0)).getUserId());
        TaskServiceTest.assertNull((Object)((IdentityLink)identityLinks.get(0)).getGroupId());
        TaskServiceTest.assertEquals((String)"assignee", (String)((IdentityLink)identityLinks.get(0)).getType());
        this.taskService.deleteTask(taskId, true);
    }

    public void testGetIdentityLinksWithOwner() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.taskService.claim(taskId, "kermit");
        this.taskService.delegateTask(taskId, "fozzie");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        TaskServiceTest.assertEquals((int)2, (int)identityLinks.size());
        IdentityLink assignee = (IdentityLink)identityLinks.get(0);
        TaskServiceTest.assertEquals((String)"fozzie", (String)assignee.getUserId());
        TaskServiceTest.assertNull((Object)assignee.getGroupId());
        TaskServiceTest.assertEquals((String)"assignee", (String)assignee.getType());
        IdentityLink owner = (IdentityLink)identityLinks.get(1);
        TaskServiceTest.assertEquals((String)"kermit", (String)owner.getUserId());
        TaskServiceTest.assertNull((Object)owner.getGroupId());
        TaskServiceTest.assertEquals((String)"owner", (String)owner.getType());
        this.taskService.deleteTask(taskId, true);
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("fozzie");
    }

    public void testGetIdentityLinksWithNonExistingOwner() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.claim(taskId, "nonExistingOwner");
        this.taskService.delegateTask(taskId, "nonExistingAssignee");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        TaskServiceTest.assertEquals((int)2, (int)identityLinks.size());
        IdentityLink assignee = (IdentityLink)identityLinks.get(0);
        TaskServiceTest.assertEquals((String)"nonExistingAssignee", (String)assignee.getUserId());
        TaskServiceTest.assertNull((Object)assignee.getGroupId());
        TaskServiceTest.assertEquals((String)"assignee", (String)assignee.getType());
        IdentityLink owner = (IdentityLink)identityLinks.get(1);
        TaskServiceTest.assertEquals((String)"nonExistingOwner", (String)owner.getUserId());
        TaskServiceTest.assertNull((Object)owner.getGroupId());
        TaskServiceTest.assertEquals((String)"owner", (String)owner.getType());
        this.taskService.deleteTask(taskId, true);
    }

    public void testSetPriority() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setPriority(task.getId(), 12345);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((int)12345, (int)task.getPriority());
        this.taskService.deleteTask(task.getId(), true);
    }

    public void testSetPriorityUnexistingTaskId() {
        try {
            this.taskService.setPriority("unexistingtask", 12345);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Cannot find task with id unexistingtask", ae.getMessage());
        }
    }

    public void testSetPriorityNullTaskId() {
        try {
            this.taskService.setPriority(null, 12345);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    public void testSetDelegationState() {
        Task task = this.taskService.newTask();
        task.setOwner("wuzh");
        task.delegate("other");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((String)"wuzh", (String)task.getOwner());
        TaskServiceTest.assertEquals((String)"other", (String)task.getAssignee());
        TaskServiceTest.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
        task.setDelegationState(DelegationState.RESOLVED);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        TaskServiceTest.assertEquals((String)"wuzh", (String)task.getOwner());
        TaskServiceTest.assertEquals((String)"other", (String)task.getAssignee());
        TaskServiceTest.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    private void checkHistoricVariableUpdateEntity(String variableName, String processInstanceId) {
        if (this.processEngineConfiguration.getHistoryLevel().getId() == ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
            boolean deletedVariableUpdateFound = false;
            List resultSet = this.historyService.createHistoricDetailQuery().processInstanceId(processInstanceId).list();
            for (HistoricDetail currentHistoricDetail : resultSet) {
                TaskServiceTest.assertTrue((boolean)(currentHistoricDetail instanceof HistoricDetailVariableInstanceUpdateEntity));
                HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = (HistoricDetailVariableInstanceUpdateEntity)currentHistoricDetail;
                if (!historicVariableUpdate.getName().equals(variableName) || historicVariableUpdate.getValue() != null) continue;
                if (deletedVariableUpdateFound) {
                    TaskServiceTest.fail((String)"Mismatch: A HistoricVariableUpdateEntity with a null value already found");
                    continue;
                }
                deletedVariableUpdateFound = true;
            }
            TaskServiceTest.assertTrue((boolean)deletedVariableUpdateFound);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariable() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariable(currentTask.getId(), "variable1", (Object)"value1");
        TaskServiceTest.assertEquals((Object)"value1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        this.taskService.removeVariable(currentTask.getId(), "variable1");
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    public void testRemoveVariableNullTaskId() {
        try {
            this.taskService.removeVariable(null, "variable");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> varsToDelete = new HashMap<String, String>();
        varsToDelete.put("variable1", "value1");
        varsToDelete.put("variable2", "value2");
        this.taskService.setVariables(currentTask.getId(), varsToDelete);
        this.taskService.setVariable(currentTask.getId(), "variable3", (Object)"value3");
        TaskServiceTest.assertEquals((Object)"value1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        TaskServiceTest.assertEquals((Object)"value2", (Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        TaskServiceTest.assertEquals((Object)"value3", (Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable2"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable3"));
        this.taskService.removeVariables(currentTask.getId(), varsToDelete.keySet());
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        TaskServiceTest.assertEquals((Object)"value3", (Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable2"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    public void testRemoveVariablesNullTaskId() {
        try {
            this.taskService.removeVariables(null, (Collection)Collections.EMPTY_LIST);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariableLocal() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariableLocal(currentTask.getId(), "variable1", (Object)"value1");
        TaskServiceTest.assertEquals((Object)"value1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        TaskServiceTest.assertEquals((Object)"value1", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        this.taskService.removeVariableLocal(currentTask.getId(), "variable1");
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    public void testRemoveVariableLocalNullTaskId() {
        try {
            this.taskService.removeVariableLocal(null, "variable");
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariablesLocal() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> varsToDelete = new HashMap<String, String>();
        varsToDelete.put("variable1", "value1");
        varsToDelete.put("variable2", "value2");
        this.taskService.setVariablesLocal(currentTask.getId(), varsToDelete);
        this.taskService.setVariableLocal(currentTask.getId(), "variable3", (Object)"value3");
        TaskServiceTest.assertEquals((Object)"value1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        TaskServiceTest.assertEquals((Object)"value2", (Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        TaskServiceTest.assertEquals((Object)"value3", (Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        TaskServiceTest.assertEquals((Object)"value1", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        TaskServiceTest.assertEquals((Object)"value2", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable2"));
        TaskServiceTest.assertEquals((Object)"value3", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable3"));
        this.taskService.removeVariables(currentTask.getId(), varsToDelete.keySet());
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        TaskServiceTest.assertEquals((Object)"value3", (Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable2"));
        TaskServiceTest.assertEquals((Object)"value3", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    public void testRemoveVariablesLocalNullTaskId() {
        try {
            this.taskService.removeVariablesLocal(null, (Collection)Collections.EMPTY_LIST);
            TaskServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testUserTaskOptimisticLocking() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task1 = (Task)this.taskService.createTaskQuery().singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().singleResult();
        task1.setDescription("test description one");
        this.taskService.saveTask(task1);
        try {
            task2.setDescription("test description two");
            this.taskService.saveTask(task2);
            TaskServiceTest.fail((String)"Expecting exception");
        }
        catch (OptimisticLockingException optimisticLockingException) {
            // empty catch block
        }
    }

    public void testDeleteTaskWithDeleteReason() {
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            Task task = this.taskService.newTask();
            task.setName("test task");
            this.taskService.saveTask(task);
            TaskServiceTest.assertNotNull((Object)task.getId());
            this.taskService.deleteTask(task.getId(), "deleted for testing purposes");
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
            TaskServiceTest.assertNotNull((Object)historicTaskInstance);
            TaskServiceTest.assertEquals((String)"deleted for testing purposes", (String)historicTaskInstance.getDeleteReason());
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteTaskPartOfProcess() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskServiceTest.assertNotNull((Object)task);
        try {
            this.taskService.deleteTask(task.getId());
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running process", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTask(task.getId(), true);
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running process", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTask(task.getId(), "test");
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running process", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()));
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running process", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()), true);
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running process", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()), "test");
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running process", (String)ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDeleteTaskPartOfCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskServiceTest.assertNotNull((Object)task);
        try {
            this.taskService.deleteTask(task.getId());
            TaskServiceTest.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running case instance", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTask(task.getId(), true);
            TaskServiceTest.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running case instance", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTask(task.getId(), "test");
            TaskServiceTest.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running case instance", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()));
            TaskServiceTest.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running case instance", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()), true);
            TaskServiceTest.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running case instance", (String)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()), "test");
            TaskServiceTest.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            TaskServiceTest.assertEquals((String)"The task cannot be deleted because is part of a running case instance", (String)ae.getMessage());
        }
    }

    public void testGetTaskCommentByTaskIdAndCommentId() {
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            this.taskService.saveTask(task);
            String taskId = task.getId();
            Comment comment = this.taskService.createComment(taskId, null, "look at this \n       isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg kajsh dfuieqpgkja rzvkfnjviuqerhogiuvysbegkjz lkhf ais liasduh flaisduh ajiasudh vaisudhv nsfd");
            comment = this.taskService.getTaskComment(taskId, comment.getId());
            TaskServiceTest.assertNotNull((Object)comment.getId());
            TaskServiceTest.assertEquals((String)taskId, (String)comment.getTaskId());
            TaskServiceTest.assertNull((Object)comment.getProcessInstanceId());
            TaskServiceTest.assertEquals((String)"look at this isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg ...", (String)((Event)comment).getMessage());
            TaskServiceTest.assertEquals((String)"look at this \n       isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg kajsh dfuieqpgkja rzvkfnjviuqerhogiuvysbegkjz lkhf ais liasduh flaisduh ajiasudh vaisudhv nsfd", (String)comment.getFullMessage());
            TaskServiceTest.assertNotNull((Object)comment.getTime());
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    public void testTaskAttachmentByTaskIdAndAttachmentId() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            this.taskService.saveTask(task);
            String taskId = task.getId();
            Attachment attachment = this.taskService.createAttachment("web page", taskId, "someprocessinstanceid", "weatherforcast", "temperatures and more", "http://weather.com");
            String attachmentId = attachment.getId();
            attachment = this.taskService.getTaskAttachment(taskId, attachmentId);
            TaskServiceTest.assertEquals((String)"weatherforcast", (String)attachment.getName());
            TaskServiceTest.assertEquals((String)"temperatures and more", (String)attachment.getDescription());
            TaskServiceTest.assertEquals((String)"web page", (String)attachment.getType());
            TaskServiceTest.assertEquals((String)taskId, (String)attachment.getTaskId());
            TaskServiceTest.assertEquals((String)"someprocessinstanceid", (String)attachment.getProcessInstanceId());
            TaskServiceTest.assertEquals((String)"http://weather.com", (String)attachment.getUrl());
            TaskServiceTest.assertNull((Object)this.taskService.getAttachmentContent(attachment.getId()));
            this.taskService.deleteTaskAttachment(taskId, attachmentId);
            TaskServiceTest.assertNull((Object)this.taskService.getTaskAttachment(taskId, attachmentId));
            this.taskService.deleteTask(taskId, true);
        }
    }

    public void testGetTaskAttachmentContentByTaskIdAndAttachmentId() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            this.taskService.saveTask(task);
            String taskId = task.getId();
            Attachment attachment = this.taskService.createAttachment("web page", taskId, "someprocessinstanceid", "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
            String attachmentId = attachment.getId();
            InputStream taskAttachmentContent = this.taskService.getTaskAttachmentContent(taskId, attachmentId);
            TaskServiceTest.assertNotNull((Object)taskAttachmentContent);
            byte[] byteContent = IoUtil.readInputStream((InputStream)taskAttachmentContent, (String)"weatherforcast");
            TaskServiceTest.assertEquals((String)"someContent", (String)new String(byteContent));
            this.taskService.deleteTask(taskId, true);
        }
    }

    public void testGetTaskAttachmentWithNullParameters() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Attachment attachment = this.taskService.getTaskAttachment(null, null);
            TaskServiceTest.assertNull((Object)attachment);
        }
    }

    public void testGetTaskAttachmentContentWithNullParameters() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            InputStream content = this.taskService.getTaskAttachmentContent(null, null);
            TaskServiceTest.assertNull((Object)content);
        }
    }

    public void testCreateTaskAttachmentWithNullTaskId() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            try {
                this.taskService.createAttachment("web page", null, "someprocessinstanceid", "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
                TaskServiceTest.fail((String)"expected process engine exception");
            }
            catch (ProcessEngineException processEngineException) {
                // empty catch block
            }
        }
    }

    public void testDeleteTaskAttachmentWithNullParameters() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            try {
                this.taskService.deleteTaskAttachment(null, null);
                TaskServiceTest.fail((String)"expected process engine exception");
            }
            catch (ProcessEngineException processEngineException) {
                // empty catch block
            }
        }
    }

    public void testDeleteTaskAttachmentWithTaskIdNull() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            try {
                this.taskService.deleteTaskAttachment(null, "myAttachmentId");
                TaskServiceTest.fail((String)"expected process engine exception");
            }
            catch (ProcessEngineException processEngineException) {
                // empty catch block
            }
        }
    }

    public void testGetTaskAttachmentsWithTaskIdNull() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            TaskServiceTest.assertEquals(Collections.emptyList(), (Object)this.taskService.getTaskAttachments(null));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testUpdateVariablesLocal() {
        HashMap<String, String> globalVars = new HashMap<String, String>();
        globalVars.put("variable4", "value4");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", globalVars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> localVars = new HashMap<String, String>();
        localVars.put("variable1", "value1");
        localVars.put("variable2", "value2");
        localVars.put("variable3", "value3");
        this.taskService.setVariablesLocal(currentTask.getId(), localVars);
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(currentTask.getId(), modifications, deletions);
        TaskServiceTest.assertEquals((Object)"anotherValue1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        TaskServiceTest.assertEquals((Object)"value4", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable4"));
    }

    public void testUpdateVariablesLocalForNonExistingTaskId() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal("nonExistingId", modifications, deletions);
            TaskServiceTest.fail((String)"expected process engine exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testUpdateVariablesLocaForNullTaskId() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal(null, modifications, deletions);
            TaskServiceTest.fail((String)"expected process engine exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testUpdateVariables() {
        HashMap<String, String> globalVars = new HashMap<String, String>();
        globalVars.put("variable4", "value4");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", globalVars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> localVars = new HashMap<String, String>();
        localVars.put("variable1", "value1");
        localVars.put("variable2", "value2");
        localVars.put("variable3", "value3");
        this.taskService.setVariablesLocal(currentTask.getId(), localVars);
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        ((TaskServiceImpl)this.taskService).updateVariables(currentTask.getId(), modifications, deletions);
        TaskServiceTest.assertEquals((Object)"anotherValue1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        TaskServiceTest.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        TaskServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable4"));
    }

    public void testUpdateVariablesForNonExistingTaskId() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        try {
            ((TaskServiceImpl)this.taskService).updateVariables("nonExistingId", modifications, deletions);
            TaskServiceTest.fail((String)"expected process engine exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testUpdateVariablesForNullTaskId() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        try {
            ((TaskServiceImpl)this.taskService).updateVariables(null, modifications, deletions);
            TaskServiceTest.fail((String)"expected process engine exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testTaskCaseInstanceId() {
        Task task = this.taskService.newTask();
        task.setCaseInstanceId("aCaseInstanceId");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)"aCaseInstanceId", (String)task.getCaseInstanceId());
        task.setCaseInstanceId("anotherCaseInstanceId");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskServiceTest.assertEquals((String)"anotherCaseInstanceId", (String)task.getCaseInstanceId());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesTyped() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        VariableMap variablesTyped = this.taskService.getVariablesTyped(taskId);
        TaskServiceTest.assertEquals(vars, (Object)variablesTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesTypedDeserialize() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("broken", (Object)Variables.serializedObjectValue((String)"broken").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName("unexisting").create()));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        VariableMap variablesTyped = this.taskService.getVariablesTyped(taskId, false);
        TaskServiceTest.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        variablesTyped = this.taskService.getVariablesTyped(taskId, Arrays.asList("broken"), false);
        TaskServiceTest.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        try {
            this.taskService.getVariablesTyped(taskId);
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
        try {
            this.taskService.getVariablesTyped(taskId, Arrays.asList("broken"), true);
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesLocalTyped() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, vars);
        VariableMap variablesTyped = this.taskService.getVariablesLocalTyped(taskId);
        TaskServiceTest.assertEquals(vars, (Object)variablesTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesLocalTypedDeserialize() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, (Map)Variables.createVariables().putValue("broken", (Object)Variables.serializedObjectValue((String)"broken").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName("unexisting").create()));
        VariableMap variablesTyped = this.taskService.getVariablesLocalTyped(taskId, false);
        TaskServiceTest.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        variablesTyped = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("broken"), false);
        TaskServiceTest.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        try {
            this.taskService.getVariablesLocalTyped(taskId);
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
        try {
            this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("broken"), true);
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testHumanTaskCompleteWithVariables() {
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String variableName = "aVariable";
        String variableValue = "aValue";
        this.taskService.complete(taskId, (Map)Variables.createVariables().putValue(variableName, (Object)variableValue));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        TaskServiceTest.assertEquals((String)variable.getName(), (String)variableName);
        TaskServiceTest.assertEquals((Object)variable.getValue(), (Object)variableValue);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testHumanTaskWithLocalVariablesCompleteWithVariable() {
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        String variableName = "aVariable";
        String variableValue = "aValue";
        String variableAnotherValue = "anotherValue";
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, variableName, (Object)variableValue);
        this.taskService.complete(taskId, (Map)Variables.createVariables().putValue(variableName, (Object)variableAnotherValue));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        TaskServiceTest.assertEquals((String)variable.getName(), (String)variableName);
        TaskServiceTest.assertEquals((Object)variable.getValue(), (Object)variableAnotherValue);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testUserTaskWithLocalVariablesCompleteWithVariable() {
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        String variableName = "aVariable";
        String variableValue = "aValue";
        String variableAnotherValue = "anotherValue";
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, variableName, (Object)variableValue);
        this.taskService.complete(taskId, (Map)Variables.createVariables().putValue(variableName, (Object)variableAnotherValue));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        TaskServiceTest.assertEquals((String)variable.getName(), (String)variableName);
        TaskServiceTest.assertEquals((Object)variable.getValue(), (Object)variableAnotherValue);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testHumanTaskLocalVariables() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).manualStart();
        String variableName = "aVariable";
        String variableValue = "aValue";
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, variableName, (Object)variableValue);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().taskIdIn(new String[]{taskId}).singleResult();
        TaskServiceTest.assertNotNull((Object)variableInstance);
        TaskServiceTest.assertEquals((String)caseInstanceId, (String)variableInstance.getCaseInstanceId());
        TaskServiceTest.assertEquals((String)humanTaskId, (String)variableInstance.getCaseExecutionId());
    }
}

