/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.management.TableMetaData;
import org.camunda.bpm.engine.management.TablePage;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class ManagementAuthorizationTest
extends AuthorizationTest {
    public void testGetTableCountWithoutAuthorization() {
        try {
            this.managementService.getTableCount();
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the table count");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 The user with id 'test' is not a member of the group with id 'camunda-admin'", message);
        }
    }

    public void testGetTableCountAsCamundaAdmin() {
        this.createGroup("camunda-admin");
        this.createMembership(this.userId, "camunda-admin");
        Map tableCount = this.managementService.getTableCount();
        ManagementAuthorizationTest.assertFalse((boolean)tableCount.isEmpty());
    }

    public void testGetTableNameWithoutAuthorization() {
        try {
            this.managementService.getTableName(ProcessDefinitionEntity.class);
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the table name");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 The user with id 'test' is not a member of the group with id 'camunda-admin'", message);
        }
    }

    public void testGetTableNameAsCamundaAdmin() {
        this.createGroup("camunda-admin");
        this.createMembership(this.userId, "camunda-admin");
        String tableName = this.managementService.getTableName(ProcessDefinitionEntity.class);
        ManagementAuthorizationTest.assertEquals((String)"ACT_RE_PROCDEF", (String)tableName);
    }

    public void testGetTableMetaDataWithoutAuthorization() {
        try {
            this.managementService.getTableMetaData("ACT_RE_PROCDEF");
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the table meta data");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 The user with id 'test' is not a member of the group with id 'camunda-admin'", message);
        }
    }

    public void testGetTableMetaDataAsCamundaAdmin() {
        this.createGroup("camunda-admin");
        this.createMembership(this.userId, "camunda-admin");
        TableMetaData tableMetaData = this.managementService.getTableMetaData("ACT_RE_PROCDEF");
        ManagementAuthorizationTest.assertNotNull((Object)tableMetaData);
    }

    public void testTablePageQueryWithoutAuthorization() {
        try {
            this.managementService.createTablePageQuery().tableName("ACT_RE_PROCDEF").listPage(0, Integer.MAX_VALUE);
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get a table page");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 The user with id 'test' is not a member of the group with id 'camunda-admin'", message);
        }
    }

    public void testTablePageQueryAsCamundaAdmin() {
        this.createGroup("camunda-admin");
        this.createMembership(this.userId, "camunda-admin");
        TablePage page = this.managementService.createTablePageQuery().tableName("ACT_RE_PROCDEF").listPage(0, Integer.MAX_VALUE);
        ManagementAuthorizationTest.assertNotNull((Object)page);
    }

    public void testGetHistoryLevelWithoutAuthorization() {
        try {
            this.managementService.getHistoryLevel();
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the history level");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 The user with id 'test' is not a member of the group with id 'camunda-admin'", message);
        }
    }

    public void testGetHistoryLevelAsCamundaAdmin() {
        this.createGroup("camunda-admin");
        this.createMembership(this.userId, "camunda-admin");
        int historyLevel = this.managementService.getHistoryLevel();
        ManagementAuthorizationTest.assertEquals((int)this.processEngineConfiguration.getHistoryLevel().getId(), (int)historyLevel);
    }

    public void testDataSchemaUpgradeWithoutAuthorization() {
        try {
            this.managementService.databaseSchemaUpgrade(null, null, null);
            ManagementAuthorizationTest.fail((String)"Exception expected: It should not be possible to upgrade the database schema");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent("ENGINE-03029 The user with id 'test' is not a member of the group with id 'camunda-admin'", message);
        }
    }

    @Override
    protected Group createGroup(String groupId) {
        this.disableAuthorization();
        Group group = super.createGroup(groupId);
        this.enableAuthorization();
        return group;
    }

    protected void createMembership(String userId, String groupId) {
        this.disableAuthorization();
        this.identityService.createMembership(userId, groupId);
        this.enableAuthorization();
    }
}

