/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.history;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class HistoricIncidentAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected static final String ANOTHER_ONE_INCIDENT_PROCESS_KEY = "anotherOneIncidentProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/authorization/timerStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/authorization/oneIncidentProcess.bpmn20.xml", "org/camunda/bpm/engine/test/authorization/anotherOneIncidentProcess.bpmn20.xml").getId();
    }

    @Override
    public void tearDown() {
        this.deleteDeployment(this.deploymentId);
        super.tearDown();
    }

    public void testQueryForStandaloneHistoricIncidents() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String jobId = null;
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            jobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 1);
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    public void testStartTimerJobIncidentQueryWithoutAuthorization() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testStartTimerJobIncidentQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testStartTimerJobIncidentQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testStartTimerJobIncidentQueryWithReadInstancePermissionOnAnyProcessDefinition() {
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 5);
    }

    public void testMixedQueryWithoutAuthorization() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String firstJobId = null;
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            firstJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(firstJobId, 0);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String secondJobId = null;
        jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            secondJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(secondJobId, 0);
        this.enableAuthorization();
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 2);
        this.disableAuthorization();
        this.managementService.deleteJob(firstJobId);
        this.managementService.deleteJob(secondJobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    public void testMixedQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String firstJobId = null;
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            firstJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(firstJobId, 0);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String secondJobId = null;
        jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            secondJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(secondJobId, 0);
        this.enableAuthorization();
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 4);
        this.disableAuthorization();
        this.managementService.deleteJob(firstJobId);
        this.managementService.deleteJob(secondJobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    public void testMixedQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String firstJobId = null;
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            firstJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(firstJobId, 0);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY, true, new Date());
        String secondJobId = null;
        jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            secondJobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(secondJobId, 0);
        this.enableAuthorization();
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        this.verifyQueryResults(query, 7);
        this.disableAuthorization();
        this.managementService.deleteJob(firstJobId);
        this.managementService.deleteJob(secondJobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    protected void verifyQueryResults(HistoricIncidentQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void clearDatabase() {
        this.clearOpLog();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                List incidents = Context.getProcessEngineConfiguration().getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident incident : incidents) {
                    commandContext.getHistoricIncidentManager().delete((DbEntity)((HistoricIncidentEntity)incident));
                }
                return null;
            }
        });
    }
}

