/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.history;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class UserOperationLogAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String ONE_TASK_CASE_KEY = "oneTaskCase";
    protected static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/authorization/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/authorization/timerBoundaryEventProcess.bpmn20.xml").getId();
    }

    @Override
    public void tearDown() {
        this.deleteDeployment(this.deploymentId);
        super.tearDown();
    }

    public void testQueryCreateStandaloneTaskUserOperationLog() {
        String taskId = "myTask";
        this.createTask(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    public void testQuerySetAssigneeStandaloneTaskUserOperationLog() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setAssignee(taskId, "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.deleteTask(taskId, true);
    }

    public void testQuerySetAssigneeTaskUserOperationLogWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQuerySetAssigneeTaskUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQuerySetAssigneeTaskUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQuerySetAssigneeHumanTaskUserOperationLog() {
        this.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQuerySetStandaloneJobRetriesUserOperationLog() {
        this.disableAuthorization();
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, new Date());
        this.enableAuthorization();
        this.disableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
        this.clearDatabase();
    }

    public void testQuerySetJobRetriesUserOperationLogWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobId = this.selectSingleJob().getId();
        this.disableAuthorization();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQuerySetJobRetriesUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobId = this.selectSingleJob().getId();
        this.disableAuthorization();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQuerySetJobRetriesUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        String jobId = this.selectSingleJob().getId();
        this.disableAuthorization();
        this.managementService.setJobRetries(jobId, 5);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQuerySuspendProcessDefinitionUserOperationLogWithoutAuthorization() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.clearDatabase();
    }

    public void testQuerySuspendProcessDefinitionUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.clearDatabase();
    }

    public void testQuerySuspendProcessDefinitionUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.clearDatabase();
    }

    public void testQuerySuspendProcessInstanceUserOperationLogWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 0);
        this.clearDatabase();
    }

    public void testQuerySuspendProcessInstanceUserOperationLogWithReadHistoryPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.clearDatabase();
    }

    public void testQuerySuspendProcessInstanceUserOperationLogWithReadHistoryPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 1);
        this.clearDatabase();
    }

    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.verifyQueryResults(query, 2);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    public void testDeleteStandaloneEntry() {
        String taskId = "myTask";
        this.createTask(taskId);
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.historyService.deleteUserOperationLogEntry(entryId);
        UserOperationLogAuthorizationTest.assertNull((Object)this.historyService.createUserOperationLogQuery().singleResult());
        this.deleteTask(taskId, true);
    }

    public void testDeleteEntryWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        try {
            this.historyService.deleteUserOperationLogEntry(entryId);
            UserOperationLogAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete the user operation log");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteEntryWithDeleteHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.historyService.deleteUserOperationLogEntry(entryId);
        this.disableAuthorization();
        UserOperationLogAuthorizationTest.assertNull((Object)this.historyService.createUserOperationLogQuery().singleResult());
        this.enableAuthorization();
    }

    public void testDeleteEntryWithDeleteHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.enableAuthorization();
        this.historyService.deleteUserOperationLogEntry(entryId);
        this.disableAuthorization();
        UserOperationLogAuthorizationTest.assertNull((Object)this.historyService.createUserOperationLogQuery().singleResult());
        this.enableAuthorization();
    }

    public void testDeleteEntryAfterDeletingDeployment() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY, Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.historyService.deleteUserOperationLogEntry(entryId);
        this.disableAuthorization();
        UserOperationLogAuthorizationTest.assertNull((Object)this.historyService.createUserOperationLogQuery().singleResult());
        this.enableAuthorization();
        this.disableAuthorization();
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.enableAuthorization();
    }

    public void testCaseDeleteEntry() {
        this.createCaseInstanceByKey(ONE_TASK_CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, "demo");
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult()).getId();
        this.historyService.deleteUserOperationLogEntry(entryId);
        UserOperationLogAuthorizationTest.assertNull((Object)this.historyService.createUserOperationLogQuery().singleResult());
    }

    protected void verifyQueryResults(UserOperationLogQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected Job selectSingleJob() {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.enableAuthorization();
        return job;
    }

    protected void clearDatabase() {
        this.clearOpLog();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                List incidents = Context.getProcessEngineConfiguration().getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident incident : incidents) {
                    commandContext.getHistoricIncidentManager().delete((DbEntity)((HistoricIncidentEntity)incident));
                }
                return null;
            }
        });
    }
}

