/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;

public class AuthorizationExceptionInterceptor
extends CommandInterceptor {
    private static Logger log = Logger.getLogger(AuthorizationExceptionInterceptor.class.getName());
    protected boolean isActive;
    protected AuthorizationException lastException;

    public <T> T execute(Command<T> command) {
        try {
            return (T)this.next.execute(command);
        }
        catch (AuthorizationException e) {
            if (!this.isActive) {
                throw e;
            }
            this.lastException = e;
            log.log(Level.INFO, "Caught authorization exception; storing for assertion in test", e);
            return null;
        }
    }

    public void reset() {
        this.lastException = null;
    }

    public AuthorizationException getLastException() {
        return this.lastException;
    }

    public void activate() {
        this.isActive = true;
    }

    public void deactivate() {
        this.isActive = false;
    }
}

