/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.signal.DummyServiceTask;
import org.camunda.bpm.engine.test.examples.bpmn.executionlistener.RecorderExecutionListener;

public class SignalEventTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    public void testSignalCatchIntermediate() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignalBoundary.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    public void testSignalCatchBoundary() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignalBoundaryWithReceiveTask.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    public void testSignalCatchBoundaryWithVariables() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("processName", "catchSignal");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("catchSignal", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("processName", "throwSignal");
        this.runtimeService.startProcessInstanceByKey("throwSignal", variables2);
        SignalEventTest.assertEquals((Object)"catchSignal", (Object)this.runtimeService.getVariable(pi.getId(), "processName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsynch.bpmn20.xml"})
    public void testSignalCatchIntermediateAsynch() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        try {
            ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 1000L));
            this.waitForJobExecutorToProcessAllJobs(10000L);
            SignalEventTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
            SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
            SignalEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        }
        finally {
            ClockUtil.setCurrentTime((Date)new Date());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchMultipleSignals.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAbortSignal.bpmn20.xml"})
    public void testSignalCatchDifferentSignals() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        SignalEventTest.assertEquals((long)2L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwAbort");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Task taskAfterAbort = (Task)this.taskService.createTaskQuery().taskAssignee("gonzo").singleResult();
        SignalEventTest.assertNotNull((Object)taskAfterAbort);
        this.taskService.complete(taskAfterAbort.getId());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void testSignalBoundaryOnSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("signalEventOnSubprocess");
        this.runtimeService.signalEventReceived("stopSignal");
        this.assertProcessEnded(pi.getProcessInstanceId());
    }

    private EventSubscriptionQueryImpl createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.processEngineConfiguration.getCommandExecutorTxRequired());
    }

    @Deployment
    public void testNonInterruptingSignal() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingSignalEvent");
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
        Task currentTask = (Task)tasks.get(0);
        SignalEventTest.assertEquals((String)"My User Task", (String)currentTask.getName());
        this.runtimeService.signalEventReceived("alert");
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            if (task.getName().equals("My User Task") || task.getName().equals("My Second User Task")) continue;
            SignalEventTest.fail((String)("Expected: <My User Task> or <My Second User Task> but was <" + task.getName() + ">."));
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("My User Task").singleResult()).getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
        currentTask = (Task)tasks.get(0);
        SignalEventTest.assertEquals((String)"My Second User Task", (String)currentTask.getName());
    }

    @Deployment
    public void testNonInterruptingSignalWithSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingSignalWithSubProcess");
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
        Task currentTask = (Task)tasks.get(0);
        SignalEventTest.assertEquals((String)"Approve", (String)currentTask.getName());
        this.runtimeService.signalEventReceived("alert");
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            if (task.getName().equals("Approve") || task.getName().equals("Review")) continue;
            SignalEventTest.fail((String)("Expected: <Approve> or <Review> but was <" + task.getName() + ">."));
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Approve").singleResult()).getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
        currentTask = (Task)tasks.get(0);
        SignalEventTest.assertEquals((String)"Review", (String)currentTask.getName());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Review").singleResult()).getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
    }

    @Deployment
    public void testSignalStartEventInEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalStartEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)taskQuery.count());
        this.runtimeService.signalEventReceived("alert");
        SignalEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)0L, (long)taskQuery.count());
        executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)0L, (long)executionQuery.count());
    }

    @Deployment
    public void testNonInterruptingSignalStartEventInEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingSignalStartEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)taskQuery.count());
        this.runtimeService.signalEventReceived("alert");
        SignalEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)taskQuery.count());
        executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)executionQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml"})
    public void testSignalStartEvent() {
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        this.runtimeService.signalEventReceived("alert");
        SignalEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml"})
    public void testSuspendedProcessWithSignalStartEvent() {
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        this.runtimeService.signalEventReceived("alert");
        SignalEventTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.testOtherSignalStartEvent.bpmn20.xml"})
    public void testMultipleProcessesWithSameSignalStartEvent() {
        SignalEventTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        this.runtimeService.signalEventReceived("alert");
        SignalEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    public void testStartProcessInstanceBySignalFromIntermediateThrowingSignalEvent() {
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    public void testIntermediateThrowingSignalEventWithSuspendedSignalStartEvent() {
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("startBySignal").singleResult();
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    public void testProcessesWithMultipleSignalStartEvents() {
        SignalEventTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").count());
        this.runtimeService.signalEventReceived("alert");
        SignalEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertTwiceAndTerminate.bpmn20.xml"})
    public void testThrowSignalMultipleCancellingReceivers() {
        RecorderExecutionListener.clear();
        this.runtimeService.startProcessInstanceByKey("catchAlertTwiceAndTerminate");
        SignalEventTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        this.runtimeService.signalEventReceived("alert");
        SignalEventTest.assertEquals((int)1, (int)RecorderExecutionListener.getRecordedEvents().size());
        SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertTwiceAndTerminate.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    public void testIntermediateThrowSignalMultipleCancellingReceivers() {
        RecorderExecutionListener.clear();
        this.runtimeService.startProcessInstanceByKey("catchAlertTwiceAndTerminate");
        SignalEventTest.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().eventType("signal").eventName("alert").count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((int)1, (int)RecorderExecutionListener.getRecordedEvents().size());
        SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsync.bpmn20.xml"})
    public void testAsyncSignalStartEventJobProperties() {
        ProcessDefinition catchingProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("startBySignal").singleResult();
        this.runtimeService.startProcessInstanceByKey("throwSignalAsync");
        SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Job asyncJob = (Job)this.managementService.createJobQuery().singleResult();
        SignalEventTest.assertEquals((String)catchingProcessDefinition.getId(), (String)asyncJob.getProcessDefinitionId());
        SignalEventTest.assertEquals((String)catchingProcessDefinition.getKey(), (String)asyncJob.getProcessDefinitionKey());
        SignalEventTest.assertNull((Object)asyncJob.getExceptionMessage());
        SignalEventTest.assertNull((Object)asyncJob.getExecutionId());
        SignalEventTest.assertNull((Object)asyncJob.getJobDefinitionId());
        SignalEventTest.assertEquals((long)0L, (long)asyncJob.getPriority());
        SignalEventTest.assertNull((Object)asyncJob.getProcessInstanceId());
        SignalEventTest.assertEquals((int)3, (int)asyncJob.getRetries());
        SignalEventTest.assertNull((Object)asyncJob.getDuedate());
        SignalEventTest.assertNull((Object)asyncJob.getDeploymentId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTest.signalStartEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsync.bpmn20.xml"})
    public void testAsyncSignalStartEvent() {
        ProcessDefinition catchingProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("startBySignal").singleResult();
        this.runtimeService.startProcessInstanceByKey("throwSignalAsync");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        SignalEventTest.assertNotNull((Object)processInstance);
        SignalEventTest.assertEquals((String)catchingProcessDefinition.getId(), (String)processInstance.getProcessDefinitionId());
        SignalEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    public void FAILING_testNoContinuationWhenSignalInterruptsThrowingActivity() {
        this.runtimeService.startProcessInstanceByKey("signalEventSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(subProcessTask.getId());
        SignalEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        SignalEventTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterSubProcessTask").count());
        SignalEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").count());
    }
}

