/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.gateway;

import java.util.ArrayList;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.gateway.ExclusiveGatewayTestOrder;
import org.camunda.bpm.engine.variable.Variables;

public class ExclusiveGatewayTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testDivergingExclusiveGateway() {
        for (int i = 1; i <= 3; ++i) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("exclusiveGwDiverging", CollectionUtil.singletonMap((String)"input", (Object)i));
            ExclusiveGatewayTest.assertEquals((String)("Task " + i), (String)((Task)this.taskService.createTaskQuery().singleResult()).getName());
            this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
        }
    }

    @Deployment
    public void testMergingExclusiveGateway() {
        this.runtimeService.startProcessInstanceByKey("exclusiveGwMerging");
        ExclusiveGatewayTest.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    public void testMultipleValidConditions() {
        this.runtimeService.startProcessInstanceByKey("exclusiveGwMultipleValidConditions", CollectionUtil.singletonMap((String)"input", (Object)5));
        ExclusiveGatewayTest.assertEquals((String)"Task 2", (String)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    @Deployment
    public void testNoSequenceFlowSelected() {
        try {
            this.runtimeService.startProcessInstanceByKey("exclusiveGwNoSeqFlowSelected", CollectionUtil.singletonMap((String)"input", (Object)4));
            ExclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ENGINE-02004 No outgoing sequence flow for the element with id 'exclusiveGw' could be selected for continuing the process.", e.getMessage());
        }
    }

    @Deployment
    public void testWhitespaceInExpression() {
        this.runtimeService.startProcessInstanceByKey("whiteSpaceInExpression", CollectionUtil.singletonMap((String)"input", (Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/ExclusiveGatewayTest.testDivergingExclusiveGateway.bpmn20.xml"})
    public void testUnknownVariableInExpression() {
        try {
            this.runtimeService.startProcessInstanceByKey("exclusiveGwDiverging", CollectionUtil.singletonMap((String)"iinput", (Object)1));
            ExclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Unknown property used in expression", e.getMessage());
        }
    }

    @Deployment
    public void testDecideBasedOnBeanProperty() {
        this.runtimeService.startProcessInstanceByKey("decisionBasedOnBeanProperty", CollectionUtil.singletonMap((String)"order", (Object)new ExclusiveGatewayTestOrder(150)));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ExclusiveGatewayTest.assertNotNull((Object)task);
        ExclusiveGatewayTest.assertEquals((String)"Standard service", (String)task.getName());
    }

    @Deployment
    public void testDecideBasedOnListOrArrayOfBeans() {
        ArrayList<ExclusiveGatewayTestOrder> orders = new ArrayList<ExclusiveGatewayTestOrder>();
        orders.add(new ExclusiveGatewayTestOrder(50));
        orders.add(new ExclusiveGatewayTestOrder(300));
        orders.add(new ExclusiveGatewayTestOrder(175));
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("decisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", orders));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        ExclusiveGatewayTest.assertNotNull((Object)task);
        ExclusiveGatewayTest.assertEquals((String)"Gold Member service", (String)task.getName());
        ExclusiveGatewayTestOrder[] orderArray = orders.toArray(new ExclusiveGatewayTestOrder[orders.size()]);
        orderArray[1].setPrice(10);
        pi = this.runtimeService.startProcessInstanceByKey("decisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", (Object)orderArray));
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        ExclusiveGatewayTest.assertNotNull((Object)task);
        ExclusiveGatewayTest.assertEquals((String)"Basic service", (String)task.getName());
    }

    @Deployment
    public void testDecideBasedOnBeanMethod() {
        this.runtimeService.startProcessInstanceByKey("decisionBasedOnBeanMethod", CollectionUtil.singletonMap((String)"order", (Object)new ExclusiveGatewayTestOrder(300)));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ExclusiveGatewayTest.assertNotNull((Object)task);
        ExclusiveGatewayTest.assertEquals((String)"Gold Member service", (String)task.getName());
    }

    @Deployment
    public void testInvalidMethodExpression() {
        try {
            this.runtimeService.startProcessInstanceByKey("invalidMethodExpression", CollectionUtil.singletonMap((String)"order", (Object)new ExclusiveGatewayTestOrder(50)));
            ExclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Unknown method used in expression", e.getMessage());
        }
    }

    @Deployment
    public void testDefaultSequenceFlow() {
        String procId = this.runtimeService.startProcessInstanceByKey("exclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)1)).getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ExclusiveGatewayTest.assertEquals((String)"Input is one", (String)task.getName());
        this.runtimeService.deleteProcessInstance(procId, null);
        procId = this.runtimeService.startProcessInstanceByKey("exclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)5)).getId();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        ExclusiveGatewayTest.assertEquals((String)"Default input", (String)task.getName());
    }

    @Deployment
    public void testNoIdOnSequenceFlow() {
        this.runtimeService.startProcessInstanceByKey("noIdOnSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)3));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ExclusiveGatewayTest.assertEquals((String)"Input is more than one", (String)task.getName());
    }

    public void testInvalidProcessDefinition() {
        String flowWithoutConditionNoDefaultFlow = "<?xml version='1.0' encoding='UTF-8'?><definitions id='definitions' xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:activiti='http://activiti.org/bpmn' targetNamespace='Examples'>  <process id='exclusiveGwDefaultSequenceFlow'>     <startEvent id='theStart' />     <sequenceFlow id='flow1' sourceRef='theStart' targetRef='exclusiveGw' />     <exclusiveGateway id='exclusiveGw' name='Exclusive Gateway' />     <sequenceFlow id='flow2' sourceRef='exclusiveGw' targetRef='theTask1'>       <conditionExpression xsi:type='tFormalExpression'>${input == 1}</conditionExpression>     </sequenceFlow>     <sequenceFlow id='flow3' sourceRef='exclusiveGw' targetRef='theTask2'/>     <sequenceFlow id='flow4' sourceRef='exclusiveGw' targetRef='theTask2'/>     <userTask id='theTask1' name='Input is one' />     <userTask id='theTask2' name='Default input' />   </process></definitions>";
        try {
            this.repositoryService.createDeployment().addString("myprocess.bpmn20.xml", flowWithoutConditionNoDefaultFlow).deploy();
            ExclusiveGatewayTest.fail((String)"Could deploy a process definition with a sequence flow out of a XOR Gateway without condition with is not the default flow.");
        }
        catch (ProcessEngineException ex) {
            ExclusiveGatewayTest.assertTrue((boolean)ex.getMessage().startsWith("Exclusive Gateway 'exclusiveGw' has outgoing sequence flow 'flow3' without condition which is not the default flow."));
        }
        String defaultFlowWithCondition = "<?xml version='1.0' encoding='UTF-8'?><definitions id='definitions' xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:activiti='http://activiti.org/bpmn' targetNamespace='Examples'>  <process id='exclusiveGwDefaultSequenceFlow'>     <startEvent id='theStart' />     <sequenceFlow id='flow1' sourceRef='theStart' targetRef='exclusiveGw' />     <exclusiveGateway id='exclusiveGw' name='Exclusive Gateway' default='flow3' />     <sequenceFlow id='flow2' sourceRef='exclusiveGw' targetRef='theTask1'>       <conditionExpression xsi:type='tFormalExpression'>${input == 1}</conditionExpression>     </sequenceFlow>     <sequenceFlow id='flow3' sourceRef='exclusiveGw' targetRef='theTask2'>       <conditionExpression xsi:type='tFormalExpression'>${input == 3}</conditionExpression>     </sequenceFlow>     <userTask id='theTask1' name='Input is one' />     <userTask id='theTask2' name='Default input' />   </process></definitions>";
        try {
            this.repositoryService.createDeployment().addString("myprocess.bpmn20.xml", defaultFlowWithCondition).deploy();
            ExclusiveGatewayTest.fail((String)"Could deploy a process definition with a sequence flow out of a XOR Gateway without condition with is not the default flow.");
        }
        catch (ProcessEngineException ex) {
            ExclusiveGatewayTest.assertTrue((boolean)ex.getMessage().startsWith("Exclusive Gateway 'exclusiveGw' has outgoing sequence flow 'flow3' which is the default flow but has a condition too."));
        }
        String noOutgoingFlow = "<?xml version='1.0' encoding='UTF-8'?><definitions id='definitions' xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:activiti='http://activiti.org/bpmn' targetNamespace='Examples'>  <process id='exclusiveGwDefaultSequenceFlow'>     <startEvent id='theStart' />     <sequenceFlow id='flow1' sourceRef='theStart' targetRef='exclusiveGw' />     <exclusiveGateway id='exclusiveGw' name='Exclusive Gateway' />   </process></definitions>";
        try {
            this.repositoryService.createDeployment().addString("myprocess.bpmn20.xml", noOutgoingFlow).deploy();
            ExclusiveGatewayTest.fail((String)"Could deploy a process definition with a sequence flow out of a XOR Gateway without condition with is not the default flow.");
        }
        catch (ProcessEngineException ex) {
            ex.printStackTrace();
            ExclusiveGatewayTest.assertTrue((boolean)ex.getMessage().startsWith("Exclusive Gateway 'exclusiveGw' has no outgoing sequence flows."));
        }
    }

    @Deployment
    public void testLoopWithManyIterations() {
        int numOfIterations = 1000;
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("numOfIterations", (Object)numOfIterations));
    }
}

