/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.deployment;

import java.io.InputStream;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.Deployment;

public class CmmnDeployerTest
extends PluggableProcessEngineTestCase {
    public void testCmmnDeployment() {
        String deploymentId = this.processEngine.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn").deploy().getId();
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        DeploymentQuery deploymentQuery = repositoryService.createDeploymentQuery();
        CmmnDeployerTest.assertEquals((long)1L, (long)deploymentQuery.count());
        CaseDefinitionQuery query = this.processEngine.getRepositoryService().createCaseDefinitionQuery();
        CmmnDeployerTest.assertEquals((long)1L, (long)query.count());
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        CmmnDeployerTest.assertEquals((String)"Case_1", (String)caseDefinition.getKey());
        this.processEngine.getRepositoryService().deleteDeployment(deploymentId);
    }

    public void testDeployTwoCasesWithDuplicateIdAtTheSameTime() {
        try {
            String cmmnResourceName1 = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
            String cmmnResourceName2 = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment2.cmmn";
            this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName1).addClasspathResource(cmmnResourceName2).name("duplicateAtTheSameTime").deploy();
            CmmnDeployerTest.fail();
        }
        catch (Exception e) {
            CmmnDeployerTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.cmmn", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.png"})
    public void testCaseDiagramResource() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.cmmn", (String)caseDefinition.getResourceName());
        CmmnDeployerTest.assertEquals((String)"Case_1", (String)caseDefinition.getKey());
        String diagramResourceName = caseDefinition.getDiagramResourceName();
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.png", (String)diagramResourceName);
        InputStream diagramStream = this.repositoryService.getResourceAsStream(this.deploymentId, "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testCaseDiagramResource.png");
        byte[] diagramBytes = IoUtil.readInputStream((InputStream)diagramStream, (String)"diagram stream");
        CmmnDeployerTest.assertEquals((int)2540, (int)diagramBytes.length);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.cmmn", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.a.png", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.b.png", "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.c.png"})
    public void testMultipleDiagramResourcesProvided() {
        CaseDefinition caseA = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("a").singleResult();
        CaseDefinition caseB = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("b").singleResult();
        CaseDefinition caseC = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("c").singleResult();
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.a.png", (String)caseA.getDiagramResourceName());
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.b.png", (String)caseB.getDiagramResourceName());
        CmmnDeployerTest.assertEquals((String)"org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testMultipleDiagramResourcesProvided.c.png", (String)caseC.getDiagramResourceName());
    }
}

