/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.logging.Logger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.CompetingSignalsTest;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;

public class CompetingJobAcquisitionTest
extends PluggableProcessEngineTestCase {
    private static Logger log = Logger.getLogger(CompetingSignalsTest.class.getName());
    Thread testThread = Thread.currentThread();
    static ControllableThread activeThread;
    static String jobId;

    @Deployment
    public void testCompetingJobAcquisitions() throws Exception {
        this.runtimeService.startProcessInstanceByKey("CompetingJobAcquisitionProcess");
        log.fine("test thread starts thread one");
        JobAcquisitionThread threadOne = new JobAcquisitionThread();
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread two");
        JobAcquisitionThread threadTwo = new JobAcquisitionThread();
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingJobAcquisitionTest.assertNull((Object)((Object)threadOne.exception));
        CompetingJobAcquisitionTest.assertEquals((int)1, (int)threadOne.jobs.size());
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingJobAcquisitionTest.assertNull((Object)((Object)threadTwo.exception));
        CompetingJobAcquisitionTest.assertEquals((int)0, (int)threadTwo.jobs.size());
    }

    public class JobAcquisitionThread
    extends ControllableThread {
        OptimisticLockingException exception;
        AcquiredJobs jobs;

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                JobExecutor jobExecutor = CompetingJobAcquisitionTest.this.processEngineConfiguration.getJobExecutor();
                this.jobs = (AcquiredJobs)CompetingJobAcquisitionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new AcquireJobsCmd(jobExecutor)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }
}

