/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.CompetingSignalsTest;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;

public class CompetingProcessCompletionTest
extends PluggableProcessEngineTestCase {
    private static Logger log = Logger.getLogger(CompetingSignalsTest.class.getName());
    static ControllableThread activeThread;

    @Deployment
    public void testCompetingEnd() throws Exception {
        this.runtimeService.startProcessInstanceByKey("CompetingEndProcess");
        List tasks = this.taskService.createTaskQuery().list();
        CompetingProcessCompletionTest.assertEquals((int)3, (int)tasks.size());
        log.fine("test thread starts thread one");
        CompleteTaskThread threadOne = new CompleteTaskThread(((Task)tasks.get(0)).getId());
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread two");
        CompleteTaskThread threadTwo = new CompleteTaskThread(((Task)tasks.get(1)).getId());
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingProcessCompletionTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingProcessCompletionTest.assertNotNull((Object)((Object)threadTwo.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    public class CompleteTaskThread
    extends ControllableThread {
        String taskId;
        OptimisticLockingException exception;

        public CompleteTaskThread(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingProcessCompletionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new CompleteTaskCmd(this.taskId, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }
}

