/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.logging.Logger;

public class ControllableThread
extends Thread {
    private static Logger log = Logger.getLogger(ControllableThread.class.getName());

    public ControllableThread() {
        this.setName(this.generateName());
    }

    public ControllableThread(Runnable runnable) {
        super(runnable);
        this.setName(this.generateName());
    }

    protected String generateName() {
        String className = this.getClass().getName();
        int dollarIndex = className.lastIndexOf(36);
        return className.substring(dollarIndex + 1);
    }

    public synchronized void startAndWaitUntilControlIsReturned() {
        log.fine("test thread will start " + this.getName() + " and wait till it returns control");
        this.start();
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void returnControlToTestThreadAndWait() {
        log.fine(this.getName() + " will notify test thread and till test thread proceeds this thread");
        this.notify();
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void returnControlToControllableThreadAndWait() {
        this.returnControlToTestThreadAndWait();
    }

    public synchronized void proceedAndWaitTillDone() {
        log.fine("test thread will notify " + this.getName() + " and wait until it completes");
        this.notify();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

