/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.db;

import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.session.Configuration;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PvmTestCase;

public class ConnectionPoolTest
extends PvmTestCase {
    public void testMyBatisConnectionPoolProperlyConfigured() {
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/db/connection-pool.camunda.cfg.xml");
        ProcessEngine engine = config.buildProcessEngine();
        int maxActive = 25;
        int maxIdle = 10;
        int maxCheckoutTime = 30000;
        int maxWaitTime = 25000;
        Integer jdbcStatementTimeout = 300;
        ConnectionPoolTest.assertEquals((int)maxActive, (int)config.getJdbcMaxActiveConnections());
        ConnectionPoolTest.assertEquals((int)maxIdle, (int)config.getJdbcMaxIdleConnections());
        ConnectionPoolTest.assertEquals((int)maxCheckoutTime, (int)config.getJdbcMaxCheckoutTime());
        ConnectionPoolTest.assertEquals((int)maxWaitTime, (int)config.getJdbcMaxWaitTime());
        ConnectionPoolTest.assertEquals((Object)jdbcStatementTimeout, (Object)config.getJdbcStatementTimeout());
        Configuration sessionFactoryConfiguration = config.getDbSqlSessionFactory().getSqlSessionFactory().getConfiguration();
        DataSource datasource = sessionFactoryConfiguration.getEnvironment().getDataSource();
        ConnectionPoolTest.assertTrue((boolean)(datasource instanceof PooledDataSource));
        PooledDataSource pooledDataSource = (PooledDataSource)datasource;
        ConnectionPoolTest.assertEquals((int)maxActive, (int)pooledDataSource.getPoolMaximumActiveConnections());
        ConnectionPoolTest.assertEquals((int)maxIdle, (int)pooledDataSource.getPoolMaximumIdleConnections());
        ConnectionPoolTest.assertEquals((int)maxCheckoutTime, (int)pooledDataSource.getPoolMaximumCheckoutTime());
        ConnectionPoolTest.assertEquals((int)maxWaitTime, (int)pooledDataSource.getPoolTimeToWait());
        ConnectionPoolTest.assertEquals((Object)jdbcStatementTimeout, (Object)sessionFactoryConfiguration.getDefaultStatementTimeout());
        engine.close();
    }
}

