/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.db;

import java.sql.Connection;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class DatabaseTablePrefixTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPerformDatabaseSchemaOperationCreate() throws Exception {
        PooledDataSource pooledDataSource = new PooledDataSource(ReflectUtil.getClassLoader(), "org.h2.Driver", "jdbc:h2:mem:DatabaseTablePrefixTest;DB_CLOSE_DELAY=1000", "sa", "");
        Connection connection = pooledDataSource.getConnection();
        connection.createStatement().execute("drop schema if exists SCHEMA1");
        connection.createStatement().execute("drop schema if exists SCHEMA2");
        connection.createStatement().execute("create schema SCHEMA1");
        connection.createStatement().execute("create schema SCHEMA2");
        connection.close();
        ProcessEngineConfigurationImpl config1 = DatabaseTablePrefixTest.createCustomProcessEngineConfiguration().setProcessEngineName("DatabaseTablePrefixTest-engine1").setDataSource((DataSource)pooledDataSource).setDatabaseSchemaUpdate("NO_CHECK");
        config1.setDatabaseTablePrefix("SCHEMA1.");
        ProcessEngine engine1 = config1.buildProcessEngine();
        ProcessEngineConfigurationImpl config2 = DatabaseTablePrefixTest.createCustomProcessEngineConfiguration().setProcessEngineName("DatabaseTablePrefixTest-engine2").setDataSource((DataSource)pooledDataSource).setDatabaseSchemaUpdate("NO_CHECK");
        config2.setDatabaseTablePrefix("SCHEMA2.");
        ProcessEngine engine2 = config2.buildProcessEngine();
        connection = pooledDataSource.getConnection();
        connection.createStatement().execute("set schema SCHEMA1");
        engine1.getManagementService().databaseSchemaUpgrade(connection, "", "SCHEMA1");
        connection.close();
        connection = pooledDataSource.getConnection();
        connection.createStatement().execute("set schema SCHEMA2");
        engine2.getManagementService().databaseSchemaUpgrade(connection, "", "SCHEMA2");
        connection.close();
        try {
            engine1.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/db/oneJobProcess.bpmn20.xml").deploy();
            DatabaseTablePrefixTest.assertEquals((long)1L, (long)engine1.getRepositoryService().createDeploymentQuery().count());
            DatabaseTablePrefixTest.assertEquals((long)0L, (long)engine2.getRepositoryService().createDeploymentQuery().count());
        }
        finally {
            engine1.close();
            engine2.close();
        }
    }

    private static ProcessEngineConfigurationImpl createCustomProcessEngineConfiguration() {
        return new CustomStandaloneInMemProcessEngineConfiguration().setHistory("full");
    }

    private static class CustomStandaloneInMemProcessEngineConfiguration
    extends StandaloneInMemProcessEngineConfiguration {
        private CustomStandaloneInMemProcessEngineConfiguration() {
        }

        public ProcessEngine buildProcessEngine() {
            this.init();
            return new NoSchemaProcessEngineImpl((ProcessEngineConfigurationImpl)this);
        }

        class NoSchemaProcessEngineImpl
        extends ProcessEngineImpl {
            public NoSchemaProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
                super(processEngineConfiguration);
            }

            protected void executeSchemaOperations() {
            }
        }
    }
}

