/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.junit.Before;

public class DmnScriptOutputTest
extends PluggableProcessEngineTestCase {
    public static final String TEST_PROCESS = "org/camunda/bpm/engine/test/dmn/DmnScriptOutputTest.bpmn20.xml";
    public static final String TEST_DECISION = "org/camunda/bpm/engine/test/dmn/DmnScriptOutputTest.dmn10.xml";

    @Before
    public void setUp() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS).addClasspathResource(TEST_DECISION).deploy().getId();
    }

    public void testNoOutput() {
        ProcessInstance processInstance = this.startTestProcess("no output");
        Object ruleResult = this.runtimeService.getVariable(processInstance.getId(), "ruleResult");
        Object scriptResult = this.runtimeService.getVariable(processInstance.getId(), "scriptResult");
        DmnScriptOutputTest.assertNull((Object)ruleResult);
        DmnScriptOutputTest.assertNull((Object)scriptResult);
    }

    public void testEmptyOutput() {
        ProcessInstance processInstance = this.startTestProcess("empty output");
        Map ruleResult = (Map)this.runtimeService.getVariable(processInstance.getId(), "ruleResult");
        Map scriptResult = (Map)this.runtimeService.getVariable(processInstance.getId(), "scriptResult");
        DmnScriptOutputTest.assertNotNull((Object)ruleResult);
        DmnScriptOutputTest.assertNotNull((Object)scriptResult);
        DmnScriptOutputTest.assertTrue((boolean)ruleResult.isEmpty());
        DmnScriptOutputTest.assertTrue((boolean)scriptResult.isEmpty());
    }

    public void testEmptyMap() {
        ProcessInstance processInstance = this.startTestProcess("empty map");
        List ruleResult = (List)this.runtimeService.getVariable(processInstance.getId(), "ruleResult");
        List scriptResult = (List)this.runtimeService.getVariable(processInstance.getId(), "scriptResult");
        DmnScriptOutputTest.assertNotNull((Object)ruleResult);
        DmnScriptOutputTest.assertNotNull((Object)scriptResult);
        DmnScriptOutputTest.assertEquals((int)2, (int)ruleResult.size());
        DmnScriptOutputTest.assertEquals((int)2, (int)scriptResult.size());
        for (Object output : ruleResult) {
            DmnScriptOutputTest.assertNull(output);
        }
        for (Object output : scriptResult) {
            DmnScriptOutputTest.assertNull(output);
        }
    }

    public void testSingleEntry() {
        ProcessInstance processInstance = this.startTestProcess("single entry");
        String ruleResult = (String)this.runtimeService.getVariable(processInstance.getId(), "ruleResult");
        String scriptResult = (String)this.runtimeService.getVariable(processInstance.getId(), "scriptResult");
        DmnScriptOutputTest.assertNotNull((Object)ruleResult);
        DmnScriptOutputTest.assertNotNull((Object)scriptResult);
        DmnScriptOutputTest.assertEquals((String)"foo", (String)ruleResult);
        DmnScriptOutputTest.assertEquals((String)"foo", (String)scriptResult);
    }

    public void testMultipleEntries() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries");
        Map ruleResult = (Map)this.runtimeService.getVariable(processInstance.getId(), "ruleResult");
        Map scriptResult = (Map)this.runtimeService.getVariable(processInstance.getId(), "scriptResult");
        DmnScriptOutputTest.assertNotNull((Object)ruleResult);
        DmnScriptOutputTest.assertNotNull((Object)scriptResult);
        DmnScriptOutputTest.assertEquals((Object)"foo", ruleResult.get("result1"));
        DmnScriptOutputTest.assertEquals((Object)"foo", ruleResult.get("result2"));
        DmnScriptOutputTest.assertEquals((Object)"foo", scriptResult.get("result1"));
        DmnScriptOutputTest.assertEquals((Object)"foo", scriptResult.get("result2"));
    }

    public void testSingleEntryList() {
        ProcessInstance processInstance = this.startTestProcess("single entry list");
        List ruleResult = (List)this.runtimeService.getVariable(processInstance.getId(), "ruleResult");
        List scriptResult = (List)this.runtimeService.getVariable(processInstance.getId(), "scriptResult");
        DmnScriptOutputTest.assertNotNull((Object)ruleResult);
        DmnScriptOutputTest.assertNotNull((Object)scriptResult);
        DmnScriptOutputTest.assertEquals((int)2, (int)ruleResult.size());
        DmnScriptOutputTest.assertEquals((int)2, (int)scriptResult.size());
        for (Object output : ruleResult) {
            DmnScriptOutputTest.assertEquals((Object)"foo", output);
        }
        for (Object output : scriptResult) {
            DmnScriptOutputTest.assertEquals((Object)"foo", output);
        }
    }

    public void testMultipleEntriesList() {
        ProcessInstance processInstance = this.startTestProcess("multiple entries list");
        List ruleResult = (List)this.runtimeService.getVariable(processInstance.getId(), "ruleResult");
        List scriptResult = (List)this.runtimeService.getVariable(processInstance.getId(), "scriptResult");
        DmnScriptOutputTest.assertNotNull((Object)ruleResult);
        DmnScriptOutputTest.assertNotNull((Object)scriptResult);
        DmnScriptOutputTest.assertEquals((int)2, (int)ruleResult.size());
        DmnScriptOutputTest.assertEquals((int)2, (int)scriptResult.size());
        for (Map output : ruleResult) {
            DmnScriptOutputTest.assertEquals((int)2, (int)output.size());
            DmnScriptOutputTest.assertEquals((Object)"foo", output.get("result1"));
            DmnScriptOutputTest.assertEquals((Object)"foo", output.get("result2"));
        }
        for (Map output : scriptResult) {
            DmnScriptOutputTest.assertEquals((int)2, (int)output.size());
            DmnScriptOutputTest.assertEquals((Object)"foo", output.get("result1"));
            DmnScriptOutputTest.assertEquals((Object)"foo", output.get("result2"));
        }
    }

    public ProcessInstance startTestProcess(String input) {
        return this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("input", input));
    }
}

