/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.scripttask;

import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionOutput;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class DmnScriptTaskTest
extends PluggableProcessEngineTestCase {
    public static final String RESULT_VARIABLE = "decisionResult";
    public static final String RESULT_OK = "ok";
    public static final String RESULT_NOTOK = "notok";
    public static final String REASON_BRONZE = "work on your status first, as bronze you're not going to get anything";
    public static final String REASON_SILVER_OK = "you little fish will get what you want";
    public static final String REASON_SILVER_NOTOK = "you took too much man, you took too much!";
    public static final String REASON_GOLD = "you get anything you want";
    protected String processInstanceId;

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/scripttask/DmnScriptTaskTest.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/scripttask/DmnScriptTaskTest.dmn10.xml"})
    public void testDmnExampleWithScriptTask() {
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"bronze").putValue("sum", (Object)100);
        this.startProcess(variables);
        this.currentTaskIsRejectTask();
        DmnScriptTaskTest.assertEquals((String)RESULT_NOTOK, (String)this.getResultVariable());
        DmnScriptTaskTest.assertEquals((String)REASON_BRONZE, (String)this.getReasonVariable());
        this.completeProcess();
        variables.putValue("sum", (Object)10000);
        this.startProcess(variables);
        this.currentTaskIsRejectTask();
        DmnScriptTaskTest.assertEquals((String)RESULT_NOTOK, (String)this.getResultVariable());
        DmnScriptTaskTest.assertEquals((String)REASON_BRONZE, (String)this.getReasonVariable());
        this.completeProcess();
        variables.putValue("status", (Object)"silver").putValue("sum", (Object)999);
        this.startProcess(variables);
        this.currentTaskIsApproveTask();
        DmnScriptTaskTest.assertEquals((String)RESULT_OK, (String)this.getResultVariable());
        DmnScriptTaskTest.assertEquals((String)REASON_SILVER_OK, (String)this.getReasonVariable());
        this.completeProcess();
        variables.putValue("sum", (Object)1000);
        this.startProcess(variables);
        this.currentTaskIsRejectTask();
        DmnScriptTaskTest.assertEquals((String)RESULT_NOTOK, (String)this.getResultVariable());
        DmnScriptTaskTest.assertEquals((String)REASON_SILVER_NOTOK, (String)this.getReasonVariable());
        this.completeProcess();
        variables.putValue("sum", (Object)100000);
        this.startProcess(variables);
        this.currentTaskIsRejectTask();
        DmnScriptTaskTest.assertEquals((String)RESULT_NOTOK, (String)this.getResultVariable());
        DmnScriptTaskTest.assertEquals((String)REASON_SILVER_NOTOK, (String)this.getReasonVariable());
        this.completeProcess();
        variables.putValue("status", (Object)"gold").putValue("sum", (Object)0);
        this.startProcess(variables);
        this.currentTaskIsApproveTask();
        DmnScriptTaskTest.assertEquals((String)RESULT_OK, (String)this.getResultVariable());
        DmnScriptTaskTest.assertEquals((String)REASON_GOLD, (String)this.getReasonVariable());
        this.completeProcess();
        variables.putValue("sum", (Object)100000);
        this.startProcess(variables);
        this.currentTaskIsApproveTask();
        DmnScriptTaskTest.assertEquals((String)RESULT_OK, (String)this.getResultVariable());
        DmnScriptTaskTest.assertEquals((String)REASON_GOLD, (String)this.getReasonVariable());
        this.completeProcess();
    }

    protected void currentTaskIsRejectTask() {
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        DmnScriptTaskTest.assertEquals((String)"rejectTask", (String)task.getTaskDefinitionKey());
    }

    protected void currentTaskIsApproveTask() {
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        DmnScriptTaskTest.assertEquals((String)"approveTask", (String)task.getTaskDefinitionKey());
    }

    protected String getResultVariable() {
        return (String)this.getDecisionOutput().getValue("result");
    }

    protected String getReasonVariable() {
        return (String)this.getDecisionOutput().getValue("reason");
    }

    protected DmnDecisionOutput getDecisionOutput() {
        return (DmnDecisionOutput)this.runtimeService.getVariable(this.processInstanceId, RESULT_VARIABLE);
    }

    protected void startProcess(VariableMap variables) {
        this.processInstanceId = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
    }

    protected void completeTask() {
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
    }

    protected void completeProcess() {
        this.completeTask();
        this.assertProcessEnded(this.processInstanceId);
    }
}

