/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityStatistics;
import org.camunda.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class HistoricActivityStatisticsQueryTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testNoRunningProcessInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)0, (int)statistics.size());
    }

    @Deployment
    public void testSingleTask() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        HistoricActivityStatistics statistic = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)statistic.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)statistic.getInstances());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testFinishedProcessInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        this.completeProcessInstances();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)0, (int)statistics.size());
    }

    @Deployment
    public void testMultipleRunningTasks() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)4L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)4, (int)statistics.size());
        HistoricActivityStatistics innerTask = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"innerTask", (String)innerTask.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)25L, (long)innerTask.getInstances());
        HistoricActivityStatistics subProcess = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"subprocess", (String)subProcess.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)25L, (long)subProcess.getInstances());
        HistoricActivityStatistics subProcessMiBody = (HistoricActivityStatistics)statistics.get(2);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"subprocess#multiInstanceBody", (String)subProcessMiBody.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)subProcessMiBody.getInstances());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(3);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)task.getInstances());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testWithCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.calledProcess.bpmn20.xml"})
    public void testMultipleProcessDefinitions() {
        String processId = this.getProcessDefinitionId();
        String calledProcessId = this.getProcessDefinitionIdByKey("calledProcess");
        this.startProcesses(5);
        this.startProcessesByKey(10, "calledProcess");
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processId).orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        HistoricActivityStatistics calledActivity = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"callActivity", (String)calledActivity.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)calledActivity.getInstances());
        query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(calledProcessId).orderByActivityId().asc();
        statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)2, (int)statistics.size());
        HistoricActivityStatistics task1 = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task1", (String)task1.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)15L, (long)task1.getInstances());
        HistoricActivityStatistics task2 = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task2", (String)task2.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)15L, (long)task2.getInstances());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByFinished() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)2, (int)statistics.size());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"start", (String)start.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)start.getFinished());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)task.getFinished());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByFinishedAfterFinishingSomeInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        List tasks = this.taskService.createTaskQuery().list();
        for (int i = 0; i < 2; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)3L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)3, (int)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"end", (String)end.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)end.getFinished());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"start", (String)start.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)start.getFinished());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(2);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)3L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)task.getFinished());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testMultipleRunningTasks.bpmn20.xml"})
    public void testQueryByFinishedMultipleRunningTasks() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        List tasks = this.taskService.createTaskQuery().taskDefinitionKey("innerTask").list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)9L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)9, (int)statistics.size());
        HistoricActivityStatistics end1 = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"end1", (String)end1.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end1.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)end1.getFinished());
        HistoricActivityStatistics gtw = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"gtw", (String)gtw.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)gtw.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)gtw.getFinished());
        HistoricActivityStatistics innerEnd = (HistoricActivityStatistics)statistics.get(2);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"innerEnd", (String)innerEnd.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)innerEnd.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)25L, (long)innerEnd.getFinished());
        HistoricActivityStatistics innerStart = (HistoricActivityStatistics)statistics.get(3);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"innerStart", (String)innerStart.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)innerStart.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)25L, (long)innerStart.getFinished());
        HistoricActivityStatistics innerTask = (HistoricActivityStatistics)statistics.get(4);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"innerTask", (String)innerTask.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)innerTask.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)25L, (long)innerTask.getFinished());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(5);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"start", (String)start.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)start.getFinished());
        HistoricActivityStatistics subProcess = (HistoricActivityStatistics)statistics.get(6);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"subprocess", (String)subProcess.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)subProcess.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)25L, (long)subProcess.getFinished());
        HistoricActivityStatistics subProcessMiBody = (HistoricActivityStatistics)statistics.get(7);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"subprocess#multiInstanceBody", (String)subProcessMiBody.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)subProcessMiBody.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)subProcessMiBody.getFinished());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(8);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)task.getFinished());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByCompleteScope() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        this.completeProcessInstances();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCompleteScope();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"end", (String)end.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)end.getCompleteScope());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByCompleteScopeAfterFinishingSomeInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        List tasks = this.taskService.createTaskQuery().list();
        for (int i = 0; i < 2; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCompleteScope().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)2, (int)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"end", (String)end.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)end.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)3L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)task.getCompleteScope());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testMultipleRunningTasks.bpmn20.xml"})
    public void testQueryByCompleteScopeMultipleRunningTasks() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        List tasks = this.taskService.createTaskQuery().taskDefinitionKey("innerTask").list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCompleteScope().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)4L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)4, (int)statistics.size());
        HistoricActivityStatistics end1 = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"end1", (String)end1.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end1.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)end1.getCompleteScope());
        HistoricActivityStatistics innerEnd = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"innerEnd", (String)innerEnd.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)innerEnd.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)25L, (long)innerEnd.getCompleteScope());
        HistoricActivityStatistics subprocess = (HistoricActivityStatistics)statistics.get(2);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"subprocess", (String)subprocess.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)subprocess.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)25L, (long)subprocess.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(3);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)task.getCompleteScope());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByCanceled() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        this.cancelProcessInstances();
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)task.getCanceled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByCanceledAfterCancelingSomeInstances() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(3);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (ProcessInstance processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)3L, (long)task.getCanceled());
        this.completeProcessInstances();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByCanceledAndFinished() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (ProcessInstance processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeFinished().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)3L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)3, (int)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"end", (String)end.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getCanceled());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)end.getFinished());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"start", (String)start.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getCanceled());
        HistoricActivityStatisticsQueryTest.assertEquals((long)6L, (long)start.getFinished());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(2);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)task.getCanceled());
        HistoricActivityStatisticsQueryTest.assertEquals((long)4L, (long)task.getFinished());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByCanceledAndCompleteScope() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (ProcessInstance processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeCanceled().includeCompleteScope().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)2, (int)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"end", (String)end.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getCanceled());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)end.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)task.getCanceled());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)task.getCompleteScope());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByFinishedAndCompleteScope() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (ProcessInstance processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCompleteScope().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)3L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)3, (int)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"end", (String)end.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)end.getFinished());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)end.getCompleteScope());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"start", (String)start.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)6L, (long)start.getFinished());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(2);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)4L, (long)task.getFinished());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)task.getCompleteScope());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testQueryByFinishedAndCompleteScopeAndCanceled() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(2);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (ProcessInstance processInstance : processInstances) {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        }
        this.startProcesses(2);
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.startProcesses(2);
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId).includeFinished().includeCompleteScope().includeCanceled().orderByActivityId().asc();
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)3L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)3, (int)statistics.size());
        HistoricActivityStatistics end = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"end", (String)end.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)end.getCanceled());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)end.getFinished());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)end.getCompleteScope());
        HistoricActivityStatistics start = (HistoricActivityStatistics)statistics.get(1);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"start", (String)start.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getCanceled());
        HistoricActivityStatisticsQueryTest.assertEquals((long)6L, (long)start.getFinished());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)start.getCompleteScope());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(2);
        HistoricActivityStatisticsQueryTest.assertEquals((String)"task", (String)task.getId());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)task.getInstances());
        HistoricActivityStatisticsQueryTest.assertEquals((long)2L, (long)task.getCanceled());
        HistoricActivityStatisticsQueryTest.assertEquals((long)4L, (long)task.getFinished());
        HistoricActivityStatisticsQueryTest.assertEquals((long)0L, (long)task.getCompleteScope());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml"})
    public void testSorting() {
        String processDefinitionId = this.getProcessDefinitionId();
        this.startProcesses(5);
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        HistoricActivityStatisticsQueryTest.assertEquals((int)1, (int)((HistoricActivityStatisticsQuery)query.orderByActivityId().asc()).list().size());
        HistoricActivityStatisticsQueryTest.assertEquals((int)1, (int)((HistoricActivityStatisticsQuery)query.orderByActivityId().desc()).list().size());
        HistoricActivityStatisticsQueryTest.assertEquals((long)1L, (long)((HistoricActivityStatisticsQuery)query.orderByActivityId().asc()).count());
        HistoricActivityStatisticsQueryTest.assertEquals((long)1L, (long)((HistoricActivityStatisticsQuery)query.orderByActivityId().desc()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testSingleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricActivityStatisticsQueryTest.testAnotherSingleTask.bpmn20.xml"})
    public void testDifferentProcessesWithSameActivityId() {
        String processDefinitionId = this.getProcessDefinitionId();
        String anotherProcessDefinitionId = this.getProcessDefinitionIdByKey("anotherProcess");
        this.startProcesses(5);
        this.startProcessesByKey(10, "anotherProcess");
        HistoricActivityStatisticsQuery query = this.historyService.createHistoricActivityStatisticsQuery(processDefinitionId);
        List statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        HistoricActivityStatistics task = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((long)5L, (long)task.getInstances());
        query = this.historyService.createHistoricActivityStatisticsQuery(anotherProcessDefinitionId);
        statistics = query.list();
        HistoricActivityStatisticsQueryTest.assertEquals((long)1L, (long)query.count());
        HistoricActivityStatisticsQueryTest.assertEquals((int)1, (int)statistics.size());
        task = (HistoricActivityStatistics)statistics.get(0);
        HistoricActivityStatisticsQueryTest.assertEquals((long)10L, (long)task.getInstances());
    }

    protected void completeProcessInstances() {
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
    }

    protected void cancelProcessInstances() {
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        for (ProcessInstance pi : processInstances) {
            this.runtimeService.deleteProcessInstance(pi.getId(), "test");
        }
    }

    protected void startProcesses(int numberOfInstances) {
        this.startProcessesByKey(numberOfInstances, "process");
    }

    protected void startProcessesByKey(int numberOfInstances, String key) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey(key);
        }
    }

    protected String getProcessDefinitionIdByKey(String key) {
        return ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).singleResult()).getId();
    }

    protected String getProcessDefinitionId() {
        return this.getProcessDefinitionIdByKey("process");
    }
}

