/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.history.NativeHistoricCaseInstanceQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class HistoricCaseInstanceTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    public void testCaseInstanceProperties() {
        CaseInstance caseInstance = this.createCaseInstance();
        HistoricCaseInstance historicInstance = this.queryHistoricCaseInstance(caseInstance.getId());
        HistoricCaseInstanceTest.assertEquals((String)caseInstance.getId(), (String)historicInstance.getId());
        HistoricCaseInstanceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)historicInstance.getBusinessKey());
        HistoricCaseInstanceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)historicInstance.getCaseDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    public void testCaseInstanceStates() {
        String caseInstanceId = this.createCaseInstance().getId();
        HistoricCaseInstance historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        HistoricCaseInstanceTest.assertTrue((boolean)historicCaseInstance.isActive());
        this.assertCount(1L, this.historicQuery().active());
        this.assertCount(1L, this.historicQuery().notClosed());
        String stageExecutionId = this.queryCaseExecutionByActivityId("PI_Stage_1").getId();
        this.manualStart(stageExecutionId);
        historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        HistoricCaseInstanceTest.assertTrue((boolean)historicCaseInstance.isCompleted());
        this.assertCount(1L, this.historicQuery().completed());
        this.assertCount(1L, this.historicQuery().notClosed());
        this.reactivate(caseInstanceId);
        this.terminate(caseInstanceId);
        historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        HistoricCaseInstanceTest.assertTrue((boolean)historicCaseInstance.isTerminated());
        this.assertCount(1L, this.historicQuery().terminated());
        this.assertCount(1L, this.historicQuery().notClosed());
        this.reactivate(caseInstanceId);
        this.suspend(caseInstanceId);
        historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        HistoricCaseInstanceTest.assertTrue((boolean)((HistoricCaseInstanceEntity)historicCaseInstance).isSuspended());
        this.assertCount(1L, this.historicQuery().notClosed());
        this.close(caseInstanceId);
        historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        HistoricCaseInstanceTest.assertTrue((boolean)historicCaseInstance.isClosed());
        this.assertCount(1L, this.historicQuery().closed());
        this.assertCount(0L, this.historicQuery().notClosed());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    public void testHistoricCaseInstanceDates() {
        long duration = 259200000L;
        Date created = ClockUtil.getCurrentTime();
        Date closed = new Date(created.getTime() + duration);
        ClockUtil.setCurrentTime((Date)created);
        String caseInstanceId = this.createCaseInstance().getId();
        this.terminate(caseInstanceId);
        ClockUtil.setCurrentTime((Date)closed);
        this.close(caseInstanceId);
        HistoricCaseInstance historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        Date createTime = historicCaseInstance.getCreateTime();
        Date closeTime = historicCaseInstance.getCloseTime();
        Long durationInMillis = historicCaseInstance.getDurationInMillis();
        this.assertDateSimilar(created, createTime);
        this.assertDateSimilar(closed, closeTime);
        HistoricCaseInstanceTest.assertTrue((durationInMillis >= duration ? 1 : 0) != 0);
        HistoricCaseInstanceTest.assertTrue((durationInMillis < duration + 1000L ? 1 : 0) != 0);
        Date beforeCreate = new Date(created.getTime() - 3600000L);
        Date afterClose = new Date(closed.getTime() + 3600000L);
        this.assertCount(1L, this.historicQuery().createdAfter(beforeCreate));
        this.assertCount(0L, this.historicQuery().createdAfter(closed));
        this.assertCount(0L, this.historicQuery().createdBefore(beforeCreate));
        this.assertCount(1L, this.historicQuery().createdBefore(closed));
        this.assertCount(1L, this.historicQuery().closedAfter(created));
        this.assertCount(0L, this.historicQuery().closedAfter(afterClose));
        this.assertCount(0L, this.historicQuery().closedBefore(created));
        this.assertCount(1L, this.historicQuery().closedBefore(afterClose));
        this.assertCount(1L, this.historicQuery().closedBefore(afterClose).closedAfter(created));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    public void testCreateUser() {
        String userId = "test";
        this.identityService.setAuthenticatedUserId(userId);
        String caseInstanceId = this.createCaseInstance().getId();
        HistoricCaseInstance historicCaseInstance = this.queryHistoricCaseInstance(caseInstanceId);
        HistoricCaseInstanceTest.assertEquals((String)userId, (String)historicCaseInstance.getCreateUserId());
        this.assertCount(1L, this.historicQuery().createdBy(userId));
        this.identityService.setAuthenticatedUserId(null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSuperCaseInstance() {
        String caseInstanceId = this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = this.queryCaseExecutionByActivityId("PI_CaseTask_1").getId();
        this.manualStart(caseTaskId);
        HistoricCaseInstance historicCaseInstance = (HistoricCaseInstance)this.historicQuery().superCaseInstanceId(caseInstanceId).singleResult();
        HistoricCaseInstanceTest.assertNotNull((Object)historicCaseInstance);
        HistoricCaseInstanceTest.assertEquals((String)caseInstanceId, (String)historicCaseInstance.getSuperCaseInstanceId());
        String superCaseInstanceId = ((HistoricCaseInstance)this.historicQuery().subCaseInstanceId(historicCaseInstance.getId()).singleResult()).getId();
        HistoricCaseInstanceTest.assertEquals((String)caseInstanceId, (String)superCaseInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testHistoricCaseInstanceQuery() {
        CaseInstance oneTaskCase = this.createCaseInstanceByKey("oneTaskCase", "oneBusiness");
        CaseInstance twoTaskCase = this.createCaseInstanceByKey("twoTaskCase", "twoBusiness");
        this.assertCount(1L, this.historicQuery().caseInstanceId(oneTaskCase.getId()));
        this.assertCount(1L, this.historicQuery().caseInstanceId(twoTaskCase.getId()));
        HashSet<String> caseInstanceIds = new HashSet<String>();
        caseInstanceIds.add(oneTaskCase.getId());
        caseInstanceIds.add("unknown1");
        caseInstanceIds.add(twoTaskCase.getId());
        caseInstanceIds.add("unknown2");
        this.assertCount(2L, this.historicQuery().caseInstanceIds(caseInstanceIds));
        this.assertCount(1L, this.historicQuery().caseDefinitionId(oneTaskCase.getCaseDefinitionId()));
        this.assertCount(1L, this.historicQuery().caseDefinitionKey("oneTaskCase"));
        this.assertCount(2L, this.historicQuery().caseDefinitionKeyNotIn(Arrays.asList("unknown")));
        this.assertCount(1L, this.historicQuery().caseDefinitionKeyNotIn(Arrays.asList("oneTaskCase")));
        this.assertCount(0L, this.historicQuery().caseDefinitionKeyNotIn(Arrays.asList("oneTaskCase", "twoTaskCase")));
        try {
            this.historicQuery().caseDefinitionKeyNotIn(Arrays.asList(""));
            HistoricCaseInstanceTest.fail((String)"Exception expected");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        this.assertCount(1L, this.historicQuery().caseDefinitionName("One Task Case"));
        this.assertCount(2L, this.historicQuery().caseDefinitionNameLike("%T%"));
        this.assertCount(1L, this.historicQuery().caseDefinitionNameLike("One%"));
        this.assertCount(0L, this.historicQuery().caseDefinitionNameLike("%Process%"));
        this.assertCount(1L, this.historicQuery().caseInstanceBusinessKey("oneBusiness"));
        this.assertCount(2L, this.historicQuery().caseInstanceBusinessKeyLike("%Business"));
        this.assertCount(1L, this.historicQuery().caseInstanceBusinessKeyLike("one%"));
        this.assertCount(0L, this.historicQuery().caseInstanceBusinessKeyLike("%unknown%"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByVariable() {
        String caseInstanceId = this.createCaseInstance().getId();
        this.caseService.setVariable(caseInstanceId, "foo", (Object)"bar");
        this.caseService.setVariable(caseInstanceId, "number", (Object)10);
        this.assertCount(1L, this.historicQuery().variableValueEquals("foo", (Object)"bar"));
        this.assertCount(0L, this.historicQuery().variableValueNotEquals("foo", (Object)"bar"));
        this.assertCount(1L, this.historicQuery().variableValueNotEquals("foo", (Object)"lol"));
        this.assertCount(0L, this.historicQuery().variableValueEquals("foo", (Object)"lol"));
        this.assertCount(1L, this.historicQuery().variableValueLike("foo", "%a%"));
        this.assertCount(0L, this.historicQuery().variableValueLike("foo", "%lol%"));
        this.assertCount(1L, this.historicQuery().variableValueEquals("number", (Object)10));
        this.assertCount(0L, this.historicQuery().variableValueNotEquals("number", (Object)10));
        this.assertCount(1L, this.historicQuery().variableValueNotEquals("number", (Object)1));
        this.assertCount(1L, this.historicQuery().variableValueGreaterThan("number", (Object)1));
        this.assertCount(0L, this.historicQuery().variableValueLessThan("number", (Object)1));
        this.assertCount(1L, this.historicQuery().variableValueGreaterThanOrEqual("number", (Object)10));
        this.assertCount(0L, this.historicQuery().variableValueLessThan("number", (Object)10));
        this.assertCount(1L, this.historicQuery().variableValueLessThan("number", (Object)20));
        this.assertCount(0L, this.historicQuery().variableValueGreaterThan("number", (Object)20));
        this.assertCount(1L, this.historicQuery().variableValueLessThanOrEqual("number", (Object)10));
        this.assertCount(0L, this.historicQuery().variableValueGreaterThan("number", (Object)10));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCaseVariableValueEqualsNumber() throws Exception {
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)123L).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)12345L).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)123).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)123.0).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)123).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", null).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)Variables.longValue(null)).create();
        this.caseService.withCaseDefinitionByKey("oneTaskCase").setVariable("var", (Object)"123").create();
        HistoricCaseInstanceTest.assertEquals((long)4L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        HistoricCaseInstanceTest.assertEquals((long)4L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        HistoricCaseInstanceTest.assertEquals((long)4L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        HistoricCaseInstanceTest.assertEquals((long)4L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        HistoricCaseInstanceTest.assertEquals((long)1L, (long)this.historicQuery().variableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryPaging() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        HistoricCaseInstanceTest.assertEquals((int)3, (int)this.historicQuery().listPage(0, 3).size());
        HistoricCaseInstanceTest.assertEquals((int)2, (int)this.historicQuery().listPage(2, 2).size());
        HistoricCaseInstanceTest.assertEquals((int)1, (int)this.historicQuery().listPage(3, 2).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testQuerySorting() {
        String oneCaseInstanceId = this.createCaseInstanceByKey("oneTaskCase", "oneBusinessKey").getId();
        String twoCaseInstanceId = this.createCaseInstanceByKey("twoTaskCase", "twoBusinessKey").getId();
        this.terminate(oneCaseInstanceId);
        this.close(oneCaseInstanceId);
        ClockUtil.setCurrentTime((Date)DateTimeUtil.now().plusHours(1).toDate());
        this.terminate(twoCaseInstanceId);
        this.close(twoCaseInstanceId);
        HistoricCaseInstance oneCaseInstance = this.queryHistoricCaseInstance(oneCaseInstanceId);
        HistoricCaseInstance twoCaseInstance = this.queryHistoricCaseInstance(twoCaseInstanceId);
        String property = "id";
        List<Object> sortedList = Arrays.asList(oneCaseInstance.getId(), twoCaseInstance.getId());
        Collections.sort(sortedList);
        List instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceId().asc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1)))}));
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceId().desc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0)))}));
        property = "caseDefinitionId";
        sortedList = Arrays.asList(oneCaseInstance.getCaseDefinitionId(), twoCaseInstance.getCaseDefinitionId());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseDefinitionId().asc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1)))}));
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseDefinitionId().desc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0)))}));
        property = "businessKey";
        sortedList = Arrays.asList(oneCaseInstance.getBusinessKey(), twoCaseInstance.getBusinessKey());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceBusinessKey().asc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1)))}));
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceBusinessKey().desc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0)))}));
        property = "createTime";
        sortedList = Arrays.asList(oneCaseInstance.getCreateTime(), twoCaseInstance.getCreateTime());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceCreateTime().asc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1)))}));
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceCreateTime().desc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0)))}));
        property = "closeTime";
        sortedList = Arrays.asList(oneCaseInstance.getCloseTime(), twoCaseInstance.getCloseTime());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceCloseTime().asc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1)))}));
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceCloseTime().desc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0)))}));
        property = "durationInMillis";
        sortedList = Arrays.asList(oneCaseInstance.getDurationInMillis(), twoCaseInstance.getDurationInMillis());
        Collections.sort(sortedList);
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceDuration().asc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1)))}));
        instances = ((HistoricCaseInstanceQuery)this.historicQuery().orderByCaseInstanceDuration().desc()).list();
        HistoricCaseInstanceTest.assertEquals((int)2, (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(1))), Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)sortedList.get(0)))}));
    }

    public void testInvalidSorting() {
        try {
            this.historicQuery().asc();
            HistoricCaseInstanceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historicQuery().desc();
            HistoricCaseInstanceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historicQuery().orderByCaseInstanceId().count();
            HistoricCaseInstanceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testNativeQuery() {
        String id = this.createCaseInstance().getId();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        String tableName = this.managementService.getTableName(HistoricCaseInstance.class);
        HistoricCaseInstanceTest.assertEquals((String)"ACT_HI_CASEINST", (String)tableName);
        HistoricCaseInstanceTest.assertEquals((String)tableName, (String)this.managementService.getTableName(HistoricCaseInstanceEntity.class));
        HistoricCaseInstanceTest.assertEquals((int)4, (int)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT * FROM " + tableName)).list().size());
        HistoricCaseInstanceTest.assertEquals((long)4L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT count(*) FROM " + tableName)).count());
        HistoricCaseInstanceTest.assertEquals((long)16L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H1, " + tableName + " H2")).count());
        HistoricCaseInstanceTest.assertEquals((int)4, (int)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT DISTINCT * FROM " + tableName)).list().size());
        HistoricCaseInstanceTest.assertEquals((long)1L, (long)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H WHERE H.ID_ = '" + id + "'")).count());
        HistoricCaseInstanceTest.assertEquals((int)1, (int)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT * FROM " + tableName + " H WHERE H.ID_ = '" + id + "'")).list().size());
        HistoricCaseInstanceTest.assertEquals((long)1L, (long)((NativeHistoricCaseInstanceQuery)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H WHERE H.ID_ = #{caseInstanceId}")).parameter("caseInstanceId", (Object)id)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testNativeQueryPaging() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        String tableName = this.managementService.getTableName(HistoricCaseInstance.class);
        HistoricCaseInstanceTest.assertEquals((int)3, (int)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT * FROM " + tableName)).listPage(0, 3).size());
        HistoricCaseInstanceTest.assertEquals((int)2, (int)((NativeHistoricCaseInstanceQuery)this.historyService.createNativeHistoricCaseInstanceQuery().sql("SELECT * FROM " + tableName)).listPage(2, 2).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    public void testDeleteHistoricCaseInstance() {
        CaseInstance caseInstance = this.createCaseInstance();
        HistoricCaseInstance historicInstance = this.queryHistoricCaseInstance(caseInstance.getId());
        HistoricCaseInstanceTest.assertNotNull((Object)historicInstance);
        try {
            this.historyService.deleteHistoricCaseInstance(historicInstance.getId());
            HistoricCaseInstanceTest.fail((String)"Exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        this.terminate(caseInstance.getId());
        this.close(caseInstance.getId());
        this.historyService.deleteHistoricCaseInstance(historicInstance.getId());
        this.assertCount(0L, this.historicQuery());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySuperProcessInstanceId() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId);
        HistoricCaseInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricCaseInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricCaseInstance subCaseInstance = (HistoricCaseInstance)query.singleResult();
        HistoricCaseInstanceTest.assertNotNull((Object)subCaseInstance);
        HistoricCaseInstanceTest.assertEquals((String)superProcessInstanceId, (String)subCaseInstance.getSuperProcessInstanceId());
        HistoricCaseInstanceTest.assertNull((Object)subCaseInstance.getSuperCaseInstanceId());
    }

    public void testQueryByInvalidSuperProcessInstanceId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        query.superProcessInstanceId("invalid");
        HistoricCaseInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricCaseInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricCaseInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricCaseInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryBySubProcessInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        String processTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(processTaskId);
        String subProcessInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().superCaseInstanceId(superCaseInstanceId).singleResult()).getId();
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().subProcessInstanceId(subProcessInstanceId);
        HistoricCaseInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricCaseInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)query.singleResult();
        HistoricCaseInstanceTest.assertEquals((String)superCaseInstanceId, (String)caseInstance.getId());
        HistoricCaseInstanceTest.assertNull((Object)caseInstance.getSuperCaseInstanceId());
        HistoricCaseInstanceTest.assertNull((Object)caseInstance.getSuperProcessInstanceId());
    }

    public void testQueryByInvalidSubProcessInstanceId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        query.subProcessInstanceId("invalid");
        HistoricCaseInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricCaseInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricCaseInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricCaseInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySuperCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_CaseTask_1").singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(caseTaskId);
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().superCaseInstanceId(superCaseInstanceId);
        HistoricCaseInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricCaseInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)query.singleResult();
        HistoricCaseInstanceTest.assertEquals((String)superCaseInstanceId, (String)caseInstance.getSuperCaseInstanceId());
        HistoricCaseInstanceTest.assertNull((Object)caseInstance.getSuperProcessInstanceId());
    }

    public void testQueryByInvalidSuperCaseInstanceId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        query.superCaseInstanceId("invalid");
        HistoricCaseInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricCaseInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricCaseInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricCaseInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySubCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneCaseTaskCase").getId();
        String caseTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_CaseTask_1").singleResult()).getId();
        this.caseService.manuallyStartCaseExecution(caseTaskId);
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superCaseInstanceId(superCaseInstanceId).singleResult()).getId();
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        HistoricCaseInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricCaseInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)query.singleResult();
        HistoricCaseInstanceTest.assertEquals((String)superCaseInstanceId, (String)caseInstance.getId());
        HistoricCaseInstanceTest.assertNull((Object)caseInstance.getSuperProcessInstanceId());
        HistoricCaseInstanceTest.assertNull((Object)caseInstance.getSuperCaseInstanceId());
    }

    public void testQueryByInvalidSubCaseInstanceId() {
        HistoricCaseInstanceQuery query = this.historyService.createHistoricCaseInstanceQuery();
        query.subCaseInstanceId("invalid");
        HistoricCaseInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricCaseInstanceTest.assertEquals((int)0, (int)query.list().size());
        query.caseInstanceId(null);
        HistoricCaseInstanceTest.assertEquals((long)0L, (long)query.count());
        HistoricCaseInstanceTest.assertEquals((int)0, (int)query.list().size());
    }

    protected HistoricCaseInstance queryHistoricCaseInstance(String caseInstanceId) {
        HistoricCaseInstance historicCaseInstance = (HistoricCaseInstance)this.historicQuery().caseInstanceId(caseInstanceId).singleResult();
        HistoricCaseInstanceTest.assertNotNull((Object)historicCaseInstance);
        return historicCaseInstance;
    }

    protected HistoricCaseInstanceQuery historicQuery() {
        return this.historyService.createHistoricCaseInstanceQuery();
    }

    protected void assertCount(long count, HistoricCaseInstanceQuery historicQuery) {
        HistoricCaseInstanceTest.assertEquals((long)count, (long)historicQuery.count());
    }

    protected void assertDateSimilar(Date date1, Date date2) {
        long difference = Math.abs(date1.getTime() - date2.getTime());
        HistoricCaseInstanceTest.assertTrue((difference < 1000L ? 1 : 0) != 0);
    }
}

