/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.variable.Variables;

public class HistoricJobLogQueryTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQuery() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByLogId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String logId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().logId(logId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidLogId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().logId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.logId(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByJobId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidJobId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobId(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByJobExceptionMessage() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobExceptionMessage("Expected exception.");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidJobExceptionMessage() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobExceptionMessage("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobExceptionMessage(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByJobDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobDefinitionId = ((Job)this.managementService.createJobQuery().singleResult()).getJobDefinitionId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionId(jobDefinitionId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidJobDefinitionId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobDefinitionId(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByJobDefinitionType() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionType("async-continuation");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidJobDefinitionType() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionType("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobDefinitionType(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByJobDefinitionConfiguration() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration("async-before");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidJobDefinitionConfiguration() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.jobDefinitionConfiguration(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByActivityId() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().activityIdIn(new String[]{"serviceTask"});
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidActivityId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().activityIdIn(new String[]{"invalid"});
        this.verifyQueryResults(query, 0);
        String[] nullValue = null;
        try {
            query.activityIdIn(nullValue);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] activityIdsContainsNull = new String[]{"a", null, "b"};
        try {
            query.activityIdIn(activityIdsContainsNull);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] activityIdsContainsEmptyString = new String[]{"a", "", "b"};
        try {
            query.activityIdIn(activityIdsContainsEmptyString);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByExecutionId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String executionId = ((Job)this.managementService.createJobQuery().singleResult()).getExecutionId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().executionIdIn(new String[]{executionId});
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidExecutionId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().executionIdIn(new String[]{"invalid"});
        this.verifyQueryResults(query, 0);
        String[] nullValue = null;
        try {
            query.executionIdIn(nullValue);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] executionIdsContainsNull = new String[]{"a", null, "b"};
        try {
            query.executionIdIn(executionIdsContainsNull);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] executionIdsContainsEmptyString = new String[]{"a", "", "b"};
        try {
            query.executionIdIn(executionIdsContainsEmptyString);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByProcessInstanceId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = ((Job)this.managementService.createJobQuery().singleResult()).getProcessInstanceId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processInstanceId(processInstanceId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidProcessInstanceId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.processInstanceId(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByProcessDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String processDefinitionId = ((Job)this.managementService.createJobQuery().singleResult()).getProcessDefinitionId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processDefinitionId(processDefinitionId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidProcessDefinitionId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.processDefinitionId(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByProcessDefinitionKey() {
        this.runtimeService.startProcessInstanceByKey("process");
        String processDefinitionKey = ((Job)this.managementService.createJobQuery().singleResult()).getProcessDefinitionKey();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processDefinitionKey(processDefinitionKey);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidProcessDefinitionKey() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().processDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.processDefinitionKey(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByDeploymentId() {
        this.runtimeService.startProcessInstanceByKey("process");
        String deploymentId = ((Job)this.managementService.createJobQuery().singleResult()).getDeploymentId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().deploymentId(deploymentId);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidDeploymentId() {
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.deploymentId(null);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment
    public void testQueryByJobPriority() {
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            processInstances.add(this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List jobLogs = ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobPriorityLowerThanOrEquals(2L).orderByJobPriority().asc()).list();
        HistoricJobLogQueryTest.assertEquals((int)3, (int)jobLogs.size());
        for (HistoricJobLog log : jobLogs) {
            HistoricJobLogQueryTest.assertTrue((log.getJobPriority() <= 2L ? 1 : 0) != 0);
        }
        jobLogs = ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobPriorityHigherThanOrEquals(3L).orderByJobPriority().asc()).list();
        HistoricJobLogQueryTest.assertEquals((int)2, (int)jobLogs.size());
        for (HistoricJobLog log : jobLogs) {
            HistoricJobLogQueryTest.assertTrue((log.getJobPriority() >= 3L ? 1 : 0) != 0);
        }
        jobLogs = ((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobPriorityHigherThanOrEquals(1L).jobPriorityLowerThanOrEquals(3L).orderByJobPriority().asc()).list();
        HistoricJobLogQueryTest.assertEquals((int)3, (int)jobLogs.size());
        for (HistoricJobLog log : jobLogs) {
            HistoricJobLogQueryTest.assertTrue((log.getJobPriority() >= 1L && log.getJobPriority() <= 3L ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByCreationLog() {
        this.runtimeService.startProcessInstanceByKey("process");
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().creationLog();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByFailureLog() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogQueryTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().failureLog();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryBySuccessLog() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().successLog();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryByDeletionLog() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().deletionLog();
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQuerySorting() {
        for (int i = 0; i < 10; ++i) {
            this.runtimeService.startProcessInstanceByKey("process");
        }
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        query.orderByTimestamp().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByTimestamp());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobDefinitionId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobDefinitionId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobDueDate().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobDueDate());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobRetries().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobRetries());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByActivityId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByActivityId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByExecutionId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByExecutionId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessInstanceId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByProcessInstanceId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessDefinitionId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByProcessDefinitionId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessDefinitionKey().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByProcessDefinitionKey(this.processEngine));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByDeploymentId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByDeploymentId());
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobPriority().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.historicJobLogByJobPriority());
        query.orderByTimestamp().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByTimestamp()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobDefinitionId().asc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobDefinitionId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobDueDate().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobDueDate()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobRetries().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobRetries()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByActivityId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByActivityId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByExecutionId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByExecutionId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessInstanceId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByProcessInstanceId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessDefinitionId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByProcessDefinitionId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByProcessDefinitionKey().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByProcessDefinitionKey(this.processEngine)));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByDeploymentId().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByDeploymentId()));
        query = this.historyService.createHistoricJobLogQuery();
        query.orderByJobPriority().desc();
        this.verifyQueryWithOrdering(query, 10, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogByJobPriority()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQuerySortingPartiallyByOccurrence() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.executeAvailableJobs();
        this.runtimeService.setVariable(processInstanceId, "fail", (Object)false);
        this.managementService.executeJob(jobId);
        HistoricJobLogQuery query = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).orderPartiallyByOccurrence().asc();
        this.verifyQueryWithOrdering(query, 5, TestOrderingUtil.historicJobLogPartiallyByOccurence());
        query = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).orderPartiallyByOccurrence().desc();
        this.verifyQueryWithOrdering(query, 5, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogPartiallyByOccurence()));
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.executeAvailableJobs();
        this.managementService.deleteJob(jobId);
        query = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).orderPartiallyByOccurrence().asc();
        this.verifyQueryWithOrdering(query, 5, TestOrderingUtil.historicJobLogPartiallyByOccurence());
        query = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).orderPartiallyByOccurrence().desc();
        this.verifyQueryWithOrdering(query, 5, TestOrderingUtil.inverted(TestOrderingUtil.historicJobLogPartiallyByOccurence()));
    }

    protected void verifyQueryResults(HistoricJobLogQuery query, int countExpected) {
        HistoricJobLogQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        HistoricJobLogQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            HistoricJobLogQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            HistoricJobLogQueryTest.assertNull((Object)query.singleResult());
        }
    }

    protected void verifyQueryWithOrdering(HistoricJobLogQuery query, int countExpected, TestOrderingUtil.NullTolerantComparator<HistoricJobLog> expectedOrdering) {
        this.verifyQueryResults(query, countExpected);
        TestOrderingUtil.verifySorting(query.list(), expectedOrdering);
    }

    protected void verifySingleResultFails(HistoricJobLogQuery query) {
        try {
            query.singleResult();
            HistoricJobLogQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

