/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class OperationLogJobDefinitionTest
extends PluggableProcessEngineTestCase {
    public static final String USER_ID = "icke";

    public void setUp() throws Exception {
        this.identityService.setAuthenticatedUserId(USER_ID);
    }

    protected void tearDown() throws Exception {
        this.identityService.clearAuthentication();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetOverridingPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        OperationLogJobDefinitionTest.assertNotNull((Object)userOperationLogEntry);
        OperationLogJobDefinitionTest.assertEquals((String)"JobDefinition", (String)userOperationLogEntry.getEntityType());
        OperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)userOperationLogEntry.getJobDefinitionId());
        OperationLogJobDefinitionTest.assertEquals((String)"SetPriority", (String)userOperationLogEntry.getOperationType());
        OperationLogJobDefinitionTest.assertEquals((String)"overridingPriority", (String)userOperationLogEntry.getProperty());
        OperationLogJobDefinitionTest.assertEquals((String)"42", (String)userOperationLogEntry.getNewValue());
        OperationLogJobDefinitionTest.assertEquals(null, (String)userOperationLogEntry.getOrgValue());
        OperationLogJobDefinitionTest.assertEquals((String)USER_ID, (String)userOperationLogEntry.getUserId());
        OperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        OperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testOverwriteOverridingPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis()));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 10000L));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 43L);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)((UserOperationLogQuery)this.historyService.createUserOperationLogQuery().orderByTimestamp().desc()).listPage(0, 1).get(0);
        OperationLogJobDefinitionTest.assertNotNull((Object)userOperationLogEntry);
        OperationLogJobDefinitionTest.assertEquals((String)"JobDefinition", (String)userOperationLogEntry.getEntityType());
        OperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)userOperationLogEntry.getJobDefinitionId());
        OperationLogJobDefinitionTest.assertEquals((String)"SetPriority", (String)userOperationLogEntry.getOperationType());
        OperationLogJobDefinitionTest.assertEquals((String)"overridingPriority", (String)userOperationLogEntry.getProperty());
        OperationLogJobDefinitionTest.assertEquals((String)"43", (String)userOperationLogEntry.getNewValue());
        OperationLogJobDefinitionTest.assertEquals((String)"42", (String)userOperationLogEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testClearOverridingPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis()));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 10000L));
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)((UserOperationLogQuery)this.historyService.createUserOperationLogQuery().orderByTimestamp().desc()).listPage(0, 1).get(0);
        OperationLogJobDefinitionTest.assertNotNull((Object)userOperationLogEntry);
        OperationLogJobDefinitionTest.assertEquals((String)"JobDefinition", (String)userOperationLogEntry.getEntityType());
        OperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)userOperationLogEntry.getJobDefinitionId());
        OperationLogJobDefinitionTest.assertEquals((String)"SetPriority", (String)userOperationLogEntry.getOperationType());
        OperationLogJobDefinitionTest.assertEquals((String)"overridingPriority", (String)userOperationLogEntry.getProperty());
        OperationLogJobDefinitionTest.assertNull((Object)userOperationLogEntry.getNewValue());
        OperationLogJobDefinitionTest.assertEquals((String)"42", (String)userOperationLogEntry.getOrgValue());
        OperationLogJobDefinitionTest.assertEquals((String)USER_ID, (String)userOperationLogEntry.getUserId());
        OperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        OperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetOverridingPriorityCascadeToJobs() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L, true);
        OperationLogJobDefinitionTest.assertEquals((long)2L, (long)this.historyService.createUserOperationLogQuery().count());
        UserOperationLogEntry jobDefOpLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("JobDefinition").singleResult();
        OperationLogJobDefinitionTest.assertNotNull((Object)jobDefOpLogEntry);
        UserOperationLogEntry jobOpLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Job").singleResult();
        OperationLogJobDefinitionTest.assertNotNull((Object)jobOpLogEntry);
        OperationLogJobDefinitionTest.assertEquals((String)"both entries should be part of the same operation", (String)jobDefOpLogEntry.getOperationId(), (String)jobOpLogEntry.getOperationId());
        OperationLogJobDefinitionTest.assertEquals((String)"Job", (String)jobOpLogEntry.getEntityType());
        OperationLogJobDefinitionTest.assertNull((String)"id should null because it is a bulk update operation", (Object)jobOpLogEntry.getJobId());
        OperationLogJobDefinitionTest.assertEquals((String)"SetPriority", (String)jobOpLogEntry.getOperationType());
        OperationLogJobDefinitionTest.assertEquals((String)"priority", (String)jobOpLogEntry.getProperty());
        OperationLogJobDefinitionTest.assertEquals((String)"42", (String)jobOpLogEntry.getNewValue());
        OperationLogJobDefinitionTest.assertNull((String)"Original Value should be null because it is not known for bulk operations", (Object)jobOpLogEntry.getOrgValue());
        OperationLogJobDefinitionTest.assertEquals((String)USER_ID, (String)jobOpLogEntry.getUserId());
        OperationLogJobDefinitionTest.assertEquals((String)job.getJobDefinitionId(), (String)jobOpLogEntry.getJobDefinitionId());
        OperationLogJobDefinitionTest.assertNull((String)"an unspecified set of process instances was affected by the operation", (Object)jobOpLogEntry.getProcessInstanceId());
        OperationLogJobDefinitionTest.assertEquals((String)job.getProcessDefinitionId(), (String)jobOpLogEntry.getProcessDefinitionId());
        OperationLogJobDefinitionTest.assertEquals((String)job.getProcessDefinitionKey(), (String)jobOpLogEntry.getProcessDefinitionKey());
    }
}

