/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class OperationLogJobTest
extends PluggableProcessEngineTestCase {
    public static final String USER_ID = "icke";

    public void setUp() throws Exception {
        this.identityService.setAuthenticatedUserId(USER_ID);
    }

    protected void tearDown() throws Exception {
        this.identityService.clearAuthentication();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetJobPriority() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobPriority(job.getId(), 42L);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        OperationLogJobTest.assertNotNull((Object)userOperationLogEntry);
        OperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        OperationLogJobTest.assertEquals((String)job.getId(), (String)userOperationLogEntry.getJobId());
        OperationLogJobTest.assertEquals((String)"SetPriority", (String)userOperationLogEntry.getOperationType());
        OperationLogJobTest.assertEquals((String)"priority", (String)userOperationLogEntry.getProperty());
        OperationLogJobTest.assertEquals((String)"42", (String)userOperationLogEntry.getNewValue());
        OperationLogJobTest.assertEquals((String)"0", (String)userOperationLogEntry.getOrgValue());
        OperationLogJobTest.assertEquals((String)USER_ID, (String)userOperationLogEntry.getUserId());
        OperationLogJobTest.assertEquals((String)job.getJobDefinitionId(), (String)userOperationLogEntry.getJobDefinitionId());
        OperationLogJobTest.assertEquals((String)job.getProcessInstanceId(), (String)userOperationLogEntry.getProcessInstanceId());
        OperationLogJobTest.assertEquals((String)job.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        OperationLogJobTest.assertEquals((String)job.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
    }
}

