/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.jobexecutor.JobAcquisitionTestHelper;
import org.camunda.bpm.engine.test.jobexecutor.RecordingAcquireJobsRunnable;

public class JobAcquisitionBackoffTest
extends PluggableProcessEngineTestCase {
    protected static final int BASE_BACKOFF_TIME = 1000;
    protected static final int MAX_BACKOFF_TIME = 5000;
    protected static final int BACKOFF_FACTOR = 2;
    protected static final int BACKOFF_DECREASE_THRESHOLD = 2;
    protected static final int DEFAULT_NUM_JOBS_TO_ACQUIRE = 3;
    protected ControllableJobExecutor jobExecutor1;
    protected ControllableJobExecutor jobExecutor2;
    protected ConcurrencyTestCase.ThreadControl acquisitionThread1;
    protected ConcurrencyTestCase.ThreadControl acquisitionThread2;

    protected void setUp() throws Exception {
        this.jobExecutor1 = new ControllableJobExecutor((ProcessEngineImpl)this.processEngine);
        this.jobExecutor1.setMaxJobsPerAcquisition(3);
        this.jobExecutor1.setBackoffTimeInMillis(1000);
        this.jobExecutor1.setMaxBackoff(5000L);
        this.jobExecutor1.setBackoffDecreaseThreshold(2);
        this.acquisitionThread1 = this.jobExecutor1.getAcquisitionThreadControl();
        this.jobExecutor2 = new ControllableJobExecutor((ProcessEngineImpl)this.processEngine);
        this.jobExecutor2.setMaxJobsPerAcquisition(3);
        this.jobExecutor2.setBackoffTimeInMillis(1000);
        this.jobExecutor2.setMaxBackoff(5000L);
        this.jobExecutor2.setBackoffDecreaseThreshold(2);
        this.acquisitionThread2 = this.jobExecutor2.getAcquisitionThreadControl();
    }

    protected void tearDown() throws Exception {
        this.jobExecutor1.shutdown();
        this.jobExecutor2.shutdown();
        super.tearDown();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testBackoffOnOptimisticLocking() {
        for (int i = 0; i < 9; ++i) {
            this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess").getId();
        }
        JobAcquisitionTestHelper.suspendInstances(this.processEngine, 6);
        this.jobExecutor1.start();
        this.acquisitionThread1.waitForSync();
        this.jobExecutor2.start();
        this.acquisitionThread2.waitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor1WaitEvents = this.jobExecutor1.getAcquireJobsRunnable().getWaitEvents();
        JobAcquisitionBackoffTest.assertEquals((int)1, (int)jobExecutor1WaitEvents.size());
        JobAcquisitionBackoffTest.assertEquals((long)0L, (long)jobExecutor1WaitEvents.get(0).getWaitTime());
        this.acquisitionThread2.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor2WaitEvents = this.jobExecutor2.getAcquireJobsRunnable().getWaitEvents();
        JobAcquisitionBackoffTest.assertEquals((int)1, (int)jobExecutor2WaitEvents.size());
        RecordingAcquireJobsRunnable.RecordedWaitEvent waitEvent = jobExecutor2WaitEvents.get(0);
        JobAcquisitionTestHelper.assertInBetween(0L, 1500L, waitEvent.getWaitTime());
        JobAcquisitionTestHelper.activateInstances(this.processEngine, 6);
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedAcquisitionEvent> jobExecutor1AcquisitionEvents = this.jobExecutor1.getAcquireJobsRunnable().getAcquisitionEvents();
        RecordingAcquireJobsRunnable.RecordedAcquisitionEvent secondAcquisitionAttempt = jobExecutor1AcquisitionEvents.get(1);
        JobAcquisitionBackoffTest.assertEquals((int)3, (int)secondAcquisitionAttempt.getNumJobsToAcquire());
        jobExecutor1WaitEvents = this.jobExecutor1.getAcquireJobsRunnable().getWaitEvents();
        JobAcquisitionBackoffTest.assertEquals((int)2, (int)jobExecutor1WaitEvents.size());
        JobAcquisitionBackoffTest.assertEquals((long)0L, (long)jobExecutor1WaitEvents.get(1).getWaitTime());
        List<RecordingAcquireJobsRunnable.RecordedAcquisitionEvent> jobExecutor2AcquisitionEvents = this.jobExecutor2.getAcquireJobsRunnable().getAcquisitionEvents();
        secondAcquisitionAttempt = jobExecutor2AcquisitionEvents.get(1);
        JobAcquisitionBackoffTest.assertEquals((int)6, (int)secondAcquisitionAttempt.getNumJobsToAcquire());
        jobExecutor2WaitEvents = this.jobExecutor2.getAcquireJobsRunnable().getWaitEvents();
        JobAcquisitionBackoffTest.assertEquals((int)2, (int)jobExecutor2WaitEvents.size());
        RecordingAcquireJobsRunnable.RecordedWaitEvent secondWaitEvent = jobExecutor2WaitEvents.get(1);
        long expectedBackoffTime = 2000L;
        JobAcquisitionTestHelper.assertInBetween(1000L, expectedBackoffTime + expectedBackoffTime / 2L, secondWaitEvent.getWaitTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testBackoffDecrease() {
        for (int i = 0; i < 15; ++i) {
            this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess").getId();
        }
        JobAcquisitionTestHelper.suspendInstances(this.processEngine, 12);
        this.jobExecutor1.start();
        this.acquisitionThread1.waitForSync();
        this.jobExecutor2.start();
        this.acquisitionThread2.waitForSync();
        this.acquisitionThread1.makeContinueAndWaitForSync();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        this.jobExecutor1.shutdown();
        this.acquisitionThread1.waitUntilDone();
        this.acquisitionThread2.makeContinueAndWaitForSync();
        List<RecordingAcquireJobsRunnable.RecordedWaitEvent> jobExecutor2WaitEvents = this.jobExecutor2.getAcquireJobsRunnable().getWaitEvents();
        JobAcquisitionBackoffTest.assertEquals((int)1, (int)jobExecutor2WaitEvents.size());
        JobAcquisitionTestHelper.activateInstances(this.processEngine, 12);
        for (int i = 0; i < 2; ++i) {
            JobAcquisitionBackoffTest.assertTrue((jobExecutor2WaitEvents.get(i).getWaitTime() > 0L ? 1 : 0) != 0);
            this.acquisitionThread2.makeContinueAndWaitForSync();
            this.acquisitionThread2.makeContinueAndWaitForSync();
        }
        long lastBackoff = jobExecutor2WaitEvents.get(2).getWaitTime();
        JobAcquisitionBackoffTest.assertEquals((long)0L, (long)lastBackoff);
    }
}

