/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import junit.framework.TestCase;
import org.apache.ibatis.session.SqlSession;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class JobAcquisitionSuspensionStateTest
extends PluggableProcessEngineTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobAcquisitionForJobsWithoutSuspensionStateSet() {
        String processInstanceId = "1";
        String myCustomTimerEntity = "myCustomTimerEntity";
        final TimerEntity timer = new TimerEntity();
        timer.setRetries(3);
        timer.setDuedate(null);
        timer.setLockOwner(null);
        timer.setLockExpirationTime(null);
        timer.setJobHandlerType("timer-start-event");
        timer.setJobHandlerConfiguration("myCustomTimerEntity");
        timer.setProcessInstanceId("1");
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        try {
            commandExecutor.execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    commandContext.getJobManager().insert((DbEntity)timer);
                    return null;
                }
            });
            commandExecutor.execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    Connection connection = null;
                    Statement statement = null;
                    ResultSet rs = null;
                    try {
                        SqlSession sqlSession = commandContext.getDbSqlSession().getSqlSession();
                        connection = sqlSession.getConnection();
                        statement = connection.createStatement();
                        int updateResult = statement.executeUpdate("UPDATE ACT_RU_JOB SET SUSPENSION_STATE_ = NULL, REV_ = 2 WHERE SUSPENSION_STATE_ = 1");
                        statement.close();
                        TestCase.assertEquals((int)1, (int)updateResult);
                        statement = connection.createStatement();
                        rs = statement.executeQuery("SELECT * FROM ACT_RU_JOB WHERE SUSPENSION_STATE_ IS NULL");
                        int rowNum = 0;
                        while (rs.next()) {
                            rowNum = rs.getRow();
                        }
                        TestCase.assertEquals((int)1, (int)rowNum);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                            if (rs != null) {
                                rs.close();
                            }
                            if (connection != null) {
                                connection.close();
                            }
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return null;
                }
            });
            commandExecutor.execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    JobManager jobManager = commandContext.getJobManager();
                    List executableJobs = jobManager.findNextJobsToExecute(new Page(0, 1));
                    TestCase.assertEquals((int)1, (int)executableJobs.size());
                    TestCase.assertEquals((String)"myCustomTimerEntity", (String)((JobEntity)executableJobs.get(0)).getJobHandlerConfiguration());
                    executableJobs = jobManager.findExclusiveJobsToExecute("1");
                    TestCase.assertEquals((int)1, (int)executableJobs.size());
                    TestCase.assertEquals((String)"myCustomTimerEntity", (String)((JobEntity)executableJobs.get(0)).getJobHandlerConfiguration());
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            commandExecutor.execute((Command)new Command<Void>(timer){
                final /* synthetic */ TimerEntity val$timer;
                {
                    this.val$timer = timerEntity;
                }

                public Void execute(CommandContext commandContext) {
                    JobEntity newTimer = commandContext.getJobManager().findJobById(this.val$timer.getId());
                    newTimer.delete();
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(newTimer.getId());
                    return null;
                }
            });
            throw throwable;
        }
        commandExecutor.execute((Command)new /* invalid duplicate definition of identical inner class */);
    }
}

