/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.cmd.ExecuteJobsCmd;
import org.camunda.bpm.engine.impl.cmd.SetJobDefinitionPriorityCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendJobCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendJobDefinitionCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;

public class JobDefinitionFunctionalTest
extends PluggableProcessEngineTestCase {
    Thread testThread = Thread.currentThread();
    static ControllableThread activeThread;

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testCreateJobInstanceSuspended() {
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("simpleAsyncProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        JobDefinitionFunctionalTest.assertNotNull((Object)this.managementService.createJobQuery().suspended().singleResult());
        JobDefinitionFunctionalTest.assertNull((Object)this.managementService.createJobQuery().active().singleResult());
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testCreateJobInstanceActive() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        JobDefinitionFunctionalTest.assertNull((Object)this.managementService.createJobQuery().suspended().singleResult());
        JobDefinitionFunctionalTest.assertNotNull((Object)this.managementService.createJobQuery().active().singleResult());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testJobExecutorOnlyAcquiresActiveJobs() {
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("simpleAsyncProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        AcquiredJobs acquiredJobs = this.acquireJobs();
        JobDefinitionFunctionalTest.assertEquals((int)0, (int)acquiredJobs.size());
        this.managementService.activateJobDefinitionByProcessDefinitionKey("simpleAsyncProcess", true);
        acquiredJobs = this.acquireJobs();
        JobDefinitionFunctionalTest.assertEquals((int)1, (int)acquiredJobs.size());
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    @Deployment
    public void testExclusiveJobs() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().activityIdIn(new String[]{"task2"}).singleResult();
        this.managementService.suspendJobDefinitionById(jobDefinition.getId());
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.waitForJobExecutorToProcessAllJobs(6000L);
        JobDefinitionFunctionalTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionFunctionalTest.assertEquals((String)job.getJobDefinitionId(), (String)jobDefinition.getId());
        JobDefinitionFunctionalTest.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobDefinitionById(jobDefinition.getId(), true);
        this.waitForJobExecutorToProcessAllJobs(5000L);
        JobDefinitionFunctionalTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testSuspendJobDuringAcquisition() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        JobAcquisitionThread acquisitionThread = new JobAcquisitionThread();
        acquisitionThread.startAndWaitUntilControlIsReturned();
        JobSuspensionThread jobSuspensionThread = new JobSuspensionThread("simpleAsyncProcess");
        jobSuspensionThread.startAndWaitUntilControlIsReturned();
        jobSuspensionThread.proceedAndWaitTillDone();
        acquisitionThread.proceedAndWaitTillDone();
        JobDefinitionFunctionalTest.assertNull((Object)((Object)jobSuspensionThread.exception));
        JobDefinitionFunctionalTest.assertNull((Object)((Object)acquisitionThread.exception));
        JobDefinitionFunctionalTest.assertEquals((int)0, (int)acquisitionThread.acquiredJobs.size());
        acquisitionThread = new JobAcquisitionThread();
        acquisitionThread.startAndWaitUntilControlIsReturned();
        jobSuspensionThread = new JobSuspensionThread("simpleAsyncProcess");
        jobSuspensionThread.startAndWaitUntilControlIsReturned();
        acquisitionThread.proceedAndWaitTillDone();
        jobSuspensionThread.proceedAndWaitTillDone();
        JobDefinitionFunctionalTest.assertNull((Object)((Object)jobSuspensionThread.exception));
        JobDefinitionFunctionalTest.assertNull((Object)((Object)acquisitionThread.exception));
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testSuspendJobDuringExecution() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobExecutionThread executionthread = new JobExecutionThread(job.getId());
        executionthread.startAndWaitUntilControlIsReturned();
        JobSuspensionThread jobSuspensionThread = new JobSuspensionThread("simpleAsyncProcess");
        jobSuspensionThread.startAndWaitUntilControlIsReturned();
        jobSuspensionThread.proceedAndWaitTillDone();
        executionthread.proceedAndWaitTillDone();
        JobDefinitionFunctionalTest.assertNull((Object)((Object)jobSuspensionThread.exception));
        JobDefinitionFunctionalTest.assertNotNull((Object)((Object)executionthread.exception));
        executionthread = new JobExecutionThread(job.getId());
        executionthread.startAndWaitUntilControlIsReturned();
        jobSuspensionThread = new JobSuspensionThread("simpleAsyncProcess");
        jobSuspensionThread.startAndWaitUntilControlIsReturned();
        executionthread.proceedAndWaitTillDone();
        jobSuspensionThread.proceedAndWaitTillDone();
        JobDefinitionFunctionalTest.assertNull((Object)((Object)jobSuspensionThread.exception));
        JobDefinitionFunctionalTest.assertNull((Object)((Object)executionthread.exception));
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/JobDefinitionFunctionalTest.testRunningInstance.bpmn"})
    public void testNewSuspendedJobDuringRunningInstance() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.repositoryService.suspendProcessDefinitionById(processDefinition.getId());
        JobDefinitionFunctionalTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
        this.runtimeService.signal(processInstance.getId());
        JobDefinitionFunctionalTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().suspended().count());
        JobDefinitionFunctionalTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().active().count());
        JobDefinitionFunctionalTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testUpdateJobDefinitionPriority() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        List jobs = this.managementService.createJobQuery().list();
        JobExecutionThread executionThread = new JobExecutionThread(((Job)jobs.get(0)).getId());
        executionThread.startAndWaitUntilControlIsReturned();
        JobDefinitionPriorityThread priorityThread = new JobDefinitionPriorityThread(jobDefinition.getId(), 42L, true);
        priorityThread.startAndWaitUntilControlIsReturned();
        priorityThread.proceedAndWaitTillDone();
        List currentJobs = this.managementService.createJobQuery().list();
        for (Job job : currentJobs) {
            JobDefinitionFunctionalTest.assertEquals((long)42L, (long)job.getPriority());
        }
        executionThread.proceedAndWaitTillDone();
        JobDefinitionFunctionalTest.assertNull((Object)((Object)executionThread.exception));
        Job remainingJob = (Job)this.managementService.createJobQuery().singleResult();
        JobDefinitionFunctionalTest.assertNotNull((Object)remainingJob);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testParallelSuspensionAndPriorityUpdate() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobSuspensionByJobDefinitionThread suspensionThread = new JobSuspensionByJobDefinitionThread(jobDefinition.getId());
        suspensionThread.startAndWaitUntilControlIsReturned();
        JobDefinitionPriorityThread priorityUpdateThread = new JobDefinitionPriorityThread(jobDefinition.getId(), 42L, true);
        priorityUpdateThread.startAndWaitUntilControlIsReturned();
        suspensionThread.proceedAndWaitTillDone();
        priorityUpdateThread.proceedAndWaitTillDone();
        List updatedJobs = this.managementService.createJobQuery().list();
        JobDefinitionFunctionalTest.assertEquals((int)2, (int)updatedJobs.size());
        for (Job job : updatedJobs) {
            JobDefinitionFunctionalTest.assertEquals((long)42L, (long)job.getPriority());
            JobDefinitionFunctionalTest.assertTrue((boolean)job.isSuspended());
        }
    }

    protected AcquiredJobs acquireJobs() {
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        return (AcquiredJobs)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new AcquireJobsCmd(jobExecutor));
    }

    public class JobDefinitionPriorityThread
    extends ControllableThread {
        OptimisticLockingException exception;
        String jobDefinitionId;
        Long priority;
        boolean cascade;

        public JobDefinitionPriorityThread(String jobDefinitionId, Long priority, boolean cascade) {
            this.jobDefinitionId = jobDefinitionId;
            this.priority = priority;
            this.cascade = cascade;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                JobDefinitionFunctionalTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new SetJobDefinitionPriorityCmd(this.jobDefinitionId, this.priority, this.cascade)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
        }
    }

    public class JobSuspensionByJobDefinitionThread
    extends ControllableThread {
        OptimisticLockingException exception;
        String jobDefinitionId;

        public JobSuspensionByJobDefinitionThread(String jobDefinitionId) {
            this.jobDefinitionId = jobDefinitionId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                JobDefinitionFunctionalTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new SuspendJobCmd(null, this.jobDefinitionId, null, null, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }

    public class JobSuspensionThread
    extends ControllableThread {
        OptimisticLockingException exception;
        String processDefinitionKey;

        public JobSuspensionThread(String processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                JobDefinitionFunctionalTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new SuspendJobDefinitionCmd(null, null, this.processDefinitionKey, true, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }

    public class JobExecutionThread
    extends ControllableThread {
        OptimisticLockingException exception;
        String jobId;

        public JobExecutionThread(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                JobDefinitionFunctionalTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new ExecuteJobsCmd(this.jobId)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }

    public class JobAcquisitionThread
    extends ControllableThread {
        OptimisticLockingException exception;
        AcquiredJobs acquiredJobs;

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                JobExecutor jobExecutor = JobDefinitionFunctionalTest.this.processEngineConfiguration.getJobExecutor();
                this.acquiredJobs = (AcquiredJobs)JobDefinitionFunctionalTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new AcquireJobsCmd(jobExecutor)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }
}

