/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;

public class JobExecutorAcquireJobsByTypeAndDueDateTest
extends AbstractJobExecutorAcquireJobsTest {
    @Override
    protected boolean isJobExecutorPreferTimerJobs() {
        return true;
    }

    @Override
    protected boolean isJobExecutorPreferOldJobs() {
        return true;
    }

    public void testProcessEngineConfiguration() {
        ProcessEngineConfigurationImpl configuration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertTrue((boolean)configuration.isJobExecutorPreferTimerJobs());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertTrue((boolean)configuration.isJobExecutorAcquireByDueDate());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertFalse((boolean)configuration.isJobExecutorAcquireByPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testMessageJobHasDueDateSet() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertNotNull((Object)job.getDuedate());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertEquals((Object)ClockUtil.getCurrentTime(), (Object)job.getDuedate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/processWithTimerCatch.bpmn20.xml"})
    public void testTimerAndOldJobsArePreferred() {
        ProcessInstance timerProcess1 = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.incrementClock(1L);
        ProcessInstance asyncProcess1 = this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        this.incrementClock(1L);
        ProcessInstance timerProcess2 = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.incrementClock(61L);
        ProcessInstance asyncProcess2 = this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Job timerJob1 = (Job)this.managementService.createJobQuery().processInstanceId(timerProcess1.getId()).singleResult();
        Job timerJob2 = (Job)this.managementService.createJobQuery().processInstanceId(timerProcess2.getId()).singleResult();
        Job messageJob1 = (Job)this.managementService.createJobQuery().processInstanceId(asyncProcess1.getId()).singleResult();
        Job messageJob2 = (Job)this.managementService.createJobQuery().processInstanceId(asyncProcess2.getId()).singleResult();
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertNotNull((Object)timerJob1.getDuedate());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertNotNull((Object)timerJob2.getDuedate());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertNotNull((Object)messageJob1.getDuedate());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertNotNull((Object)messageJob2.getDuedate());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertTrue((boolean)messageJob1.getDuedate().before(timerJob1.getDuedate()));
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertTrue((boolean)timerJob1.getDuedate().before(timerJob2.getDuedate()));
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertTrue((boolean)timerJob2.getDuedate().before(messageJob2.getDuedate()));
        List<JobEntity> acquirableJobs = this.findAcquirableJobs();
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertEquals((int)4, (int)acquirableJobs.size());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertEquals((String)timerJob1.getId(), (String)acquirableJobs.get(0).getId());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertEquals((String)timerJob2.getId(), (String)acquirableJobs.get(1).getId());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertEquals((String)messageJob1.getId(), (String)acquirableJobs.get(2).getId());
        JobExecutorAcquireJobsByTypeAndDueDateTest.assertEquals((String)messageJob2.getId(), (String)acquirableJobs.get(3).getId());
    }
}

