/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobAcquisitionContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobAcquisitionStrategy;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.SequentialJobAcquisitionRunnable;

public class RecordingAcquireJobsRunnable
extends SequentialJobAcquisitionRunnable {
    protected List<RecordedWaitEvent> waitEvents = new ArrayList<RecordedWaitEvent>();
    protected List<RecordedAcquisitionEvent> acquisitionEvents = new ArrayList<RecordedAcquisitionEvent>();

    public RecordingAcquireJobsRunnable(JobExecutor jobExecutor) {
        super(jobExecutor);
    }

    protected void suspendAcquisition(long millis) {
        this.waitEvents.add(new RecordedWaitEvent(System.currentTimeMillis(), millis));
    }

    protected AcquiredJobs acquireJobs(JobAcquisitionContext context, JobAcquisitionStrategy configuration, ProcessEngineImpl currentProcessEngine) {
        this.acquisitionEvents.add(new RecordedAcquisitionEvent(System.currentTimeMillis(), configuration.getNumJobsToAcquire(currentProcessEngine.getName())));
        return super.acquireJobs(context, configuration, currentProcessEngine);
    }

    public List<RecordedWaitEvent> getWaitEvents() {
        return this.waitEvents;
    }

    public List<RecordedAcquisitionEvent> getAcquisitionEvents() {
        return this.acquisitionEvents;
    }

    public static class RecordedAcquisitionEvent {
        protected long timestamp;
        protected int numJobsToAcquire;

        public RecordedAcquisitionEvent(long timestamp, int numJobsToAcquire) {
            this.timestamp = timestamp;
            this.numJobsToAcquire = numJobsToAcquire;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getNumJobsToAcquire() {
            return this.numJobsToAcquire;
        }
    }

    public static class RecordedWaitEvent {
        protected long timestamp;
        protected long waitTime;

        public RecordedWaitEvent(long timestamp, long waitTime) {
            this.timestamp = timestamp;
            this.waitTime = waitTime;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getWaitTime() {
            return this.waitTime;
        }
    }
}

